/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.blobstore.stream.read.listener;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.UnaryOperator;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.common.io.Channels;
import org.opensearch.common.io.InputStreamContainer;

@InternalApi
class FilePartWriter {
    private static final int BUFFER_SIZE = 0xFD0000;

    FilePartWriter() {
    }

    public static void write(Path fileLocation, InputStreamContainer stream, UnaryOperator<InputStream> rateLimiter) throws IOException {
        try (FileChannel outputFileChannel = FileChannel.open(fileLocation, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
             InputStream inputStream = (InputStream)rateLimiter.apply(stream.getInputStream());){
            int bytesRead;
            long streamOffset = stream.getOffset();
            byte[] buffer = new byte[0xFD0000];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                Channels.writeToChannel(buffer, 0, bytesRead, outputFileChannel, streamOffset);
                streamOffset += (long)bytesRead;
            }
        }
    }
}

