/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.math.BigDecimal;
import java.util.Optional;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.rules.ImmutableSortRemoveRedundantRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexLiteral;
import org.immutables.value.Value;

@Value.Enclosing
public class SortRemoveRedundantRule
extends RelRule<Config>
implements TransformationRule {
    protected SortRemoveRedundantRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        if (RelOptUtil.isOffset(sort)) {
            return;
        }
        Double inputMaxRowCount = call.getMetadataQuery().getMaxRowCount(sort.getInput());
        Optional<BigDecimal> rowCountThreshold = SortRemoveRedundantRule.getRowCountThreshold(sort);
        if (!rowCountThreshold.isPresent()) {
            return;
        }
        if (inputMaxRowCount != null && Double.isFinite(inputMaxRowCount) && new BigDecimal(inputMaxRowCount).compareTo(rowCountThreshold.get()) <= 0) {
            call.transformTo(sort.getInput());
        }
    }

    private static Optional<BigDecimal> getRowCountThreshold(Sort sort) {
        if (RelOptUtil.isLimit(sort)) {
            assert (sort.fetch != null);
            BigDecimal fetch = ((RexLiteral)sort.fetch).getValueAs(BigDecimal.class);
            assert (fetch != null);
            if (fetch.equals(BigDecimal.ZERO)) {
                return Optional.empty();
            }
            if (RelOptUtil.isOrder(sort)) {
                return Optional.of(BigDecimal.ONE);
            }
            return Optional.of(fetch);
        }
        if (RelOptUtil.isPureOrder(sort)) {
            return Optional.of(BigDecimal.ONE);
        }
        return Optional.empty();
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableSortRemoveRedundantRule.Config.of().withOperandSupplier(b -> b.operand(Sort.class).anyInputs());

        @Override
        default public SortRemoveRedundantRule toRule() {
            return new SortRemoveRedundantRule(this);
        }
    }
}

