/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format.postgresql.format.compiled;

import java.text.ParseException;
import java.text.ParsePosition;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.Set;
import org.apache.calcite.util.format.postgresql.ChronoUnitEnum;
import org.apache.calcite.util.format.postgresql.PatternModifier;
import org.apache.calcite.util.format.postgresql.format.compiled.CompiledPattern;

public class AmPmCompiledPattern
extends CompiledPattern {
    private final boolean upperCase;
    private final boolean includePeriods;

    public AmPmCompiledPattern(Set<PatternModifier> modifiers, boolean upperCase, boolean includePeriods) {
        super(ChronoUnitEnum.HALF_DAYS, modifiers);
        this.upperCase = upperCase;
        this.includePeriods = includePeriods;
    }

    @Override
    public String convertToString(ZonedDateTime dateTime, Locale locale) {
        String stringValue;
        int intValue = dateTime.get(ChronoField.AMPM_OF_DAY);
        if (intValue == 0) {
            stringValue = this.includePeriods ? "a.m." : "am";
        } else {
            String string = stringValue = this.includePeriods ? "p.m." : "pm";
        }
        if (this.upperCase) {
            return stringValue.toUpperCase(Locale.ROOT);
        }
        return stringValue;
    }

    @Override
    public int parseValue(ParsePosition inputPosition, String input, boolean enforceLength, Locale locale) throws ParseException {
        String inputTrimmed;
        String pmValue;
        String amValue = this.includePeriods ? "a.m." : "am";
        String string = pmValue = this.includePeriods ? "p.m." : "pm";
        if (this.upperCase) {
            amValue = amValue.toUpperCase(Locale.ROOT);
            pmValue = pmValue.toUpperCase(Locale.ROOT);
        }
        if ((inputTrimmed = input.substring(inputPosition.getIndex())).startsWith(amValue)) {
            inputPosition.setIndex(inputPosition.getIndex() + amValue.length());
            return 0;
        }
        if (inputTrimmed.startsWith(pmValue)) {
            inputPosition.setIndex(inputPosition.getIndex() + pmValue.length());
            return 1;
        }
        throw new ParseException("Unable to parse value", inputPosition.getIndex());
    }

    @Override
    protected int getBaseFormatPatternLength() {
        return this.includePeriods ? 4 : 2;
    }
}

