/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.AssignationUtils;
import org.thymeleaf.standard.expression.Each;
import org.thymeleaf.standard.expression.EachUtils;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionCache;
import org.thymeleaf.standard.expression.ExpressionSequence;
import org.thymeleaf.standard.expression.ExpressionSequenceUtils;
import org.thymeleaf.standard.expression.FragmentSignature;
import org.thymeleaf.standard.expression.FragmentSignatureUtils;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressionPreprocessor;
import org.thymeleaf.util.Validate;

public final class StandardExpressionParser
implements IStandardExpressionParser {
    @Override
    public Expression parseExpression(IExpressionContext context, String input) {
        Validate.notNull(context, "Context cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return (Expression)StandardExpressionParser.parseExpression(context, input, true);
    }

    public AssignationSequence parseAssignationSequence(IExpressionContext context, String input, boolean allowParametersWithoutValue) {
        Validate.notNull(context, "Context cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return AssignationUtils.parseAssignationSequence(context, input, allowParametersWithoutValue);
    }

    public ExpressionSequence parseExpressionSequence(IExpressionContext context, String input) {
        Validate.notNull(context, "Context cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return ExpressionSequenceUtils.parseExpressionSequence(context, input);
    }

    public Each parseEach(IExpressionContext context, String input) {
        Validate.notNull(context, "Context cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return EachUtils.parseEach(context, input);
    }

    public FragmentSignature parseFragmentSignature(IEngineConfiguration configuration, String input) {
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return FragmentSignatureUtils.parseFragmentSignature(configuration, input);
    }

    static IStandardExpression parseExpression(IExpressionContext context, String input, boolean preprocess) {
        String preprocessedInput;
        IEngineConfiguration configuration = context.getConfiguration();
        IStandardExpression cachedExpression = ExpressionCache.getExpressionFromCache(configuration, preprocessedInput = preprocess ? StandardExpressionPreprocessor.preprocess(context, input) : input);
        if (cachedExpression != null) {
            return cachedExpression;
        }
        Expression expression = Expression.parse(preprocessedInput.trim());
        if (expression == null) {
            throw new TemplateProcessingException("Could not parse as expression: \"" + input + "\"");
        }
        ExpressionCache.putExpressionIntoCache(configuration, preprocessedInput, expression);
        return expression;
    }

    public String toString() {
        return "Standard Expression Parser";
    }
}

