/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.OperatorModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyNumberMultiplyNode;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PySequenceConcatNode;
import com.oracle.graal.python.lib.PySequenceInPlaceConcatNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(defineModule="_operator")
public final class OperatorModuleBuiltins
extends PythonBuiltins {
    protected static final String MODULE_NAME = "_operator";

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return OperatorModuleBuiltinsFactory.getFactories();
    }

    @Builtin(name="index", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IndexNode
    extends PythonUnaryBuiltinNode {
        IndexNode() {
        }

        @Specialization
        static Object asIndex(VirtualFrame frame, Object value, @Bind Node inliningTarget, @Cached PyNumberIndexNode index) {
            return index.execute((Frame)frame, inliningTarget, value);
        }
    }

    @Builtin(name="_compare_digest", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class CompareDigestNode
    extends PythonBinaryBuiltinNode {
        CompareDigestNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static boolean compare(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @Cached CastToJavaStringNode cast, @CachedLibrary(limit="3") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached PRaiseNode raiseNode) {
            try {
                String leftString = cast.execute(left);
                String rightString = cast.execute(right);
                return CompareDigestNode.tscmp(leftString, rightString);
            }
            catch (CannotCastException e) {
                if (!bufferAcquireLib.hasBuffer(left) || !bufferAcquireLib.hasBuffer(right)) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.UNSUPPORTED_OPERAND_TYPES_OR_COMBINATION_OF_TYPES, left, right);
                }
                Object savedState = ExecutionContext.IndirectCallContext.enter(frame, inliningTarget, indirectCallData);
                Object leftBuffer = bufferAcquireLib.acquireReadonly(left);
                try {
                    Object rightBuffer = bufferAcquireLib.acquireReadonly(right);
                    try {
                        boolean bl = CompareDigestNode.tscmp(bufferLib.getCopiedByteArray(leftBuffer), bufferLib.getCopiedByteArray(rightBuffer));
                        bufferLib.release(rightBuffer);
                        return bl;
                    }
                    catch (Throwable throwable) {
                        bufferLib.release(rightBuffer);
                        throw throwable;
                    }
                }
                finally {
                    bufferLib.release(leftBuffer);
                    ExecutionContext.IndirectCallContext.exit(frame, inliningTarget, indirectCallData, savedState);
                }
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean tscmp(String leftIn, String right) {
            String left = leftIn;
            int result = 0;
            if (left.length() != right.length()) {
                left = right;
                result = 1;
            }
            for (int i = 0; i < left.length(); ++i) {
                result |= left.charAt(i) ^ right.charAt(i);
            }
            return result == 0;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean tscmp(byte[] leftIn, byte[] right) {
            byte[] left = leftIn;
            int result = 0;
            if (left.length != right.length) {
                left = right;
                result = 1;
            }
            for (int i = 0; i < left.length; ++i) {
                result |= left[i] ^ right[i];
            }
            return result == 0;
        }
    }

    @Builtin(name="mul", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class MulNode
    extends PythonBinaryBuiltinNode {
        MulNode() {
        }

        @Specialization
        static Object doObject(VirtualFrame frame, Object left, Object right, @Cached PyNumberMultiplyNode mulNode) {
            return mulNode.execute(frame, left, right);
        }
    }

    @Builtin(name="iconcat", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class IConcatNode
    extends PythonBinaryBuiltinNode {
        IConcatNode() {
        }

        @Specialization
        static Object doObject(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached PySequenceInPlaceConcatNode concatNode) {
            return concatNode.execute(frame, inliningTarget, left, right);
        }
    }

    @Builtin(name="concat", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ConcatNode
    extends PythonBinaryBuiltinNode {
        ConcatNode() {
        }

        @Specialization
        static Object doObject(VirtualFrame frame, Object left, Object right, @Bind Node inliningTarget, @Cached PySequenceConcatNode concatNode) {
            return concatNode.execute(frame, inliningTarget, left, right);
        }
    }

    @Builtin(name="getitem", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GetItemNode
    extends PythonBinaryBuiltinNode {
        GetItemNode() {
        }

        @Specialization
        static Object doObject(VirtualFrame frame, Object value, Object index, @Bind Node inliningTarget, @Cached PyObjectGetItem getItem) {
            return getItem.execute((Frame)frame, inliningTarget, value, index);
        }
    }

    @Builtin(name="truth", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class TruthNode
    extends PythonUnaryBuiltinNode {
        TruthNode() {
        }

        @Specialization
        static Object doObject(VirtualFrame frame, Object object, @Cached PyObjectIsTrueNode isTrueNode) {
            return isTrueNode.execute((Frame)frame, object);
        }
    }
}

