/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.sql.JDBCType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import schemacrawler.schema.JavaSqlType;
import schemacrawler.schema.JavaSqlTypeGroup;
import schemacrawler.utility.TypeMap;
import us.fatehi.utility.Utility;

public final class JavaSqlTypes
implements Iterable<JavaSqlType> {
    private final Map<Integer, JavaSqlType> javaSqlTypeMap;

    public JavaSqlTypes() {
        TypeMap typeMap = new TypeMap();
        this.javaSqlTypeMap = new HashMap<Integer, JavaSqlType>();
        for (JDBCType sqlType : JDBCType.values()) {
            Integer sqlTypeInt = sqlType.getVendorTypeNumber();
            JavaSqlTypeGroup sqlTypeGroup = JavaSqlTypeGroup.valueOf(sqlTypeInt);
            Object mappedClass = typeMap.get(sqlType.getName());
            JavaSqlType javaSqlType = new JavaSqlType(sqlType, (Class<?>)mappedClass, sqlTypeGroup);
            this.javaSqlTypeMap.put(sqlTypeInt, javaSqlType);
        }
    }

    public JavaSqlType getFromJavaSqlTypeName(String typeName) {
        JavaSqlType sqlDataType = JavaSqlType.UNKNOWN;
        if (Utility.isBlank(typeName)) {
            return sqlDataType;
        }
        for (JavaSqlType javaSqlType : this.javaSqlTypeMap.values()) {
            if (!typeName.equalsIgnoreCase(javaSqlType.getName())) continue;
            sqlDataType = javaSqlType;
            break;
        }
        return sqlDataType;
    }

    @Override
    public Iterator<JavaSqlType> iterator() {
        return this.javaSqlTypeMap.values().iterator();
    }

    public int size() {
        return this.javaSqlTypeMap.size();
    }

    public String toString() {
        return this.javaSqlTypeMap.toString();
    }

    public JavaSqlType valueOf(int key) {
        if (this.javaSqlTypeMap.containsKey(key)) {
            return this.javaSqlTypeMap.get(key);
        }
        return JavaSqlType.UNKNOWN;
    }
}

