/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.wrappers.db2;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.db.SqlStatementKey;
import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.db.db2.StaticProfileSection;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.wrappers.ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.ExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.JDBCDynamicExecutionHandlerPropertiesRefresh;
import com.ibm.db2.cmx.runtime.internal.wrappers.PreparedStatementExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.ResultSetExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2ParameterMetaDataExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2ResultSetExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.db2.DB2StatementExecutionHandler;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.tools.internal.binder.BindLexer;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import com.ibm.db2.jcc.DB2BlobFileReference;
import com.ibm.db2.jcc.DB2ClobFileReference;
import com.ibm.db2.jcc.DB2PreparedStatement;
import com.ibm.db2.jcc.DB2XmlAsBlobFileReference;
import com.ibm.db2.jcc.DB2XmlAsClobFileReference;
import com.ibm.db2.jcc.DBPreparedStatementInfoInterface;
import com.ibm.db2.jcc.DBTimestamp;
import com.ibm.db2.jcc.SQLJPreparedStatement;
import com.ibm.db2.jcc.SQLJResultSet;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;

public class DB2PreparedStatementExecutionHandler
extends DB2StatementExecutionHandler
implements PreparedStatementExecutionHandler {
    private static Method methodSetSQLXML_ = null;
    private static boolean isJava6TestNeeded_ = true;
    private PreparedStatement physicalPreparedStatement_ = null;
    private DB2ConnectionExecutionHandler db2ConnExecutionHandler_;
    private StaticProfileSection staticSectionForThisStmt_;
    protected boolean isHomogeneousBatch_ = false;
    boolean isDBBatch_ = false;
    boolean isAddBatchDone_ = false;
    private boolean clearParametersJustDone_ = false;
    private int batchCount_ = 0;
    protected boolean sectionReplacedForSetMaxRows_ = false;
    protected SqlStatementKey stmtKey_;

    public DB2PreparedStatementExecutionHandler(DB2ConnectionExecutionHandler dB2ConnectionExecutionHandler, PreparedStatement preparedStatement, String string, int n2, int n3, int n4, String[] stringArray, int[] nArray, int n5, String string2, Method method, Object ... objectArray) throws SQLException {
        super(dB2ConnectionExecutionHandler, (Statement)preparedStatement, n2, n3, n4, stringArray, nArray, n5, string2, method, objectArray);
        this.db2ConnExecutionHandler_ = dB2ConnectionExecutionHandler;
        this.sqlStr_ = string;
        this.physicalPreparedStatement_ = preparedStatement;
        this.testAndGetNeededJava6Methods();
    }

    public DB2PreparedStatementExecutionHandler(DB2ConnectionExecutionHandler dB2ConnectionExecutionHandler, PreparedStatement preparedStatement, String string, int n2, int n3, int n4, String[] stringArray, int[] nArray, int n5, StaticProfileSection staticProfileSection, String string2, Method method, Object ... objectArray) throws SQLException {
        super(dB2ConnectionExecutionHandler, (Statement)preparedStatement, n2, n3, n4, stringArray, nArray, n5, string2, method, objectArray);
        this.db2ConnExecutionHandler_ = dB2ConnectionExecutionHandler;
        this.sqlStr_ = string;
        this.physicalPreparedStatement_ = preparedStatement;
        this.initializePreparedStatement(dB2ConnectionExecutionHandler, string, staticProfileSection);
        this.testAndGetNeededJava6Methods();
    }

    private void testAndGetNeededJava6Methods() {
        if (isJava6TestNeeded_) {
            isJava6TestNeeded_ = false;
            Class<?> clazz = null;
            try {
                clazz = DB2PreparedStatementExecutionHandler.getClassForNameUseThreadContextClassLoader("java.sql.SQLXML");
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (clazz != null) {
                methodSetSQLXML_ = DB2PreparedStatementExecutionHandler.findMethod(this.physicalPreparedStatement_.getClass(), "setSQLXML", Integer.TYPE, clazz);
            }
        }
    }

    private void initializePreparedStatement(DB2ConnectionExecutionHandler dB2ConnectionExecutionHandler, String string, StaticProfileSection staticProfileSection) throws SQLException {
        this.staticSectionForThisStmt_ = staticProfileSection;
        if (null != this.staticSectionForThisStmt_) {
            this.logger_ = staticLogger__;
            this.setIsSELECTorXQUERY(this.staticSectionForThisStmt_.isQuery());
            this.cursorName_ = this.staticSectionForThisStmt_.getCursorName();
            ((SQLJPreparedStatement)this.physicalPreparedStatement_).setSection(this.staticSectionForThisStmt_);
            if (this.logger_.isLoggable(Level.FINER)) {
                DataLogger.logAtLevelFiner(this.logger_, this, "initializePreparedStatement", "static statement:" + this.staticSectionForThisStmt_.getStaticProfilePackage().getPackageName() + ":" + this.staticSectionForThisStmt_.getSectionNumber() + ": " + string);
            }
            if (dbLogger__.isLoggable(Level.FINEST)) {
                dbLogger__.logp(Level.FINEST, "DB2PreparedStatementExecutionHandler", "initializePreparedStatement", "Static statement: " + this.staticSectionForThisStmt_.getStaticProfilePackage().getPackageName() + ":" + this.staticSectionForThisStmt_.getSectionNumber() + ": " + string);
            }
        } else {
            this.logger_ = dynamicLogger__;
            this.setIsSELECTorXQUERY(StaticProfileConstants.isStatementOfType(this.sqlStr_, SqlStatementType.QUERY, SqlStatementType.XQUERY));
            if (this.logger_.isLoggable(Level.FINER)) {
                DataLogger.logAtLevelFiner(this.logger_, this, "Constructor", "dynamic statement: " + string);
            }
            if (dbLogger__.isLoggable(Level.FINER)) {
                dbLogger__.logp(Level.FINER, "DB2PreparedStatementExecutionHandler", "initializePreparedStatement", "Dynamic statement: " + string);
            }
        }
        this.initNamedParamMap();
        this.initializeMetadataCorrelator(string);
    }

    @Override
    protected void initNamedParamMap() {
        if (this.staticSectionForThisStmt_ != null) {
            this.NamedParamMap_ = this.staticSectionForThisStmt_.getNamedParamMap();
        } else {
            super.initNamedParamMap();
        }
    }

    public void setStmtKey(SqlStatementKey sqlStatementKey) {
        this.stmtKey_ = sqlStatementKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(String string, Method method, Object[] objectArray) throws Throwable {
        boolean bl2 = false;
        Connection connection = this.db2ConnectionExecutionHandler_.physicalConnection_;
        synchronized (connection) {
            Object object;
            Object object2;
            block45: {
                block46: {
                    Object object3;
                    block41: {
                        block42: {
                            object2 = null;
                            try {
                                block43: {
                                    block60: {
                                        block44: {
                                            block61: {
                                                block62: {
                                                    block59: {
                                                        block58: {
                                                            block57: {
                                                                block56: {
                                                                    block55: {
                                                                        block54: {
                                                                            block53: {
                                                                                block49: {
                                                                                    block52: {
                                                                                        block51: {
                                                                                            block50: {
                                                                                                block48: {
                                                                                                    block47: {
                                                                                                        if (this.db2ConnectionExecutionHandler_.driverTraceOn_) {
                                                                                                            this.db2ConnectionExecutionHandler_.driverLogWriter_.println(this.db2ConnectionExecutionHandler_.buildDriverTraceHeader(this, "invoke") + "[" + string + "] enter...");
                                                                                                        }
                                                                                                        if (this.db2ConnectionExecutionHandler_.isClosed_) {
                                                                                                            Object object4 = method.invoke((Object)this.physicalStatement_, objectArray);
                                                                                                            return object4;
                                                                                                        }
                                                                                                        if (this.logger_.isLoggable(Level.FINER)) {
                                                                                                            if (string.equals("equals") || string.equals("hashCode") || string.equals("toString")) {
                                                                                                                object3 = method.invoke((Object)this.physicalStatement_, objectArray);
                                                                                                                if (!this.db2ConnectionExecutionHandler_.driverTraceOn_) break block41;
                                                                                                                break block42;
                                                                                                            }
                                                                                                            DataLogger.logAtLevelFiner(this.logger_, this, "invoke: " + string, "ENTRY " + Arrays.deepToString(objectArray));
                                                                                                            bl2 = true;
                                                                                                        }
                                                                                                        if (this.clearParametersJustDone_) {
                                                                                                            if (this.isWcoWithPropertiesRefresh_) {
                                                                                                                this.db2ConnectionExecutionHandler_.validatePreparedStatement(this);
                                                                                                            }
                                                                                                            this.clearParametersJustDone_ = false;
                                                                                                        }
                                                                                                        if (this.propertyRefreshEnabled_ && (string.startsWith("set") || string.startsWith("closeOn"))) {
                                                                                                            this.modifiedStatementAttributes_.saveModifiedAttributeIfNeeded(string, method, objectArray);
                                                                                                        }
                                                                                                        if (!string.startsWith("set") || objectArray == null || objectArray.length != 2 && objectArray.length != 3) break block47;
                                                                                                        this.setIsParameterizedDynamicStatement(true);
                                                                                                        if (string.startsWith("setJcc") && this.NamedParamMap_ != null) {
                                                                                                            this.setJccXXXAtName(method, objectArray);
                                                                                                            break block43;
                                                                                                        } else if (this.checkIfForwardToDummyStatementRequired(string, objectArray)) {
                                                                                                            object2 = method.invoke((Object)this.db2ConnectionExecutionHandler_.dummyStatementForLiteralSubstitution_, objectArray);
                                                                                                            break block43;
                                                                                                        } else {
                                                                                                            boolean bl3 = false;
                                                                                                            if (this.litInfo_ != null && this.litInfo_.isStatementUsingParamterMarker() && objectArray[0] instanceof Integer) {
                                                                                                                int n2 = (Integer)objectArray[0];
                                                                                                                Integer n3 = this.litInfo_.getParameterMappedIndex(n2);
                                                                                                                if (n3 != null) {
                                                                                                                    objectArray[0] = n3;
                                                                                                                } else {
                                                                                                                    if (this.db2ConnectionExecutionHandler_.dummyStatementForLiteralSubstitution_ == null) {
                                                                                                                        this.db2ConnectionExecutionHandler_.dummyStatementForLiteralSubstitution_ = this.db2ConnectionExecutionHandler_.physicalConnection_.prepareCall("select 1 from sysibm.sysdummy1");
                                                                                                                    }
                                                                                                                    bl3 = true;
                                                                                                                }
                                                                                                            }
                                                                                                            object2 = bl3 ? method.invoke((Object)this.db2ConnectionExecutionHandler_.dummyStatementForLiteralSubstitution_, objectArray) : method.invoke((Object)this.physicalPreparedStatement_, objectArray);
                                                                                                        }
                                                                                                        break block43;
                                                                                                    }
                                                                                                    if (!string.equals("getParameterMetaData")) break block48;
                                                                                                    if (this.checkIfForwardToDummyStatementRequired(string, objectArray)) {
                                                                                                        object2 = method.invoke((Object)this.db2ConnectionExecutionHandler_.dummyStatementForLiteralSubstitution_, objectArray);
                                                                                                        break block43;
                                                                                                    } else {
                                                                                                        object2 = method.invoke((Object)this.physicalPreparedStatement_, objectArray);
                                                                                                        if (this.litInfo_ != null && this.litInfo_.isLiteralSubstitutionAllowed() && this.litInfo_.isStatementUsingParamterMarker()) {
                                                                                                            object2 = new DB2ParameterMetaDataExecutionHandler(this, (ParameterMetaData)object2, this.litInfo_);
                                                                                                        }
                                                                                                    }
                                                                                                    break block43;
                                                                                                }
                                                                                                if (!string.startsWith("execute")) break block49;
                                                                                                this.releaseStaticUpdateableCursor();
                                                                                                this.resultSet_ = null;
                                                                                                if (!string.equals("executeQuery") || objectArray != null) break block50;
                                                                                                object2 = this.executeQuery();
                                                                                                break block43;
                                                                                            }
                                                                                            if (!string.equals("executeUpdate") || objectArray != null) break block51;
                                                                                            object2 = this.executeUpdate();
                                                                                            break block43;
                                                                                        }
                                                                                        if (!string.equals("execute") || objectArray != null) break block52;
                                                                                        object2 = this.execute();
                                                                                        break block43;
                                                                                    }
                                                                                    if (string.equals("executeBatch") && objectArray == null) {
                                                                                        object2 = this.executeBatch();
                                                                                        break block43;
                                                                                    } else if (string.equals("executeDB2QueryBatch") && objectArray == null) {
                                                                                        this.executeDB2QueryBatch();
                                                                                        break block43;
                                                                                    } else {
                                                                                        object2 = method.invoke((Object)this.physicalPreparedStatement_, objectArray);
                                                                                    }
                                                                                    break block43;
                                                                                }
                                                                                if (!string.equals("getMoreResults")) break block53;
                                                                                object2 = objectArray == null ? Boolean.valueOf(this.getMoreResults()) : Boolean.valueOf(this.getMoreResults((Integer)objectArray[0]));
                                                                                break block43;
                                                                            }
                                                                            if (!string.equals("setCursorName")) break block54;
                                                                            this.setCursorName(method, objectArray);
                                                                            break block43;
                                                                        }
                                                                        if (!string.equals("clearBatch")) break block55;
                                                                        this.clearBatch();
                                                                        break block43;
                                                                    }
                                                                    if (!string.equals("close")) break block56;
                                                                    this.close();
                                                                    break block43;
                                                                }
                                                                if (!string.equals("getGeneratedKeys")) break block57;
                                                                object2 = this.getGeneratedKeys();
                                                                break block43;
                                                            }
                                                            if (!string.equals("addBatch")) break block58;
                                                            object2 = this.addBatch(method, objectArray);
                                                            break block43;
                                                        }
                                                        if (!string.equals("getUpdateCount")) break block59;
                                                        object2 = this.getUpdateCount();
                                                        break block43;
                                                    }
                                                    if (!string.equals("clearParameters")) break block60;
                                                    if (this.litInfo_ == null || !this.litInfo_.isLiteralSubstitutionAllowed()) break block61;
                                                    if (this.currentStates_.getSqlLiteralSubstition() != 22) break block62;
                                                    object2 = null;
                                                    break block44;
                                                }
                                                if (this.currentStates_.getSqlLiteralSubstition() == 24) {
                                                    if (this.litInfo_.isStatementUsingParamterMarker()) {
                                                        object2 = method.invoke((Object)this.physicalPreparedStatement_, objectArray);
                                                        this.litInfo_.verifyAndSetActualLiteralsDataType(this.physicalPreparedStatement_, this);
                                                        break block44;
                                                    } else {
                                                        object2 = null;
                                                    }
                                                    break block44;
                                                } else {
                                                    object2 = method.invoke((Object)this.physicalPreparedStatement_, objectArray);
                                                }
                                                break block44;
                                            }
                                            object2 = method.invoke((Object)this.physicalPreparedStatement_, objectArray);
                                        }
                                        this.clearParametersJustDone_ = true;
                                        break block43;
                                    }
                                    object2 = method.invoke((Object)this.physicalPreparedStatement_, objectArray);
                                }
                                object = object2;
                                if (!this.db2ConnectionExecutionHandler_.driverTraceOn_) break block45;
                                break block46;
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                Throwable throwable = invocationTargetException.getTargetException();
                                DataLogger.logThrowable(this.logger_, throwable);
                                this.dumpLogs(throwable);
                                throw throwable;
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PROFILER_ILLEGAL_ACCESS_EXCEPTION", method.getName(), illegalAccessException.getMessage()), illegalAccessException, 10449);
                            }
                            catch (SQLException sQLException) {
                                DataLogger.logThrowable(this.logger_, sQLException);
                                this.dumpLogs(sQLException);
                                throw sQLException;
                            }
                        }
                        this.db2ConnectionExecutionHandler_.driverLogWriter_.println(this.db2ConnectionExecutionHandler_.buildDriverTraceHeader(this, "invoke") + "[" + string + "] exit...");
                    }
                    if (bl2) {
                        DataLogger.exit(this.logger_, this, "invoke: " + string, object2);
                    }
                    return object3;
                }
                this.db2ConnectionExecutionHandler_.driverLogWriter_.println(this.db2ConnectionExecutionHandler_.buildDriverTraceHeader(this, "invoke") + "[" + string + "] exit...");
            }
            if (bl2) {
                DataLogger.exit(this.logger_, this, "invoke: " + string, object2);
            }
            return object;
            finally {
                if (this.db2ConnectionExecutionHandler_.driverTraceOn_) {
                    this.db2ConnectionExecutionHandler_.driverLogWriter_.println(this.db2ConnectionExecutionHandler_.buildDriverTraceHeader(this, "invoke") + "[" + string + "] exit...");
                }
                if (bl2) {
                    DataLogger.exit(this.logger_, this, "invoke: " + string, object2);
                }
            }
        }
    }

    protected void setCursorName(Method method, Object[] objectArray) throws IllegalAccessException, InvocationTargetException {
        this.cursorName_ = (String)objectArray[0];
        if (this.isStaticStmt()) {
            return;
        }
        if (this.logger_.isLoggable(Level.FINE)) {
            String string;
            String string2;
            if (this.cursorName_ != null && this.cursorName_.startsWith("DB_PDQ_SPC")) {
                string2 = DataLogger.getLocationInUserApplicationMessage();
                string = DataLogger.warningMessagePrefix + Messages.getText("MSG_PROFILER_JCC_WARN_CURSOR_USAGE2", "DB_PDQ_SPC", string2);
                this.logger_.logp(Level.FINE, DataLogger.getShortName(this), "invoke: setCursorName", string);
            }
            if (this.cursorName_ != null && this.db2ConnectionExecutionHandler_.getCursorNameToSelectStmtMap().containsKey(this.cursorName_)) {
                string2 = DataLogger.getLocationInUserApplicationMessage();
                string = Messages.getText("MSG_PROFILER_CURSOR_NAME_REUSE2", this.cursorName_, "pureQuery Runtime", this.db2ConnectionExecutionHandler_.getCursorNameToSelectStmtMap().get(this.cursorName_), this.sqlStr_, string2);
                this.logger_.logp(Level.FINE, DataLogger.getShortName(this), "invoke: setCursorName", string);
            }
        }
        method.invoke((Object)this.physicalPreparedStatement_, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object addBatch(Method method, Object[] objectArray) throws SQLException, IllegalAccessException, InvocationTargetException {
        StaticProfileCaptureHelper.checkAndGenerateSpecialRegisterSets(this.currentStates_, this.db2ConnectionExecutionHandler_, null, this.sqlStr_);
        Object object = null;
        if (StaticProfileConstants.attemptStaticMRIForStatement(this.db2ConnectionExecutionHandler_, this.db2ConnectionExecutionHandler_.getDBInfo(), this.isStaticStmt(), this.staticSectionForThisStmt_, this.autoGenKeysRequested_)) {
            this.setAppropriateMRISection(this.staticSectionForThisStmt_);
        }
        boolean bl2 = true;
        try {
            object = method.invoke((Object)this.physicalPreparedStatement_, objectArray);
            bl2 = false;
            this.isHomogeneousBatch_ = true;
        }
        finally {
            if (!this.isAddBatchDone_ && !this.isSELECTorXQUERY()) {
                this.checkAndCaptureNonQueryStmt(bl2, false, 0L, 0L, 0);
                this.isAddBatchDone_ = true;
            }
            ++this.batchCount_;
        }
        return object;
    }

    protected void setJccXXXAtName(Method method, Object[] objectArray) throws SQLException {
        String string = ((String)objectArray[0]).toUpperCase();
        ArrayList arrayList = (ArrayList)this.NamedParamMap_.get(string);
        String string2 = method.getName();
        String string3 = string2.substring(6, string2.length() - 6);
        String string4 = "set" + string3;
        Object[] objectArray2 = new Object[objectArray.length - 1];
        for (int i10 = 1; i10 < objectArray.length; ++i10) {
            objectArray2[i10 - 1] = objectArray[i10];
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            this.setX(n2, string4, objectArray2);
        }
    }

    protected void setX(int n2, String string, Object[] objectArray) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)this.physicalStatement_;
        if (string.equals("setString")) {
            preparedStatement.setString(n2, (String)objectArray[0]);
        } else if (string.equals("setInt")) {
            preparedStatement.setInt(n2, (Integer)objectArray[0]);
        } else if (string.equals("setLong")) {
            preparedStatement.setLong(n2, (Long)objectArray[0]);
        } else if (string.equals("setDouble")) {
            preparedStatement.setDouble(n2, (Double)objectArray[0]);
        } else if (string.equals("setFloat")) {
            preparedStatement.setFloat(n2, ((Float)objectArray[0]).floatValue());
        } else if (string.equals("setBoolean")) {
            preparedStatement.setBoolean(n2, (Boolean)objectArray[0]);
        } else if (string.equals("setShort")) {
            preparedStatement.setShort(n2, (Short)objectArray[0]);
        } else if (string.equals("setTime") && objectArray.length == 1) {
            preparedStatement.setTime(n2, (Time)objectArray[0]);
        } else if (string.equals("setTime") && objectArray.length == 2) {
            preparedStatement.setTime(n2, (Time)objectArray[0], (Calendar)objectArray[1]);
        } else if (string.equals("setTimestamp") && objectArray.length == 1) {
            preparedStatement.setTimestamp(n2, (Timestamp)objectArray[0]);
        } else if (string.equals("setTimestamp") && objectArray.length == 2) {
            preparedStatement.setTimestamp(n2, (Timestamp)objectArray[0], (Calendar)objectArray[1]);
        } else if (string.equals("setByte")) {
            preparedStatement.setByte(n2, (Byte)objectArray[0]);
        } else if (string.equals("setBytes")) {
            preparedStatement.setBytes(n2, (byte[])objectArray[0]);
        } else if (string.equals("setNull") && objectArray.length == 1) {
            preparedStatement.setNull(n2, (Integer)objectArray[0]);
        } else if (string.equals("setNull") && objectArray.length == 2) {
            preparedStatement.setNull(n2, (Integer)objectArray[0], (String)objectArray[1]);
        } else if (string.equals("setObject") && objectArray.length == 1) {
            preparedStatement.setObject(n2, objectArray[0]);
        } else if (string.equals("setObject") && objectArray.length == 2) {
            preparedStatement.setObject(n2, objectArray[0], (Integer)objectArray[1]);
        } else if (string.equals("setObject") && objectArray.length == 3) {
            preparedStatement.setObject(n2, objectArray[0], (Integer)objectArray[1], (int)((Integer)objectArray[2]));
        } else if (string.equals("setArray")) {
            preparedStatement.setArray(n2, (Array)objectArray[0]);
        } else if (string.equals("setAsciiStream")) {
            preparedStatement.setAsciiStream(n2, (InputStream)objectArray[0], (Integer)objectArray[1]);
        } else if (string.equals("setBigDecimal")) {
            preparedStatement.setBigDecimal(n2, (BigDecimal)objectArray[0]);
        } else if (string.equals("setBinaryStream")) {
            preparedStatement.setBinaryStream(n2, (InputStream)objectArray[0], (Integer)objectArray[1]);
        } else if (string.equals("setBlob")) {
            preparedStatement.setBlob(n2, (Blob)objectArray[0]);
        } else if (string.equals("setCharacterStream")) {
            preparedStatement.setCharacterStream(n2, (Reader)objectArray[0], (Integer)objectArray[1]);
        } else if (string.equals("setClob")) {
            preparedStatement.setClob(n2, (Clob)objectArray[0]);
        } else if (string.equals("setDate") && objectArray.length == 1) {
            preparedStatement.setDate(n2, (Date)objectArray[0]);
        } else if (string.equals("setDate") && objectArray.length == 2) {
            preparedStatement.setDate(n2, (Date)objectArray[0], (Calendar)objectArray[1]);
        } else if (string.equals("setUnicodeStream")) {
            preparedStatement.setUnicodeStream(n2, (InputStream)objectArray[0], (Integer)objectArray[1]);
        } else if (string.equals("setDB2BlobFileReference")) {
            ((DB2PreparedStatement)this.physicalPreparedStatement_).setDB2BlobFileReference(n2, (DB2BlobFileReference)objectArray[0]);
        } else if (string.equals("setDB2ClobFileReference")) {
            ((DB2PreparedStatement)this.physicalPreparedStatement_).setDB2ClobFileReference(n2, (DB2ClobFileReference)objectArray[0]);
        } else if (string.equals("setDB2XmlAsBlobFileReference")) {
            ((DB2PreparedStatement)this.physicalPreparedStatement_).setDB2XmlAsBlobFileReference(n2, (DB2XmlAsBlobFileReference)objectArray[0]);
        } else if (string.equals("setDB2XmlAsClobFileReference")) {
            ((DB2PreparedStatement)this.physicalPreparedStatement_).setDB2XmlAsClobFileReference(n2, (DB2XmlAsClobFileReference)objectArray[0]);
        } else if (string.equals("setDBDefault")) {
            ((DB2PreparedStatement)this.physicalPreparedStatement_).setDBDefault(n2);
        } else if (string.equals("setDBUnassigned")) {
            ((DB2PreparedStatement)this.physicalPreparedStatement_).setDBUnassigned(n2);
        } else if (string.equals("setDBTimestamp")) {
            ((DB2PreparedStatement)this.physicalPreparedStatement_).setDBTimestamp(n2, (DBTimestamp)objectArray[0]);
        } else if (string.equals("setSQLXML")) {
            Object[] objectArray2 = new Object[objectArray.length];
            objectArray2[0] = n2;
            objectArray2[1] = objectArray[0];
            try {
                methodSetSQLXML_.invoke((Object)this.physicalPreparedStatement_, objectArray2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PROFILER_ILLEGAL_ACCESS_EXCEPTION", methodSetSQLXML_.getName(), illegalAccessException.getMessage()), illegalAccessException, 11777);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                DataLogger.logThrowable(this.logger_, throwable);
                this.dumpLogs(throwable);
            }
        }
    }

    protected ConnectionExecutionHandler getConnectionProxyHandler() {
        return this.db2ConnectionExecutionHandler_;
    }

    @Override
    protected StaticProfileCaptureHelper.SqlStatementInfo recordBatchedQueryStmt_(SqlStatementKey sqlStatementKey, String[][] stringArray, PreparedStatement preparedStatement) throws SQLException {
        StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo = null;
        DBPreparedStatementInfoInterface dBPreparedStatementInfoInterface = ((DB2PreparedStatement)preparedStatement).getDBPreparedStatementInfo();
        sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().recordQueryStmt(this.db2ConnectionExecutionHandler_, this.sqlStr_, dBPreparedStatementInfoInterface.getDBParameterMetaData(), dBPreparedStatementInfoInterface.getDBResultSetMetaData(), sqlStatementKey, null, dBPreparedStatementInfoInterface.getPrepareAttributes(), dBPreparedStatementInfoInterface.getSQLString(), this.getCurrentSqlType(), this.definitionTraceInfo_, stringArray, dBPreparedStatementInfoInterface.getNamedParameterMarkerMap(), 0L, 0L, 0, 0);
        return sqlStatementInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAndCaptureBatchedQueryStmt(boolean bl2) throws SQLException {
        boolean bl3 = false;
        String[][] stringArray = null;
        SqlStatementKey sqlStatementKey = null;
        boolean bl4 = true;
        StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo = null;
        if (this.currentStates_.getCaptureMode() == 5) {
            Object object = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap();
            synchronized (object) {
                sqlStatementKey = SqlStatementKey.generateStmtKey(this.sqlStr_, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_, this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_, false);
                bl3 = this.currentStates_.getProfilerHelperInstance().determineIfStmtAlreadyCaptured(sqlStatementKey);
                if (bl3) {
                    sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap().get(sqlStatementKey);
                    this.currentStates_.getProfilerHelperInstance().getStatementOrdinalPositionMap().put(sqlStatementInfo.getStmtId(), sqlStatementKey);
                } else if (!bl2 && (bl4 = this.isCapturableNonParameter())) {
                    if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0) {
                        stringArray = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                        if (this.definitionTraceInfo_ == null) {
                            this.definitionTraceInfo_ = stringArray;
                        }
                    }
                    sqlStatementInfo = this.recordBatchedQueryStmt_(sqlStatementKey, stringArray, this.physicalPreparedStatement_);
                    this.definitionTraceInfo_ = null;
                    this.defStackTrcCaptured_ = true;
                }
            }
            if (bl3) {
                object = sqlStatementInfo;
                synchronized (object) {
                    if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0 && (this.currentStates_.getMaxStackTracesCaptured() == -1 || sqlStatementInfo.countDefinitionTraces() < this.currentStates_.getMaxStackTracesCaptured() || sqlStatementInfo.countExecutionTraces() < this.currentStates_.getMaxStackTracesCaptured())) {
                        String[][] stringArray2 = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                        if (!this.defStackTrcCaptured_) {
                            this.currentStates_.getProfilerHelperInstance().captureTrace(this.definitionTraceInfo_, stringArray2, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                            this.defStackTrcCaptured_ = true;
                        } else {
                            this.currentStates_.getProfilerHelperInstance().captureTrace(null, stringArray2, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                        }
                    }
                    this.currentStates_.getProfilerHelperInstance().incrementExecutionCountMRIAndSRSet(this.db2ConnectionExecutionHandler_, sqlStatementInfo, false, this.getCurrentSqlType(), 0L, 0L, 0, 0);
                }
            }
            if (bl4 && (bl3 || !bl3 && !bl2)) {
                this.currentStates_.getProfilerHelperInstance().sqlStatementCaptureOrUpdate(!bl3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void checkAndCaptureNonQueryStmt(boolean bl2, boolean bl3, long l2, long l3, int n2) throws SQLException {
        if (this.currentStates_.getCaptureMode() == 5) {
            String[] stringArray;
            ParameterMetaData parameterMetaData;
            if (this.isHomogeneousBatch_ && !this.isAddBatchDone_ && (parameterMetaData = this.physicalPreparedStatement_.getParameterMetaData()) != null && parameterMetaData.getParameterCount() > 0) {
                this.setIsParameterizedDynamicStatement(true);
            }
            boolean bl4 = this.isHomogeneousBatch_ && this.isParameterizedDynamicStatement_ && !this.autoGenKeysRequested_ && (this.getCurrentSqlType() == SqlStatementType.INSERT || this.getCurrentSqlType() == SqlStatementType.MERGE);
            String string = null;
            String string2 = null;
            String string3 = null;
            Matcher matcher = null;
            SqlStatementKey sqlStatementKey = null;
            boolean bl5 = false;
            boolean bl6 = true;
            DBPreparedStatementInfoInterface dBPreparedStatementInfoInterface = null;
            String[] stringArray2 = null;
            String[][] stringArray3 = null;
            StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo = null;
            if (this.getCurrentSqlType() == SqlStatementType.UPDATE || this.getCurrentSqlType() == SqlStatementType.DELETE) {
                matcher = StaticProfileConstants.WCOPat_.matcher(this.sqlStr_);
            }
            Object object = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap();
            synchronized (object) {
                if (matcher != null && matcher.find()) {
                    string = matcher.group(2);
                    string3 = this.db2ConnectionExecutionHandler_.getCursorNameToSelectStmtMap().get(string);
                    if (string3 == null) {
                        return;
                    }
                    stringArray = ConnectionExecutionHandler.replacePosUpdateCursorName(this.sqlStr_, string3);
                    if (stringArray != null) {
                        string2 = stringArray[0];
                    }
                }
                sqlStatementKey = SqlStatementKey.generateStmtKey(string2 == null ? this.sqlStr_ : string2, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_, this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_, false);
                bl5 = this.currentStates_.getProfilerHelperInstance().determineIfStmtAlreadyCaptured(sqlStatementKey);
                if (bl5) {
                    sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap().get(sqlStatementKey);
                    this.currentStates_.getProfilerHelperInstance().getStatementOrdinalPositionMap().put(sqlStatementInfo.getStmtId(), sqlStatementKey);
                } else if (!bl2 && (bl6 = this.isCapturableNonParameter())) {
                    dBPreparedStatementInfoInterface = ((DB2PreparedStatement)this.physicalPreparedStatement_).getDBPreparedStatementInfo();
                    stringArray2 = dBPreparedStatementInfoInterface.getSQLString();
                    if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0 && !this.isDBBatch_ && bl3) {
                        stringArray3 = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                        if (this.definitionTraceInfo_ == null) {
                            this.definitionTraceInfo_ = stringArray3;
                        }
                    }
                    sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().recordNonQueryStmt(this.db2ConnectionExecutionHandler_, this.sqlStr_, dBPreparedStatementInfoInterface.getDBParameterMetaData(), null, sqlStatementKey, string, stringArray2, this.getCurrentSqlType(), bl4, this.definitionTraceInfo_, stringArray3, dBPreparedStatementInfoInterface.getNamedParameterMarkerMap(), string3, l2, l3, n2);
                    this.definitionTraceInfo_ = null;
                    this.defStackTrcCaptured_ = true;
                }
            }
            if (bl5) {
                object = sqlStatementInfo;
                synchronized (object) {
                    if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0 && (this.currentStates_.getMaxStackTracesCaptured() == -1 || sqlStatementInfo.countDefinitionTraces() < this.currentStates_.getMaxStackTracesCaptured() || sqlStatementInfo.countExecutionTraces() < this.currentStates_.getMaxStackTracesCaptured())) {
                        stringArray = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                        if (!this.isPStmtAPI_) {
                            this.currentStates_.getProfilerHelperInstance().captureTrace((String[][])stringArray, (String[][])stringArray, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                        } else if (!this.defStackTrcCaptured_) {
                            if (bl3) {
                                this.currentStates_.getProfilerHelperInstance().captureTrace(this.definitionTraceInfo_, (String[][])stringArray, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                            } else {
                                this.currentStates_.getProfilerHelperInstance().captureTrace(this.definitionTraceInfo_, null, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                            }
                            this.defStackTrcCaptured_ = true;
                        } else if (!this.isDBBatch_ && bl3) {
                            this.currentStates_.getProfilerHelperInstance().captureTrace(null, (String[][])stringArray, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                        }
                    }
                    this.currentStates_.getProfilerHelperInstance().incrementExecutionCountMRIAndSRSet(this.db2ConnectionExecutionHandler_, sqlStatementInfo, bl4, this.getCurrentSqlType(), l2, l3, n2, 0);
                }
            }
            if (bl6 && (bl5 || !bl5 && !bl2)) {
                this.currentStates_.getProfilerHelperInstance().sqlStatementCaptureOrUpdate(!bl5);
            }
        }
    }

    protected boolean isStaticUpdatableCursor(DB2ResultSetExecutionHandler dB2ResultSetExecutionHandler) {
        return this.staticSectionForThisStmt_ != null && dB2ResultSetExecutionHandler.resultSetConcurrency_ == 1008;
    }

    private ResultSet staticStmtSetQryIdAndGetCurrentRS() {
        List<WeakReference<ResultSetExecutionHandler>> list;
        String string = null;
        if (this.isStaticStmt() && this.staticSectionForThisStmt_.getPosUpdateCursorName() != null && this.staticSectionForThisStmt_.getPosUpdateCursorName().length() > 0) {
            string = this.staticSectionForThisStmt_.getPosUpdateCursorName();
        }
        if (string == null && !this.isStaticStmt() && this.physicalPreparedStatement_ != null && this.physicalPreparedStatement_ instanceof SQLJPreparedStatement && (list = ((SQLJPreparedStatement)this.physicalPreparedStatement_).getSection()) != null && list instanceof StaticProfileSection && ((StaticProfileSection)((Object)list)).getPosUpdateCursorName() != null && ((StaticProfileSection)((Object)list)).getPosUpdateCursorName().length() > 0) {
            string = ((StaticProfileSection)((Object)list)).getPosUpdateCursorName();
        }
        if (string != null) {
            Iterator<WeakReference<ResultSetExecutionHandler>> iterator;
            list = this.db2ConnectionExecutionHandler_.staticCursorPositionUpdateMap_.getAllRSProxiesForCursor(string);
            if (list != null && (iterator = list.iterator()) != null) {
                while (iterator.hasNext()) {
                    WeakReference<ResultSetExecutionHandler> weakReference = iterator.next();
                    DB2ResultSetExecutionHandler dB2ResultSetExecutionHandler = (DB2ResultSetExecutionHandler)weakReference.get();
                    if (null == dB2ResultSetExecutionHandler || !dB2ResultSetExecutionHandler.isCurrentForPositionUpdate()) continue;
                    this.setQueryIdOnCurrentRS(dB2ResultSetExecutionHandler);
                    return dB2ResultSetExecutionHandler.getUnderlyingResultSet();
                }
            }
            if (this.logger_.isLoggable(Level.FINER)) {
                DataLogger.logAtLevelFiner(this.logger_, this, "staticStmtSetQryIdAndGetCurrentRS", " No ResultSet marked as current for cursor '" + string + "'");
            }
        }
        return null;
    }

    protected void setQueryIdOnCurrentRS(DB2ResultSetExecutionHandler dB2ResultSetExecutionHandler) {
        ((SQLJPreparedStatement)this.physicalPreparedStatement_).setQueryInstanceIdentifier(dB2ResultSetExecutionHandler.getQueryInstanceId());
    }

    public boolean isStaticStmt() {
        return this.staticSectionForThisStmt_ != null;
    }

    @Override
    public PreparedStatement getUnderlyingPreparedStatement() {
        return this.physicalPreparedStatement_;
    }

    private boolean userSQLIsNestedInASELECTForAGKs() {
        String string = null == this.staticSectionForThisStmt_ ? null : this.staticSectionForThisStmt_.getAutoGenKeySql();
        return StaticProfileConstants.userSQLIsNestedInASELECTForAGKs(string, this.autoGenKeyIndicator_);
    }

    @Override
    protected StaticProfileCaptureHelper.SqlStatementInfo recordQueryStmt_(SqlStatementKey sqlStatementKey, String[][] stringArray, PreparedStatement preparedStatement, ResultSet resultSet, long l2, long l3, int n2, int n3) throws SQLException {
        StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo = null;
        sqlStatementInfo = this.recordQueryStmt_(sqlStatementKey, stringArray, preparedStatement, resultSet, l2, l3, n2, n3, null);
        return sqlStatementInfo;
    }

    protected StaticProfileCaptureHelper.SqlStatementInfo recordQueryStmt_(SqlStatementKey sqlStatementKey, PreparedStatement preparedStatement, ResultSet resultSet, String string) throws SQLException {
        StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo = null;
        sqlStatementInfo = this.recordQueryStmt_(sqlStatementKey, null, preparedStatement, resultSet, 0L, 0L, 0, 0, string);
        return sqlStatementInfo;
    }

    protected StaticProfileCaptureHelper.SqlStatementInfo recordQueryStmt_(SqlStatementKey sqlStatementKey, String[][] stringArray, PreparedStatement preparedStatement, ResultSet resultSet, long l2, long l3, int n2, int n3, String string) throws SQLException {
        StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo = null;
        DBPreparedStatementInfoInterface dBPreparedStatementInfoInterface = ((DB2PreparedStatement)preparedStatement).getDBPreparedStatementInfo();
        sqlStatementInfo = string == null ? this.currentStates_.getProfilerHelperInstance().recordQueryStmt(this.db2ConnectionExecutionHandler_, this.sqlStr_, dBPreparedStatementInfoInterface.getDBParameterMetaData(), dBPreparedStatementInfoInterface.getDBResultSetMetaData(), sqlStatementKey, resultSet.getCursorName(), dBPreparedStatementInfoInterface.getPrepareAttributes(), dBPreparedStatementInfoInterface.getSQLString(), this.getCurrentSqlType(), this.definitionTraceInfo_, stringArray, dBPreparedStatementInfoInterface.getNamedParameterMarkerMap(), l2, l3, n2, n3) : this.currentStates_.getProfilerHelperInstance().recordQueryStmt(this.db2ConnectionExecutionHandler_, this.sqlStr_, dBPreparedStatementInfoInterface.getDBParameterMetaData(), dBPreparedStatementInfoInterface.getDBResultSetMetaData(), sqlStatementKey, resultSet.getCursorName(), string, dBPreparedStatementInfoInterface.getSQLString(), this.getCurrentSqlType(), null, null, dBPreparedStatementInfoInterface.getNamedParameterMarkerMap(), l2, l3, n2, n3);
        return sqlStatementInfo;
    }

    protected boolean checkIfForwardToDummyStatementRequired(String string, Object[] objectArray) throws SQLException {
        boolean bl2 = false;
        if (this.litInfo_ != null && this.litInfo_.isLiteralSubstitutionAllowed() && !this.litInfo_.isStatementUsingParamterMarker()) {
            if (this.db2ConnectionExecutionHandler_.dummyStatementForLiteralSubstitution_ == null) {
                this.db2ConnectionExecutionHandler_.dummyStatementForLiteralSubstitution_ = this.db2ConnectionExecutionHandler_.physicalConnection_.prepareCall("select 1 from sysibm.sysdummy1");
            }
            if (string.startsWith("set") && objectArray != null && objectArray.length >= 2) {
                bl2 = true;
            } else if (string.equals("getParameterMetaData")) {
                bl2 = true;
            }
        }
        return bl2;
    }

    private boolean changeStaticSectionBasedOnSetMaxRowsValue() throws SQLException {
        int n2;
        StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo;
        SqlStatementKey sqlStatementKey;
        boolean bl2 = false;
        int n3 = this.physicalPreparedStatement_.getMaxRows();
        boolean bl3 = this.stmtKey_.setMaxRowsFound_;
        if (n3 > 0 && !bl3 && (sqlStatementKey = SqlStatementKey.generateStmtKey(this.sqlStr_, this.stmtKey_.resultSetType_, this.stmtKey_.resultSetConcurrency_, this.stmtKey_.resultSetHoldability_, this.stmtKey_.autoGenKeyColNames_, this.stmtKey_.autoGenKeyColIndexes_, this.stmtKey_.autoGenKeyIndicator_, true)) != null && (sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap().get(sqlStatementKey)) != null && n3 <= (n2 = sqlStatementInfo.getMaxRowsValue())) {
            StaticProfileSection staticProfileSection = (StaticProfileSection)this.db2ConnExecutionHandler_.getProfileSectionFromMap(sqlStatementKey, this.currentStates_);
            ((SQLJPreparedStatement)this.physicalPreparedStatement_).setSection(staticProfileSection);
            if (staticProfileSection.isSingleRowResult()) {
                ((SQLJPreparedStatement)this.physicalPreparedStatement_).setSQLJSingletonQuery(true);
            }
            this.sectionReplacedForSetMaxRows_ = true;
            bl2 = true;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetExecutionHandler executeQuery() throws SQLException {
        boolean bl2;
        int n2;
        ResultSet resultSet = null;
        DB2ResultSetExecutionHandler dB2ResultSetExecutionHandler = null;
        StaticProfileCaptureHelper.checkAndGenerateSpecialRegisterSets(this.currentStates_, this.db2ConnectionExecutionHandler_, false, this.sqlStr_);
        boolean bl3 = true;
        try {
            this.db2ConnectionExecutionHandler_.systemMonitorStart();
            if (this.isStaticStmt() && ((SQLJPreparedStatement)this.physicalPreparedStatement_).getSQLJSingletonQuery()) {
                this.physicalPreparedStatement_.executeUpdate();
                resultSet = ((SQLJPreparedStatement)this.physicalPreparedStatement_).getSingletonResultSet();
            } else {
                if (this.sectionReplacedForSetMaxRows_) {
                    ((SQLJPreparedStatement)this.physicalPreparedStatement_).setSection(this.staticSectionForThisStmt_);
                    ((SQLJPreparedStatement)this.physicalPreparedStatement_).setSQLJSingletonQuery(false);
                    this.sectionReplacedForSetMaxRows_ = false;
                }
                n2 = 1;
                if (this.stmtKey_ != null && this.isStaticStmt() && this.changeStaticSectionBasedOnSetMaxRowsValue() && ((SQLJPreparedStatement)this.physicalPreparedStatement_).getSQLJSingletonQuery()) {
                    n2 = 0;
                    this.physicalPreparedStatement_.executeUpdate();
                    resultSet = ((SQLJPreparedStatement)this.physicalPreparedStatement_).getSingletonResultSet();
                }
                if (n2 != 0) {
                    resultSet = this.physicalPreparedStatement_.executeQuery();
                }
            }
            if (resultSet != null) {
                dB2ResultSetExecutionHandler = new DB2ResultSetExecutionHandler(this, resultSet, resultSet.getType(), resultSet.getConcurrency(), this.physicalPreparedStatement_.getResultSetHoldability(), resultSet.getCursorName());
            }
            bl3 = false;
            this.db2ConnectionExecutionHandler_.systemMonitorStop();
        }
        catch (Throwable throwable) {
            boolean bl4;
            this.db2ConnectionExecutionHandler_.systemMonitorStop();
            int n3 = this.getMaxRows();
            boolean bl5 = bl4 = n3 > 0;
            if (resultSet != null && this.currentStates_.getCapturedOnly() && (resultSet.getConcurrency() == 1008 || StaticProfileConstants.forUpdateOfPat.matcher(this.sqlStr_).find())) {
                SqlStatementKey sqlStatementKey = SqlStatementKey.generateStmtKey(this.sqlStr_, resultSet.getType(), this.physicalPreparedStatement_.getResultSetConcurrency(), this.physicalPreparedStatement_.getResultSetHoldability(), null, null, 0, bl4);
                this.db2ConnectionExecutionHandler_.getCursorNameToSelectStmtMap().put(resultSet.getCursorName(), sqlStatementKey.toString());
            }
            if (this.currentStates_.getCaptureMode() == 5) {
                Object object;
                boolean bl6 = false;
                boolean bl7 = false;
                boolean bl8 = true;
                SqlStatementKey sqlStatementKey = null;
                SqlStatementKey sqlStatementKey2 = null;
                String[][] stringArray = null;
                StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo = null;
                StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo2 = null;
                Object object2 = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap();
                synchronized (object2) {
                    sqlStatementKey = SqlStatementKey.generateStmtKey(this.sqlStr_, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_, this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_, bl4);
                    bl6 = this.currentStates_.getProfilerHelperInstance().determineIfStmtAlreadyCaptured(sqlStatementKey);
                    if (bl6) {
                        sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap().get(sqlStatementKey);
                        this.currentStates_.getProfilerHelperInstance().getStatementOrdinalPositionMap().put(sqlStatementInfo.getStmtId(), sqlStatementKey);
                    } else if (!bl3) {
                        bl8 = this.isCapturableNonParameter();
                        if (bl8) {
                            if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0) {
                                stringArray = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                                if (this.definitionTraceInfo_ == null) {
                                    this.definitionTraceInfo_ = stringArray;
                                }
                            }
                            sqlStatementInfo = this.recordQueryStmt_(sqlStatementKey, stringArray, this.physicalPreparedStatement_, resultSet, this.db2ConnectionExecutionHandler_.getElapsedTime(), 0L, 0, n3);
                            this.defStackTrcCaptured_ = true;
                        }
                        object = ((DB2PreparedStatement)this.physicalPreparedStatement_).getDBPreparedStatementInfo();
                        this.checkForExistenceOfRowsetAndLog(object.getPrepareAttributes(), "executeQuery", this.sqlStr_);
                    }
                    if (bl4) {
                        sqlStatementKey2 = SqlStatementKey.generateStmtKey(this.sqlStr_, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_, this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_, false);
                        bl7 = this.currentStates_.getProfilerHelperInstance().determineIfStmtAlreadyCaptured(sqlStatementKey2);
                        if (!bl7) {
                            Matcher matcher;
                            object = null;
                            DBPreparedStatementInfoInterface dBPreparedStatementInfoInterface = ((DB2PreparedStatement)this.physicalPreparedStatement_).getDBPreparedStatementInfo();
                            object = dBPreparedStatementInfoInterface.getPrepareAttributes();
                            if (object != null && (matcher = BindLexer.regExPatternFetchRows.matcher((CharSequence)object)).find() && object.contains("ONLY")) {
                                int n4 = object.indexOf("FETCH");
                                int n5 = object.indexOf("ONLY", n4);
                                String string = null;
                                if (n4 != -1 && n5 > n4) {
                                    string = object.substring(n4, n5 + 4);
                                }
                                if (string != null) {
                                    object = object.replace(string, "");
                                }
                            }
                            sqlStatementInfo2 = this.recordQueryStmt_(sqlStatementKey2, this.physicalPreparedStatement_, resultSet, (String)object);
                        }
                    }
                }
                if (bl6) {
                    object2 = sqlStatementInfo;
                    synchronized (object2) {
                        if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0 && (this.currentStates_.getMaxStackTracesCaptured() == -1 || sqlStatementInfo.countDefinitionTraces() < this.currentStates_.getMaxStackTracesCaptured() || sqlStatementInfo.countExecutionTraces() < this.currentStates_.getMaxStackTracesCaptured())) {
                            object = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                            if (!this.isPStmtAPI_) {
                                this.currentStates_.getProfilerHelperInstance().captureTrace((String[][])object, (String[][])object, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                            } else if (!this.defStackTrcCaptured_) {
                                this.currentStates_.getProfilerHelperInstance().captureTrace(this.definitionTraceInfo_, (String[][])object, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                                this.defStackTrcCaptured_ = true;
                            } else {
                                this.currentStates_.getProfilerHelperInstance().captureTrace(null, (String[][])object, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                            }
                        }
                        this.currentStates_.getProfilerHelperInstance().incrementExecutionCountMRIAndSRSet(this.db2ConnectionExecutionHandler_, sqlStatementInfo, false, this.getCurrentSqlType(), this.db2ConnectionExecutionHandler_.getElapsedTime(), 0L, 0, n3);
                    }
                }
                if (resultSet != null) {
                    this.db2ConnectionExecutionHandler_.getCursorNameToSelectStmtMap().put(resultSet.getCursorName(), sqlStatementKey.toString());
                }
                if (bl8 && (bl6 || !bl6 && !bl3)) {
                    this.currentStates_.getProfilerHelperInstance().sqlStatementCaptureOrUpdate(!bl6);
                }
            }
            throw throwable;
        }
        n2 = this.getMaxRows();
        boolean bl9 = bl2 = n2 > 0;
        if (resultSet != null && this.currentStates_.getCapturedOnly() && (resultSet.getConcurrency() == 1008 || StaticProfileConstants.forUpdateOfPat.matcher(this.sqlStr_).find())) {
            SqlStatementKey sqlStatementKey = SqlStatementKey.generateStmtKey(this.sqlStr_, resultSet.getType(), this.physicalPreparedStatement_.getResultSetConcurrency(), this.physicalPreparedStatement_.getResultSetHoldability(), null, null, 0, bl2);
            this.db2ConnectionExecutionHandler_.getCursorNameToSelectStmtMap().put(resultSet.getCursorName(), sqlStatementKey.toString());
        }
        if (this.currentStates_.getCaptureMode() == 5) {
            Object object;
            boolean bl10 = false;
            boolean bl11 = false;
            boolean bl12 = true;
            SqlStatementKey sqlStatementKey = null;
            SqlStatementKey sqlStatementKey3 = null;
            String[][] stringArray = null;
            StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo = null;
            StaticProfileCaptureHelper.SqlStatementInfo sqlStatementInfo3 = null;
            Object object3 = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap();
            synchronized (object3) {
                sqlStatementKey = SqlStatementKey.generateStmtKey(this.sqlStr_, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_, this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_, bl2);
                bl10 = this.currentStates_.getProfilerHelperInstance().determineIfStmtAlreadyCaptured(sqlStatementKey);
                if (bl10) {
                    sqlStatementInfo = this.currentStates_.getProfilerHelperInstance().getSqlStatementInfoMap().get(sqlStatementKey);
                    this.currentStates_.getProfilerHelperInstance().getStatementOrdinalPositionMap().put(sqlStatementInfo.getStmtId(), sqlStatementKey);
                } else if (!bl3) {
                    bl12 = this.isCapturableNonParameter();
                    if (bl12) {
                        if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0) {
                            stringArray = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                            if (this.definitionTraceInfo_ == null) {
                                this.definitionTraceInfo_ = stringArray;
                            }
                        }
                        sqlStatementInfo = this.recordQueryStmt_(sqlStatementKey, stringArray, this.physicalPreparedStatement_, resultSet, this.db2ConnectionExecutionHandler_.getElapsedTime(), 0L, 0, n2);
                        this.defStackTrcCaptured_ = true;
                    }
                    object = ((DB2PreparedStatement)this.physicalPreparedStatement_).getDBPreparedStatementInfo();
                    this.checkForExistenceOfRowsetAndLog(object.getPrepareAttributes(), "executeQuery", this.sqlStr_);
                }
                if (bl2) {
                    sqlStatementKey3 = SqlStatementKey.generateStmtKey(this.sqlStr_, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_, this.autoGenKeyColNames_, this.autoGenKeyColIndexes_, this.autoGenKeyIndicator_, false);
                    bl11 = this.currentStates_.getProfilerHelperInstance().determineIfStmtAlreadyCaptured(sqlStatementKey3);
                    if (!bl11) {
                        Matcher matcher;
                        object = null;
                        DBPreparedStatementInfoInterface dBPreparedStatementInfoInterface = ((DB2PreparedStatement)this.physicalPreparedStatement_).getDBPreparedStatementInfo();
                        object = dBPreparedStatementInfoInterface.getPrepareAttributes();
                        if (object != null && (matcher = BindLexer.regExPatternFetchRows.matcher((CharSequence)object)).find() && object.contains("ONLY")) {
                            int n6 = object.indexOf("FETCH");
                            int n7 = object.indexOf("ONLY", n6);
                            String string = null;
                            if (n6 != -1 && n7 > n6) {
                                string = object.substring(n6, n7 + 4);
                            }
                            if (string != null) {
                                object = object.replace(string, "");
                            }
                        }
                        sqlStatementInfo3 = this.recordQueryStmt_(sqlStatementKey3, this.physicalPreparedStatement_, resultSet, (String)object);
                    }
                }
            }
            if (bl10) {
                object3 = sqlStatementInfo;
                synchronized (object3) {
                    if (this.currentStates_.getMaxStackTracesCaptured() != 0 && this.currentStates_.getStackTraceDepth() != 0 && (this.currentStates_.getMaxStackTracesCaptured() == -1 || sqlStatementInfo.countDefinitionTraces() < this.currentStates_.getMaxStackTracesCaptured() || sqlStatementInfo.countExecutionTraces() < this.currentStates_.getMaxStackTracesCaptured())) {
                        object = this.currentStates_.getProfilerHelperInstance().createMultiLevelTraceInfo(this.currentStates_.getStackTraceDepth(), this.currentStates_.getPackagePrefixArray());
                        if (!this.isPStmtAPI_) {
                            this.currentStates_.getProfilerHelperInstance().captureTrace((String[][])object, (String[][])object, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                        } else if (!this.defStackTrcCaptured_) {
                            this.currentStates_.getProfilerHelperInstance().captureTrace(this.definitionTraceInfo_, (String[][])object, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                            this.defStackTrcCaptured_ = true;
                        } else {
                            this.currentStates_.getProfilerHelperInstance().captureTrace(null, (String[][])object, this.currentStates_.getMaxStackTracesCaptured(), sqlStatementInfo);
                        }
                    }
                    this.currentStates_.getProfilerHelperInstance().incrementExecutionCountMRIAndSRSet(this.db2ConnectionExecutionHandler_, sqlStatementInfo, false, this.getCurrentSqlType(), this.db2ConnectionExecutionHandler_.getElapsedTime(), 0L, 0, n2);
                }
            }
            if (resultSet != null) {
                this.db2ConnectionExecutionHandler_.getCursorNameToSelectStmtMap().put(resultSet.getCursorName(), sqlStatementKey.toString());
            }
            if (bl12 && (bl10 || !bl10 && !bl3)) {
                this.currentStates_.getProfilerHelperInstance().sqlStatementCaptureOrUpdate(!bl10);
            }
        }
        if (this.isStaticUpdatableCursor(dB2ResultSetExecutionHandler)) {
            this.db2ConnectionExecutionHandler_.staticCursorPositionUpdateMap_.putRSProxyForCursor(dB2ResultSetExecutionHandler.cursorName_, dB2ResultSetExecutionHandler);
        }
        this.resultSet_ = dB2ResultSetExecutionHandler;
        return dB2ResultSetExecutionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        Object object;
        ResultSet resultSet = this.staticStmtSetQryIdAndGetCurrentRS();
        if (resultSet != null && resultSet.getType() != 1003) {
            ((SQLJResultSet)resultSet).positionServerToCurrentRow();
        }
        StaticProfileCaptureHelper.checkAndGenerateSpecialRegisterSets(this.currentStates_, this.db2ConnectionExecutionHandler_, null, this.sqlStr_);
        Object object2 = 0;
        boolean bl2 = true;
        try {
            this.db2ConnectionExecutionHandler_.systemMonitorStart();
            if (this.isStaticStmt()) {
                this.staticSectionForThisStmt_.setSectionNumber(this.staticSectionForThisStmt_.getOriginalStmtSectionNumber());
                if (this.autoGenKeysRequested_) {
                    if (this.userSQLIsNestedInASELECTForAGKs()) {
                        object = this.physicalPreparedStatement_.executeQuery();
                        if (object != null) {
                            this.resultSet_ = new DB2ResultSetExecutionHandler(this, (ResultSet)object, object.getType(), object.getConcurrency(), this.resultSetHoldability_, object.getCursorName());
                        }
                        object2 = this.physicalPreparedStatement_.getUpdateCount();
                    } else {
                        object2 = this.physicalPreparedStatement_.executeUpdate();
                    }
                } else if (this.staticSectionForThisStmt_.getOriginalStmtSectionNumber() == this.staticSectionForThisStmt_.getNonAtomicMRISection() && this.staticSectionForThisStmt_.isMerge()) {
                    this.physicalPreparedStatement_.addBatch();
                    ((DB2PreparedStatement)this.physicalPreparedStatement_).setSupportsMultiRowInsert(true);
                    object = this.physicalPreparedStatement_.executeBatch();
                    object2 = object[0];
                } else {
                    object2 = this.physicalPreparedStatement_.executeUpdate();
                }
            } else {
                object2 = this.physicalPreparedStatement_.executeUpdate();
            }
            bl2 = false;
        }
        finally {
            this.db2ConnectionExecutionHandler_.systemMonitorStop();
            this.checkAndCaptureNonQueryStmt(bl2, true, this.db2ConnectionExecutionHandler_.getElapsedTime(), 0L, 0);
            if (!bl2 && this.db2ConnectionExecutionHandler_.getSrValueSetImmediateTrackRequired()) {
                object = this.currentStates_.getProfilerHelperInstance();
                if (object == null) {
                    this.db2ConnectionExecutionHandler_.performSRegQueryAndSetTimeZone();
                } else {
                    ((StaticProfileCaptureHelper)object).generateAndCaptureSpecialRegSet(this.db2ConnectionExecutionHandler_);
                }
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        Object object;
        if (this.isSELECTorXQUERY()) {
            this.resultSet_ = this.executeQuery();
            return true;
        }
        SQLJResultSet sQLJResultSet = (SQLJResultSet)this.staticStmtSetQryIdAndGetCurrentRS();
        if (sQLJResultSet != null && sQLJResultSet.getType() != 1003) {
            sQLJResultSet.positionServerToCurrentRow();
        }
        StaticProfileCaptureHelper.checkAndGenerateSpecialRegisterSets(this.currentStates_, this.db2ConnectionExecutionHandler_, null, this.sqlStr_);
        boolean bl2 = false;
        boolean bl3 = true;
        try {
            this.db2ConnectionExecutionHandler_.systemMonitorStart();
            if (this.isStaticStmt()) {
                this.staticSectionForThisStmt_.setSectionNumber(this.staticSectionForThisStmt_.getOriginalStmtSectionNumber());
                if (this.autoGenKeysRequested_) {
                    if (this.userSQLIsNestedInASELECTForAGKs()) {
                        object = this.physicalPreparedStatement_.executeQuery();
                        if (object != null) {
                            this.resultSet_ = new DB2ResultSetExecutionHandler(this, (ResultSet)object, object.getType(), object.getConcurrency(), this.resultSetHoldability_, object.getCursorName());
                        }
                        bl2 = false;
                    } else {
                        bl2 = this.physicalPreparedStatement_.execute();
                    }
                } else if (this.staticSectionForThisStmt_.getOriginalStmtSectionNumber() == this.staticSectionForThisStmt_.getNonAtomicMRISection() && this.staticSectionForThisStmt_.isMerge()) {
                    this.physicalPreparedStatement_.addBatch();
                    ((DB2PreparedStatement)this.physicalPreparedStatement_).setSupportsMultiRowInsert(true);
                    object = this.physicalPreparedStatement_.executeBatch();
                    this.updateCount_ = (int)object[0];
                    bl2 = false;
                } else {
                    bl2 = this.physicalPreparedStatement_.execute();
                }
            } else {
                bl2 = this.physicalPreparedStatement_.execute();
            }
            bl3 = false;
        }
        finally {
            this.db2ConnectionExecutionHandler_.systemMonitorStop();
            this.checkAndCaptureNonQueryStmt(bl3, true, this.db2ConnectionExecutionHandler_.getElapsedTime(), 0L, 0);
            if (!bl3 && this.db2ConnectionExecutionHandler_.getSrValueSetImmediateTrackRequired()) {
                object = this.currentStates_.getProfilerHelperInstance();
                if (object == null) {
                    this.db2ConnectionExecutionHandler_.performSRegQueryAndSetTimeZone();
                } else {
                    ((StaticProfileCaptureHelper)object).generateAndCaptureSpecialRegSet(this.db2ConnectionExecutionHandler_);
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int[] executeBatch() throws SQLException {
        boolean bl2 = false;
        if (StaticProfileConstants.attemptStaticMRIForStatement(this.db2ConnectionExecutionHandler_, this.db2ConnectionExecutionHandler_.getDBInfo(), this.isStaticStmt(), this.staticSectionForThisStmt_, this.autoGenKeysRequested_)) {
            if (((DB2PreparedStatement)this.physicalPreparedStatement_).isEligibleForMultiRowInsert()) {
                this.setAppropriateMRISection(this.staticSectionForThisStmt_);
                ((DB2PreparedStatement)this.physicalPreparedStatement_).setSupportsMultiRowInsert(true);
                bl2 = true;
            } else {
                this.staticSectionForThisStmt_.setSectionNumber(this.staticSectionForThisStmt_.getOriginalStmtSectionNumber());
                if (this.db2ConnectionExecutionHandler_.isAtomicMRIPropertySetToYES() && this.staticSectionForThisStmt_.getAtomicMRISection() != 0) {
                    throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("MSG_PROFILER_JCC_ERROR_ATOMIC_MRI_NOT_SUPPORTED", new Object[0]), null, null, 10761);
                }
            }
        } else if (this.isStaticStmt()) {
            this.staticSectionForThisStmt_.setSectionNumber(this.staticSectionForThisStmt_.getOriginalStmtSectionNumber());
            ((DB2PreparedStatement)this.physicalPreparedStatement_).setSupportsMultiRowInsert(false);
        }
        if (this.isStaticStmt() && this.staticSectionForThisStmt_.getOriginalStmtSectionNumber() == this.staticSectionForThisStmt_.getNonAtomicMRISection() && this.staticSectionForThisStmt_.isMerge()) {
            if (((DB2PreparedStatement)this.physicalPreparedStatement_).isEligibleForMultiRowInsert()) {
                this.staticSectionForThisStmt_.setSectionNumber(this.staticSectionForThisStmt_.getNonAtomicMRISection());
                ((DB2PreparedStatement)this.physicalPreparedStatement_).setSupportsMultiRowInsert(true);
                bl2 = true;
            } else {
                throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("MSG_PROFILER_JCC_ERROR_NON_MRI_MERGE_NOT_SUPPORTED", "IBM InfoSphere Optim pureQuery Runtime"), null, null, 10775);
            }
        }
        this.isHomogeneousBatch_ = true;
        StaticProfileCaptureHelper.checkAndGenerateSpecialRegisterSets(this.currentStates_, this.db2ConnectionExecutionHandler_, null, this.sqlStr_);
        int[] nArray = null;
        boolean bl3 = true;
        try {
            this.db2ConnectionExecutionHandler_.systemMonitorStart();
            nArray = this.physicalPreparedStatement_.executeBatch();
            bl3 = false;
        }
        finally {
            this.db2ConnectionExecutionHandler_.systemMonitorStop();
            if (bl2) {
                this.staticSectionForThisStmt_.setSectionNumber(this.staticSectionForThisStmt_.getOriginalStmtSectionNumber());
                ((DB2PreparedStatement)this.physicalPreparedStatement_).setSupportsMultiRowInsert(false);
            }
            if (this.currentStates_.getCaptureMode() == 5 && !this.isSELECTorXQUERY()) {
                this.checkAndCaptureNonQueryStmt(bl3, true, 0L, this.db2ConnectionExecutionHandler_.getElapsedTime(), this.batchCount_);
            }
            this.batchCount_ = 0;
        }
        return nArray;
    }

    @Override
    protected void clearBatch() throws SQLException {
        this.batchCount_ = 0;
        this.physicalPreparedStatement_.clearBatch();
    }

    private void setAppropriateMRISection(StaticProfileSection staticProfileSection) throws SQLException {
        if (StaticProfileConstants.isStaticAtomicIfMRI(this.db2ConnectionExecutionHandler_, staticProfileSection)) {
            int n2 = staticProfileSection.getAtomicMRISection();
            if (0 == n2) {
                throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_ATOMIC_BATCH_NOT_ALLOWED2", staticProfileSection.getSectionNumber(), staticProfileSection.getPackage().getPackageName()), null, null, 11025);
            }
            staticProfileSection.setSectionNumber(n2);
        } else {
            int n3 = staticProfileSection.getNonAtomicMRISection();
            if (0 == n3) {
                throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, Messages.getText("ERR_NONATOMIC_BATCH_NOT_ALLOWED2", staticProfileSection.getSectionNumber(), staticProfileSection.getPackage().getPackageName(), PossibleArgs.CLEAN_CONFIGURE.externalOptionName(), PossibleArgs.PredefinedOptionValues.TRUE.getOptionValue(), PossibleArgs.VALIDATE_XML.externalOptionName()), null, null, 11026);
            }
            staticProfileSection.setSectionNumber(n3);
        }
    }

    @Override
    public void close() throws SQLException {
        this.releaseStaticUpdateableCursor();
        try {
            this.physicalPreparedStatement_.close();
        }
        finally {
            if (this.sectionReplacedForSetMaxRows_) {
                ((SQLJPreparedStatement)this.physicalPreparedStatement_).setSection(this.staticSectionForThisStmt_);
                ((SQLJPreparedStatement)this.physicalPreparedStatement_).setSQLJSingletonQuery(false);
                this.sectionReplacedForSetMaxRows_ = false;
            }
        }
    }

    protected void releaseStaticUpdateableCursor() {
        DB2ResultSetExecutionHandler dB2ResultSetExecutionHandler = (DB2ResultSetExecutionHandler)this.resultSet_;
        if (dB2ResultSetExecutionHandler != null && this.isStaticUpdatableCursor(dB2ResultSetExecutionHandler)) {
            this.db2ConnectionExecutionHandler_.staticCursorPositionUpdateMap_.removeRSProxyForCursor(dB2ResultSetExecutionHandler.cursorName_, dB2ResultSetExecutionHandler);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.releaseStaticUpdateableCursor();
        this.resultSet_ = null;
        return this.physicalPreparedStatement_.getMoreResults();
    }

    @Override
    public boolean getMoreResults(int n2) throws SQLException {
        if (n2 != 2) {
            this.releaseStaticUpdateableCursor();
            this.resultSet_ = null;
        }
        return this.physicalPreparedStatement_.getMoreResults(n2);
    }

    protected Object getGeneratedKeys() throws SQLException {
        if (null != this.resultSet_ && this.isStaticStmt() && this.userSQLIsNestedInASELECTForAGKs()) {
            return this.resultSet_.getUnderlyingObject();
        }
        return this.physicalPreparedStatement_.getGeneratedKeys();
    }

    protected int getMaxRows() throws SQLException {
        return this.physicalPreparedStatement_.getMaxRows();
    }

    protected void executeDB2QueryBatch() throws SQLException {
        StaticProfileCaptureHelper.checkAndGenerateSpecialRegisterSets(this.currentStates_, this.db2ConnectionExecutionHandler_, false, null);
        boolean bl2 = true;
        try {
            ((DB2PreparedStatement)this.physicalPreparedStatement_).executeDB2QueryBatch();
            bl2 = false;
        }
        finally {
            this.checkAndCaptureBatchedQueryStmt(bl2);
        }
    }

    @Override
    public ResultSetExecutionHandler getResultSet() throws SQLException {
        ResultSet resultSet = this.physicalPreparedStatement_.getResultSet();
        if (resultSet != null) {
            if (this.resultSet_ != null && this.resultSet_.getUnderlyingObject().equals(resultSet)) {
                return this.resultSet_;
            }
            DB2ResultSetExecutionHandler dB2ResultSetExecutionHandler = null;
            if (resultSet != null) {
                dB2ResultSetExecutionHandler = new DB2ResultSetExecutionHandler(this, resultSet, resultSet.getType(), resultSet.getConcurrency(), this.physicalPreparedStatement_.getResultSetHoldability(), resultSet.getCursorName());
            }
            this.resultSet_ = dB2ResultSetExecutionHandler;
            return dB2ResultSetExecutionHandler;
        }
        return null;
    }

    @Override
    protected int getUpdateCount() throws SQLException {
        if (this.staticSectionForThisStmt_ != null && this.staticSectionForThisStmt_.getNonAtomicMRISection() == this.staticSectionForThisStmt_.getOriginalStmtSectionNumber()) {
            return this.updateCount_;
        }
        return this.physicalPreparedStatement_.getUpdateCount();
    }

    public StaticProfileSection getStaticSectionForThisStmt() {
        return this.staticSectionForThisStmt_;
    }

    public String toString() {
        return new String("DB2PreparedStatementExecutionHandler@" + Integer.toHexString(this.hashCode()) + "[physical: " + (this.physicalPreparedStatement_ == null ? "null" : this.physicalPreparedStatement_.toString()) + "]");
    }

    protected void checkForExistenceOfRowsetAndLog(String string, String string2, String string3) {
        Level level;
        Matcher matcher = null;
        if (string != null) {
            matcher = StaticProfileConstants.ROWSETPat.matcher(string);
        }
        if (matcher != null && matcher.find() && this.logger_.isLoggable(level = Level.FINE)) {
            String string4 = DataLogger.getLocationInUserApplicationMessage();
            String string5 = DataLogger.warningMessagePrefix + Messages.getText("MSG_PROFILER_UPDATABLE_ROWSET_NOT_SUPPORTED_ARGS2", "pureQuery Runtime", string3, string4);
            this.logger_.logp(level, DataLogger.getShortName(this), string2, string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutionHandler getNewExecutionHandler() throws SQLException {
        ExecutionHandler executionHandler;
        Object[] objectArray;
        try {
            this.physicalPreparedStatement_.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.args_.length == 1 || this.args_.length == 3) {
            objectArray = new Object[]{this.args_[0], this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_};
            this.args_ = objectArray;
            this.method_ = ConnectionExecutionHandler.getMethodPrepareStatement4args();
        }
        if (!this.cachedConnectionAttributesForStatement_.equals(this.db2ConnExecutionHandler_.getCurrentConnectionAttributes())) {
            Object[] objectArray2 = objectArray = this.db2ConnExecutionHandler_.physicalConnection_;
            synchronized (objectArray) {
                try {
                    this.cachedConnectionAttributesForStatement_.transferCachedConnectionAttributes((Connection)objectArray);
                    executionHandler = this.getNewPreparedStatementExecutionHandler();
                    executionHandler.setCachedConnectionAttributes(this.cachedConnectionAttributesForStatement_);
                }
                catch (Throwable throwable) {
                    throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, throwable.getLocalizedMessage(), "", throwable, 11103);
                }
                finally {
                    try {
                        this.db2ConnExecutionHandler_.restoreConnectionAttributes();
                    }
                    catch (Throwable throwable) {
                        throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, throwable.getLocalizedMessage(), "", throwable, 11104);
                    }
                }
                // ** MonitorExit[var3_5] (shouldn't be in output)
            }
        }
        try {
            executionHandler = this.getNewPreparedStatementExecutionHandler();
        }
        catch (Throwable throwable) {
            throw ExceptionFactory.createDataSQLExceptionForOptimizer(this, throwable.getLocalizedMessage(), "", throwable, 11105);
        }
        {
            executionHandler.setAndTransferModifiedStatementAttributes(this.modifiedStatementAttributes_);
            return executionHandler;
        }
    }

    private ExecutionHandler getNewPreparedStatementExecutionHandler() throws SQLException {
        ExecutionHandler executionHandler;
        try {
            executionHandler = (ExecutionHandler)this.db2ConnExecutionHandler_.invoke(this.methodName_, this.method_, this.args_);
        }
        catch (Throwable throwable) {
            if (throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_STMT_RELOAD", throwable.toString()), throwable, 11759);
        }
        return executionHandler;
    }

    @Override
    public ExecutionHandler checkAndReplaceExecutionHandler() throws SQLException {
        if (this.propertyRefreshEnabled_ && this.propertyRedirectedKey_.isModified()) {
            PreparedStatement preparedStatement = this.physicalPreparedStatement_;
            ExecutionHandler executionHandler = this.getNewExecutionHandler();
            if (this.logger_.isLoggable(Level.CONFIG)) {
                JDBCDynamicExecutionHandlerPropertiesRefresh.logNewExecutionHandler(this.logger_, this.db2ConnectionExecutionHandler_.driverTraceOn_, this.sqlStr_, preparedStatement, this, executionHandler, this.db2ConnExecutionHandler_);
            }
            return executionHandler;
        }
        return this;
    }

    protected void setPhysicalPreparedStatement(PreparedStatement preparedStatement) {
        if (this.physicalPreparedStatement_ != null) {
            try {
                this.physicalPreparedStatement_.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.physicalPreparedStatement_ = preparedStatement;
        this.physicalStatement_ = preparedStatement;
    }

    public int getBatchCount() {
        return this.batchCount_;
    }

    public void setBatchCount(int n2) {
        this.batchCount_ = n2;
    }

    private static Class<?> getClassForNameUseThreadContextClassLoader(String string) throws Exception {
        return DB2PreparedStatementExecutionHandler.getClassForNameUseThreadContextClassLoaderNonPriv(string);
    }

    private static Class<?> getClassForNameUseThreadContextClassLoaderNonPriv(String string) throws Exception {
        return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
    }
}

