/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVar;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVarsContext;
import com.oracle.graal.python.lib.PyContextCopyCurrent;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextContextBuiltins {

    static abstract class PyContext_Exit
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyContext_Exit() {
        }

        @Specialization
        static Object doGeneric(PContextVarsContext context, @Bind Node inliningTarget, @Bind PythonContext pythonContext) {
            PythonContext.PythonThreadState threadState = pythonContext.getThreadState(pythonContext.getLanguage(inliningTarget));
            context.leave(threadState);
            return 0;
        }
    }

    static abstract class PyContext_Enter
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyContext_Enter() {
        }

        @Specialization
        static Object doGeneric(PContextVarsContext context, @Bind Node inliningTarget, @Bind PythonContext pythonContext, @Cached PRaiseNode raiseNode) {
            PythonContext.PythonThreadState threadState = pythonContext.getThreadState(pythonContext.getLanguage(inliningTarget));
            context.enter(inliningTarget, threadState, raiseNode);
            return 0;
        }
    }

    static abstract class PyContext_New
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyContext_New() {
        }

        @Specialization
        static Object doGeneric(@Bind PythonLanguage language) {
            return PFactory.createContextVarsContext(language);
        }
    }

    static abstract class PyContext_Copy
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyContext_Copy() {
        }

        @Specialization
        static Object doGeneric(PContextVarsContext context, @Bind PythonLanguage language) {
            return PFactory.copyContextVarsContext(language, context);
        }
    }

    static abstract class PyContext_CopyCurrent
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyContext_CopyCurrent() {
        }

        @Specialization
        static Object doGeneric(@Bind Node inliningTarget, @Cached PyContextCopyCurrent copyCurrent) {
            return copyCurrent.execute(inliningTarget);
        }
    }

    static abstract class PyContextVar_Set
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyContextVar_Set() {
        }

        @Specialization
        static Object doGeneric(Object var, Object val, @Bind Node inliningTarget, @Bind PythonContext pythonContext, @Cached PRaiseNode raiseNode) {
            if (!(var instanceof PContextVar)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.INSTANCE_OF_CONTEXTVAR_EXPECTED);
            }
            PContextVar pvar = (PContextVar)var;
            PythonLanguage language = pythonContext.getLanguage(inliningTarget);
            PythonContext.PythonThreadState threadState = pythonContext.getThreadState(language);
            Object oldValue = pvar.getValue(inliningTarget, threadState);
            pvar.setValue(inliningTarget, threadState, val);
            return PFactory.createContextVarsToken(language, pvar, oldValue);
        }
    }

    static abstract class GraalPyPrivate_ContextVar_Get
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        GraalPyPrivate_ContextVar_Get() {
        }

        @Specialization
        static Object doGeneric(Object var, Object def, Object marker, @Bind Node inliningTarget, @Bind PythonContext context, @Cached CExtNodes.PRaiseNativeNode.Lazy raiseNative) {
            if (!(var instanceof PContextVar)) {
                return raiseNative.get(inliningTarget).raise(null, marker, PythonBuiltinClassType.TypeError, ErrorMessages.INSTANCE_OF_CONTEXTVAR_EXPECTED, new Object[0]);
            }
            PythonContext.PythonThreadState threadState = context.getThreadState(context.getLanguage(inliningTarget));
            Object result = ((PContextVar)var).getValue(inliningTarget, threadState);
            if (result == null) {
                result = def == PNone.NO_VALUE ? (((PContextVar)var).getDefault() == PContextVar.NO_DEFAULT ? PNone.NO_VALUE : ((PContextVar)var).getDefault()) : def;
            }
            return result;
        }
    }

    static abstract class PyContextVar_New
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyContextVar_New() {
        }

        @Specialization
        static Object doGeneric(TruffleString name, Object def, @Cached CallNode callContextvar) {
            return callContextvar.executeWithoutFrame((Object)PythonBuiltinClassType.ContextVar, name, def);
        }

        @Specialization
        static Object doGeneric(PNone name, Object def) {
            assert (name == PNone.NO_VALUE);
            return PNone.NO_VALUE;
        }
    }

    static abstract class GraalPyPrivate_PrintStacktrace
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        GraalPyPrivate_PrintStacktrace() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object stacktrace() {
            ExceptionUtils.printPythonLikeStackTrace();
            return 0;
        }
    }
}

