package # C - Context
	C;  # Hide from PAUSE

use strict;
use warnings;



our $C;
sub C { return $C && $C->tx? $C : undef };


my $app;
sub app {
	!@_   or $app =  shift;

	return $app;
}


sub debug {
	$ENV{ DEBUG }  ||  app()->mode eq 'development';
}


my $conf =  {};
sub db     { app->db                             }
sub config { app? app->config : $conf            }
sub load   { $conf =  do shift   or die $@ || $! }



1;

=encoding utf8

=head1 NAME

C<C> - Context/Config


=head1 SYNOPSIS

  use C;

  C::app $app;
  my $conf =  C::load 'example.conf';

  my $app =  C::app;
  my $db  =  C::db;
  my $cfg =  C::config;
  my $ctx =  C::C;


=head1 DESCRIPTION

C<C> is a small collection of global accessors. It keeps references to the
current application object and, optionally, a request context object.


=head1 FUNCTIONS

=head2 C

  my $ctx =  C::C;

Return the current context stored in C<$C> if it is set and still has transaction
C<tx>. Otherwise returns undef.


=head2 app

  C::app $app;
  my $app =  C::app;

Set or get the application object.


=head2 debug

  my $bool =  C::debug;

True if C<$ENV{DEBUG}> is set or the application is in C<development> mode.


=head2 db

  my $db =  C::db;

Quick access to your DB handle. Shortcut for C<C::app-E<gt>db>.


=head2 config

  my $cfg =  C::config;

Return configuration. If an application object is set, this returns
C<C::app-E<gt>config>. Otherwise it returns the last configuration loaded
by L</load>.


=head2 load

  my $cfg =  C::load 'example.conf';

Evaluate a Perl config file with C<do> and store the returned value
(usually a hash reference). Dies on errors.

Configuration example:

  +{
    SectionOne => ... # Any regular perl data structure goes here
    DbAccess =>  {
      HOST =>  '127.0.0.1',
      PORT =>  5432,
      ROOT =>  'Htr0-ChangeThis',
      PASS =>  'WscH-ChangeThis',
    },
  };


=head1 SEE ALSO

L<A>, L<C>, L<I>, L<L>, L<M>, L<S>, L<T>, L<U>.

=cut
