package WWW::Hetzner::Cloud::PlacementGroup;
our $VERSION = '0.001';
our $AUTHORITY = 'cpan:GETTY';

# ABSTRACT: Hetzner Cloud Placement Group object

use Moo;
use Carp qw(croak);
use namespace::clean;

has _client => (
    is       => 'ro',
    required => 1,
    weak_ref => 1,
    init_arg => 'client',
);

has id => ( is => 'ro' );
has name => ( is => 'rw' );
has type => ( is => 'ro' );
has servers => ( is => 'ro', default => sub { [] } );
has labels => ( is => 'rw', default => sub { {} } );
has created => ( is => 'ro' );

# Actions
sub update {
    my ($self) = @_;
    croak "Cannot update placement group without ID" unless $self->id;

    $self->_client->put("/placement_groups/" . $self->id, {
        name   => $self->name,
        labels => $self->labels,
    });
    return $self;
}

sub delete {
    my ($self) = @_;
    croak "Cannot delete placement group without ID" unless $self->id;

    $self->_client->delete("/placement_groups/" . $self->id);
    return 1;
}

sub data {
    my ($self) = @_;
    return {
        id      => $self->id,
        name    => $self->name,
        type    => $self->type,
        servers => $self->servers,
        labels  => $self->labels,
        created => $self->created,
    };
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WWW::Hetzner::Cloud::PlacementGroup - Hetzner Cloud Placement Group object

=head1 VERSION

version 0.001

=head1 SYNOPSIS

    my $pg = $cloud->placement_groups->get($id);

    print $pg->name, "\n";
    print $pg->type, "\n";  # spread
    print scalar(@{$pg->servers}), " servers\n";

    # Update
    $pg->name('new-name');
    $pg->update;

    # Delete
    $pg->delete;

=head1 NAME

WWW::Hetzner::Cloud::PlacementGroup - Hetzner Cloud Placement Group object

=for :stopwords cpan testmatrix url bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan

=head1 SUPPORT

=head2 Source Code

The code is open to the world, and available for you to hack on. Please feel free to browse it and play
with it, or whatever. If you want to contribute patches, please send me a diff or prod me to pull
from your repository :)

L<https://github.com/Getty/p5-www-hetzner>

  git clone https://github.com/Getty/p5-www-hetzner.git

=head1 AUTHOR

Torsten Raudssus <torsten@raudssus.de>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2026 by Torsten Raudssus.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
