use Test::More;

use strict;
use warnings;
use FindBin;
use lib "$FindBin::Bin/lib";
BEGIN { $ENV{SPVM_BUILD_DIR} = "$FindBin::Bin/.spvm_build"; }

use SPVM 'TestCase::Thread';

use SPVM 'Fn';
use SPVM::Thread;

my $api = SPVM::api();

my $start_memory_blocks_count = $api->get_memory_blocks_count;

# ok(SPVM::TestCase::Thread->basic);

# ok(SPVM::TestCase::Thread->thread_id);

ok(SPVM::TestCase::Thread->exception);

# Version
{
  is($SPVM::Thread::VERSION, SPVM::Fn->get_version_string('Thread'));
}

SPVM::Fn->destroy_runtime_permanent_vars;

my $end_memory_blocks_count = $api->get_memory_blocks_count;
is($end_memory_blocks_count, $start_memory_blocks_count);

done_testing;
