/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import java.util.Objects;

public final class CorePrefixFilter {
    private final String[] acceptedPrefixes;
    public static final CorePrefixFilter DEFAULT_INSTANCE = new CorePrefixFilter();

    CorePrefixFilter() {
        this("jakarta.", "java.", "org.hibernate.annotations.", "org.hibernate.bytecode.enhance.spi.", "org.hibernate.engine.spi.");
    }

    public CorePrefixFilter(String ... acceptedPrefixes) {
        this.acceptedPrefixes = Objects.requireNonNull(acceptedPrefixes);
    }

    public boolean isCoreClassName(String name) {
        for (String acceptedPrefix : this.acceptedPrefixes) {
            if (!name.startsWith(acceptedPrefix)) continue;
            return true;
        }
        return false;
    }
}

