/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.playlist;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.playlist.FilePlayListReplayFile;
import org.pentaho.di.core.vfs.KettleVFS;

class FilePlayListReplayLineNumberFile
extends FilePlayListReplayFile {
    Set<Long> lineNumbers = new HashSet<Long>();

    public FilePlayListReplayLineNumberFile(FileObject lineNumberFile, String encoding, FileObject processingFile, String filePart) throws KettleException {
        super(processingFile, filePart);
        this.initialize(lineNumberFile, encoding);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialize(FileObject lineNumberFile, String encoding) throws KettleException {
        BufferedReader reader = null;
        reader = encoding == null ? new BufferedReader(new InputStreamReader(KettleVFS.getInputStream((FileObject)lineNumberFile))) : new BufferedReader(new InputStreamReader(KettleVFS.getInputStream((FileObject)lineNumberFile), encoding));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.length() <= 0) continue;
            this.lineNumbers.add(Long.valueOf(line));
        }
        Object var6_6 = null;
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException e) {
            LogWriter.getInstance().logBasic("TextFilePlayLineNumber", "Could not close line number file " + lineNumberFile.getName().getURI(), new Object[0]);
        }
        return;
        {
            catch (Exception e) {
                throw new KettleException("Could not read line number file " + lineNumberFile.getName().getURI(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                LogWriter.getInstance().logBasic("TextFilePlayLineNumber", "Could not close line number file " + lineNumberFile.getName().getURI(), new Object[0]);
            }
            throw throwable;
        }
    }

    public boolean isProcessingNeeded(FileObject file, long lineNr, String filePart) throws KettleException {
        return this.lineNumbers.contains(new Long(lineNr));
    }
}

