/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.setvariables;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleJobException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.setvariables.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntrySetVariables
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    public boolean replaceVars;
    public String[] variableName;
    public String[] variableValue;
    public int[] variableType;
    public static final int VARIABLE_TYPE_JVM = 0;
    public static final int VARIABLE_TYPE_CURRENT_JOB = 1;
    public static final int VARIABLE_TYPE_PARENT_JOB = 2;
    public static final int VARIABLE_TYPE_ROOT_JOB = 3;
    private static final String[] variableTypeCode = new String[]{"JVM", "CURRENT_JOB", "PARENT_JOB", "ROOT_JOB"};
    private static final String[] variableTypeDesc = new String[]{Messages.getString("JobEntrySetVariables.VariableType.JVM"), Messages.getString("JobEntrySetVariables.VariableType.CurrentJob"), Messages.getString("JobEntrySetVariables.VariableType.ParentJob"), Messages.getString("JobEntrySetVariables.VariableType.RootJob")};

    public JobEntrySetVariables(String n) {
        super(n, "");
        this.replaceVars = false;
        this.variableName = null;
        this.variableValue = null;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.SET_VARIABLES);
    }

    public JobEntrySetVariables() {
        this("");
    }

    public JobEntrySetVariables(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntrySetVariables je = (JobEntrySetVariables)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"replacevars", (boolean)this.replaceVars));
        retval.append("      <fields>").append(Const.CR);
        if (this.variableName != null) {
            for (int i = 0; i < this.variableName.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"variable_name", (String)this.variableName[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"variable_value", (String)this.variableValue[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"variable_type", (String)JobEntrySetVariables.getVariableTypeCode(this.variableType[i])));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.replaceVars = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"replacevars"));
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.variableName = new String[nrFields];
            this.variableValue = new String[nrFields];
            this.variableType = new int[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.variableName[i] = XMLHandler.getTagValue((Node)fnode, (String)"variable_name");
                this.variableValue[i] = XMLHandler.getTagValue((Node)fnode, (String)"variable_value");
                this.variableType[i] = JobEntrySetVariables.getVariableType(XMLHandler.getTagValue((Node)fnode, (String)"variable_type"));
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(Messages.getString("JobEntrySetVariables.Meta.UnableLoadXML", xe.getMessage()), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.replaceVars = rep.getJobEntryAttributeBoolean(id_jobentry, "replacevars");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "variable_name");
            this.variableName = new String[argnr];
            this.variableValue = new String[argnr];
            this.variableType = new int[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.variableName[a] = rep.getJobEntryAttributeString(id_jobentry, a, "variable_name");
                this.variableValue[a] = rep.getJobEntryAttributeString(id_jobentry, a, "variable_value");
                this.variableType[a] = JobEntrySetVariables.getVariableType(rep.getJobEntryAttributeString(id_jobentry, a, "variable_type"));
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("JobEntrySetVariables.Meta.UnableLoadRep", String.valueOf(id_jobentry), dbe.getMessage()), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "replacevars", this.replaceVars);
            if (this.variableName != null) {
                for (int i = 0; i < this.variableName.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "variable_name", this.variableName[i]);
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "variable_value", this.variableValue[i]);
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "variable_type", JobEntrySetVariables.getVariableTypeCode(this.variableType[i]));
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntrySetVariables.Meta.UnableSaveRep", String.valueOf(id_job), dbe.getMessage()), (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result result, int nr, Repository rep, Job parentJob) throws KettleException {
        LogWriter log = LogWriter.getInstance();
        result.setResult(false);
        result.setNrErrors(1L);
        try {
            if (this.variableName != null) {
                for (int i = 0; i < this.variableName.length && !parentJob.isStopped(); ++i) {
                    String varname = this.variableName[i];
                    String value = this.variableValue[i];
                    if (this.replaceVars) {
                        varname = this.environmentSubstitute(varname);
                        value = this.environmentSubstitute(value);
                    }
                    switch (this.getVariableType()[i]) {
                        case 0: {
                            System.setProperty(varname, value);
                            this.setVariable(varname, value);
                            Job parentjob = parentJob;
                            while (parentjob != null) {
                                parentjob.setVariable(varname, value);
                                parentjob = parentJob.getParentJob();
                            }
                            break;
                        }
                        case 3: {
                            this.setVariable(varname, value);
                            for (Job rootJob = parentJob; rootJob != null; rootJob = rootJob.getParentJob()) {
                                rootJob.setVariable(varname, value);
                            }
                            break;
                        }
                        case 1: {
                            this.setVariable(varname, value);
                            if (parentJob != null) {
                                parentJob.setVariable(varname, value);
                                break;
                            }
                            throw new KettleJobException(Messages.getString("JobEntrySetVariables.Error.UnableSetVariableCurrentJob", varname));
                        }
                        case 2: {
                            this.setVariable(varname, value);
                            if (parentJob != null) {
                                parentJob.setVariable(varname, value);
                                Job gpJob = parentJob.getParentJob();
                                if (gpJob != null) {
                                    gpJob.setVariable(varname, value);
                                    break;
                                }
                                throw new KettleJobException(Messages.getString("JobEntrySetVariables.Error.UnableSetVariableParentJob", varname));
                            }
                            throw new KettleJobException(Messages.getString("JobEntrySetVariables.Error.UnableSetVariableCurrentJob", varname));
                        }
                    }
                    result.setResult(true);
                    result.setNrErrors(0L);
                    if (!log.isDetailed()) continue;
                    log.logDetailed(this.toString(), Messages.getString("JobEntrySetVariables.Log.SetVariableToValue", varname, value), new Object[0]);
                }
            }
        }
        catch (Exception e) {
            log.logError(this.toString(), Messages.getString("JobEntrySetVariables.UnExcpectedError", e.getMessage()), new Object[0]);
        }
        return result;
    }

    public void setReplaceVars(boolean replaceVars) {
        this.replaceVars = replaceVars;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public boolean isReplaceVars() {
        return this.replaceVars;
    }

    public String[] getVariableValue() {
        return this.variableValue;
    }

    public void setVariableName(String[] fieldValue) {
        this.variableName = fieldValue;
    }

    public int[] getVariableType() {
        return this.variableType;
    }

    public static final String getVariableTypeCode(int variableType) {
        return variableTypeCode[variableType];
    }

    public static final String getVariableTypeDescription(int variableType) {
        return variableTypeDesc[variableType];
    }

    public static final int getVariableType(String variableType) {
        int i;
        for (i = 0; i < variableTypeCode.length; ++i) {
            if (!variableTypeCode[i].equalsIgnoreCase(variableType)) continue;
            return i;
        }
        for (i = 0; i < variableTypeDesc.length; ++i) {
            if (!variableTypeDesc[i].equalsIgnoreCase(variableType)) continue;
            return i;
        }
        return 0;
    }

    public void setVariableType(int[] localVariable) {
        this.variableType = localVariable;
    }

    public static final String[] getVariableTypeDescriptions() {
        return variableTypeDesc;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "variableName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.variableName.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "variableName[" + i + "]", remarks, ctx);
        }
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.variableName != null) {
            ResourceReference reference = null;
            for (int i = 0; i < this.variableName.length; ++i) {
                String filename = jobMeta.environmentSubstitute(this.variableName[i]);
                if (reference == null) {
                    reference = new ResourceReference(this);
                    references.add(reference);
                }
                reference.getEntries().add(new ResourceEntry(filename, ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }
}

