/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.session;

import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.session.BuildSessionActionExecutor;
import org.gradle.internal.session.BuildSessionContext;
import org.gradle.internal.session.BuildSessionLifecycleListener;

class DefaultBuildSessionContext
implements BuildSessionContext {
    private final ServiceRegistry sessionScopeServices;
    private boolean completed;

    public DefaultBuildSessionContext(ServiceRegistry sessionScopeServices) {
        this.sessionScopeServices = sessionScopeServices;
    }

    @Override
    public ServiceRegistry getServices() {
        return this.sessionScopeServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildActionRunner.Result execute(BuildAction action) {
        if (this.completed) {
            throw new IllegalStateException("Cannot run more than one action for a session.");
        }
        try {
            BuildActionRunner.Result result;
            BuildSessionLifecycleListener sessionLifecycleListener = (BuildSessionLifecycleListener)((ListenerManager)this.sessionScopeServices.get(ListenerManager.class)).getBroadcaster(BuildSessionLifecycleListener.class);
            sessionLifecycleListener.afterStart();
            try {
                result = ((BuildSessionActionExecutor)this.sessionScopeServices.get(BuildSessionActionExecutor.class)).execute(action, this);
            }
            catch (Throwable throwable) {
                sessionLifecycleListener.beforeComplete();
                throw throwable;
            }
            sessionLifecycleListener.beforeComplete();
            return result;
        }
        finally {
            this.completed = true;
        }
    }
}

