/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.errors.PackMismatchException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.CachedObjectDirectory;
import org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;
import org.eclipse.jgit.internal.storage.file.LooseObjects;
import org.eclipse.jgit.internal.storage.file.ObjectDirectoryInserter;
import org.eclipse.jgit.internal.storage.file.Pack;
import org.eclipse.jgit.internal.storage.file.PackDirectory;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.PackInserter;
import org.eclipse.jgit.internal.storage.file.WindowCursor;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;

public class ObjectDirectory
extends FileObjectDatabase {
    private static final int RESOLVE_ABBREV_LIMIT = 256;
    private final AlternateHandle handle = new AlternateHandle(this);
    private final Config config;
    private final File objects;
    private final File infoDirectory;
    private final LooseObjects loose;
    private final PackDirectory packed;
    private final PackDirectory preserved;
    private final File alternatesFile;
    private final FS fs;
    private final AtomicReference<AlternateHandle[]> alternates;
    private final File shallowFile;
    private FileSnapshot shallowFileSnapshot = FileSnapshot.DIRTY;
    private Set<ObjectId> shallowCommitsIds;

    public ObjectDirectory(Config cfg, File dir, File[] alternatePaths, FS fs, File shallowFile) throws IOException {
        this.config = cfg;
        this.objects = dir;
        this.infoDirectory = new File(this.objects, "info");
        File packDirectory = new File(this.objects, "pack");
        File preservedDirectory = new File(packDirectory, "preserved");
        this.alternatesFile = new File(this.objects, "info/alternates");
        this.loose = new LooseObjects(this.objects);
        this.packed = new PackDirectory(this.config, packDirectory);
        this.preserved = new PackDirectory(this.config, preservedDirectory);
        this.fs = fs;
        this.shallowFile = shallowFile;
        this.alternates = new AtomicReference();
        if (alternatePaths != null) {
            AlternateHandle[] alt = new AlternateHandle[alternatePaths.length];
            int i = 0;
            while (i < alternatePaths.length) {
                alt[i] = this.openAlternate(alternatePaths[i]);
                ++i;
            }
            this.alternates.set(alt);
        }
    }

    @Override
    public final File getDirectory() {
        return this.loose.getDirectory();
    }

    public final File getPackDirectory() {
        return this.packed.getDirectory();
    }

    public final File getPreservedDirectory() {
        return this.preserved.getDirectory();
    }

    @Override
    public boolean exists() {
        return this.fs.exists(this.objects);
    }

    @Override
    public void create() throws IOException {
        this.loose.create();
        FileUtils.mkdir(this.infoDirectory);
        this.packed.create();
    }

    @Override
    public ObjectDirectoryInserter newInserter() {
        return new ObjectDirectoryInserter(this, this.config);
    }

    public PackInserter newPackInserter() {
        return new PackInserter(this);
    }

    @Override
    public void close() {
        this.loose.close();
        this.packed.close();
        AlternateHandle[] alt = this.alternates.get();
        if (alt != null && this.alternates.compareAndSet(alt, null)) {
            AlternateHandle[] alternateHandleArray = alt;
            int n = alt.length;
            int n2 = 0;
            while (n2 < n) {
                AlternateHandle od = alternateHandleArray[n2];
                od.close();
                ++n2;
            }
        }
    }

    @Override
    public Collection<Pack> getPacks() {
        return this.packed.getPacks();
    }

    @Override
    public Pack openPack(File pack) throws IOException {
        PackFile pf;
        try {
            pf = new PackFile(pack);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(MessageFormat.format(JGitText.get().notAValidPack, pack), e);
        }
        String p = pf.getName();
        if (p.length() != 50 || !p.startsWith("pack-") || !pf.getPackExt().equals((Object)PackExt.PACK)) {
            throw new IOException(MessageFormat.format(JGitText.get().notAValidPack, pack));
        }
        PackFile bitmapIdx = pf.create(PackExt.BITMAP_INDEX);
        Pack res = new Pack(pack, bitmapIdx.exists() ? bitmapIdx : null);
        this.packed.insert(res);
        return res;
    }

    public String toString() {
        return "ObjectDirectory[" + this.getDirectory() + "]";
    }

    @Override
    public boolean has(AnyObjectId objectId) {
        return this.loose.hasCached(objectId) || this.hasPackedOrLooseInSelfOrAlternate(objectId) || this.restoreFromSelfOrAlternate(objectId, null) && this.hasPackedOrLooseInSelfOrAlternate(objectId);
    }

    private boolean hasPackedOrLooseInSelfOrAlternate(AnyObjectId objectId) {
        return this.hasPackedInSelfOrAlternate(objectId, null) || this.hasLooseInSelfOrAlternate(objectId, null);
    }

    private boolean hasPackedInSelfOrAlternate(AnyObjectId objectId, Set<AlternateHandle.Id> skips) {
        if (this.hasPackedObject(objectId)) {
            return true;
        }
        skips = this.addMe(skips);
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            if (!skips.contains(alt.getId()) && alt.db.hasPackedInSelfOrAlternate(objectId, skips)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasLooseInSelfOrAlternate(AnyObjectId objectId, Set<AlternateHandle.Id> skips) {
        if (this.loose.has(objectId)) {
            return true;
        }
        skips = this.addMe(skips);
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            if (!skips.contains(alt.getId()) && alt.db.hasLooseInSelfOrAlternate(objectId, skips)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean hasPackedObject(AnyObjectId objectId) {
        return this.packed.has(objectId);
    }

    @Override
    void resolve(Set<ObjectId> matches, AbbreviatedObjectId id) throws IOException {
        this.resolve(matches, id, null);
    }

    private void resolve(Set<ObjectId> matches, AbbreviatedObjectId id, Set<AlternateHandle.Id> skips) throws IOException {
        if (!this.packed.resolve(matches, id, 256)) {
            return;
        }
        if (!this.loose.resolve(matches, id, 256)) {
            return;
        }
        skips = this.addMe(skips);
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            if (!skips.contains(alt.getId())) {
                alt.db.resolve(matches, id, skips);
                if (matches.size() > 256) {
                    return;
                }
            }
            ++n2;
        }
    }

    @Override
    ObjectLoader openObject(WindowCursor curs, AnyObjectId objectId) throws IOException {
        ObjectLoader ldr = this.openObjectWithoutRestoring(curs, objectId);
        if (ldr == null && this.restoreFromSelfOrAlternate(objectId, null)) {
            ldr = this.openObjectWithoutRestoring(curs, objectId);
        }
        return ldr;
    }

    private ObjectLoader openObjectWithoutRestoring(WindowCursor curs, AnyObjectId objectId) throws IOException {
        ObjectLoader ldr;
        if (this.loose.hasCached(objectId) && (ldr = this.openLooseObject(curs, objectId)) != null) {
            return ldr;
        }
        ldr = this.openPackedFromSelfOrAlternate(curs, objectId, null);
        if (ldr != null) {
            return ldr;
        }
        return this.openLooseFromSelfOrAlternate(curs, objectId, null);
    }

    private ObjectLoader openPackedFromSelfOrAlternate(WindowCursor curs, AnyObjectId objectId, Set<AlternateHandle.Id> skips) throws PackMismatchException {
        ObjectLoader ldr = this.openPackedObject(curs, objectId);
        if (ldr != null) {
            return ldr;
        }
        skips = this.addMe(skips);
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            if (!skips.contains(alt.getId()) && (ldr = alt.db.openPackedFromSelfOrAlternate(curs, objectId, skips)) != null) {
                return ldr;
            }
            ++n2;
        }
        return null;
    }

    private ObjectLoader openLooseFromSelfOrAlternate(WindowCursor curs, AnyObjectId objectId, Set<AlternateHandle.Id> skips) throws IOException {
        ObjectLoader ldr = this.openLooseObject(curs, objectId);
        if (ldr != null) {
            return ldr;
        }
        skips = this.addMe(skips);
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            if (!skips.contains(alt.getId()) && (ldr = alt.db.openLooseFromSelfOrAlternate(curs, objectId, skips)) != null) {
                return ldr;
            }
            ++n2;
        }
        return null;
    }

    ObjectLoader openPackedObject(WindowCursor curs, AnyObjectId objectId) throws PackMismatchException {
        return this.packed.open(curs, objectId);
    }

    @Override
    ObjectLoader openLooseObject(WindowCursor curs, AnyObjectId id) throws IOException {
        return this.loose.open(curs, id);
    }

    @Override
    long getObjectSize(WindowCursor curs, AnyObjectId id) throws IOException {
        long sz = this.getObjectSizeWithoutRestoring(curs, id);
        if (0L > sz && this.restoreFromSelfOrAlternate(id, null)) {
            sz = this.getObjectSizeWithoutRestoring(curs, id);
        }
        return sz;
    }

    private long getObjectSizeWithoutRestoring(WindowCursor curs, AnyObjectId id) throws IOException {
        long len;
        if (this.loose.hasCached(id) && 0L <= (len = this.loose.getSize(curs, id))) {
            return len;
        }
        len = this.getPackedSizeFromSelfOrAlternate(curs, id, null);
        if (0L <= len) {
            return len;
        }
        return this.getLooseSizeFromSelfOrAlternate(curs, id, null);
    }

    private long getPackedSizeFromSelfOrAlternate(WindowCursor curs, AnyObjectId id, Set<AlternateHandle.Id> skips) throws PackMismatchException {
        long len = this.packed.getSize(curs, id);
        if (0L <= len) {
            return len;
        }
        skips = this.addMe(skips);
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            if (!skips.contains(alt.getId()) && 0L <= (len = alt.db.getPackedSizeFromSelfOrAlternate(curs, id, skips))) {
                return len;
            }
            ++n2;
        }
        return -1L;
    }

    private long getLooseSizeFromSelfOrAlternate(WindowCursor curs, AnyObjectId id, Set<AlternateHandle.Id> skips) throws IOException {
        long len = this.loose.getSize(curs, id);
        if (0L <= len) {
            return len;
        }
        skips = this.addMe(skips);
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            if (!skips.contains(alt.getId()) && 0L <= (len = alt.db.getLooseSizeFromSelfOrAlternate(curs, id, skips))) {
                return len;
            }
            ++n2;
        }
        return -1L;
    }

    @Override
    void selectObjectRepresentation(PackWriter packer, ObjectToPack otp, WindowCursor curs) throws IOException {
        this.selectObjectRepresentation(packer, otp, curs, null);
    }

    private void selectObjectRepresentation(PackWriter packer, ObjectToPack otp, WindowCursor curs, Set<AlternateHandle.Id> skips) throws IOException {
        this.packed.selectRepresentation(packer, otp, curs);
        skips = this.addMe(skips);
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle h = alternateHandleArray[n2];
            if (!skips.contains(h.getId())) {
                h.db.selectObjectRepresentation(packer, otp, curs, skips);
            }
            ++n2;
        }
    }

    private boolean restoreFromSelfOrAlternate(AnyObjectId objectId, Set<AlternateHandle.Id> skips) {
        if (this.restoreFromSelf(objectId)) {
            return true;
        }
        skips = this.addMe(skips);
        AlternateHandle[] alternateHandleArray = this.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlternateHandle alt = alternateHandleArray[n2];
            if (!skips.contains(alt.getId()) && alt.db.restoreFromSelfOrAlternate(objectId, skips)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean restoreFromSelf(AnyObjectId objectId) {
        Pack preservedPack = this.preserved.getPack(objectId);
        if (preservedPack == null) {
            return false;
        }
        PackFile preservedFile = new PackFile(preservedPack.getPackFile());
        PackExt[] packExtArray = PackExt.values();
        int n = packExtArray.length;
        int n2 = 0;
        while (n2 < n) {
            PackExt ext = packExtArray[n2];
            if (!PackExt.INDEX.equals((Object)ext)) {
                this.restore(preservedFile.create(ext));
            }
            ++n2;
        }
        this.restore(preservedFile.create(PackExt.INDEX));
        return true;
    }

    private boolean restore(PackFile preservedPack) {
        PackFile restored = preservedPack.createForDirectory(this.packed.getDirectory());
        try {
            Files.createLink(restored.toPath(), preservedPack.toPath());
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    FileObjectDatabase.InsertLooseObjectResult insertUnpackedObject(File tmp, ObjectId id, boolean createDuplicate) throws IOException {
        if (this.loose.hasCached(id)) {
            FileUtils.delete(tmp, 2);
            return FileObjectDatabase.InsertLooseObjectResult.EXISTS_LOOSE;
        }
        if (!createDuplicate && this.has(id)) {
            FileUtils.delete(tmp, 2);
            return FileObjectDatabase.InsertLooseObjectResult.EXISTS_PACKED;
        }
        return this.loose.insert(tmp, id);
    }

    @Override
    Config getConfig() {
        return this.config;
    }

    @Override
    FS getFS() {
        return this.fs;
    }

    @Override
    Set<ObjectId> getShallowCommits() throws IOException {
        if (this.shallowFile == null || !this.shallowFile.isFile()) {
            return Collections.emptySet();
        }
        if (this.shallowFileSnapshot == null || this.shallowFileSnapshot.isModified(this.shallowFile)) {
            this.shallowCommitsIds = new HashSet<ObjectId>();
            Throwable throwable = null;
            Object var2_3 = null;
            try (BufferedReader reader = ObjectDirectory.open(this.shallowFile);){
                String line;
                while ((line = reader.readLine()) != null) {
                    try {
                        this.shallowCommitsIds.add(ObjectId.fromString(line));
                    }
                    catch (IllegalArgumentException ex) {
                        throw new IOException(MessageFormat.format(JGitText.get().badShallowLine, line), ex);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.shallowFileSnapshot = FileSnapshot.save(this.shallowFile);
        }
        return this.shallowCommitsIds;
    }

    void closeAllPackHandles(File packFile) {
        if (packFile.exists()) {
            for (Pack p : this.packed.getPacks()) {
                if (!packFile.getPath().equals(p.getPackFile().getPath())) continue;
                p.close();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AlternateHandle[] myAlternates() {
        AlternateHandle[] alt = this.alternates.get();
        if (alt == null) {
            AtomicReference<AlternateHandle[]> atomicReference = this.alternates;
            synchronized (atomicReference) {
                alt = this.alternates.get();
                if (alt == null) {
                    try {
                        alt = this.loadAlternates();
                    }
                    catch (IOException e) {
                        alt = new AlternateHandle[]{};
                    }
                    this.alternates.set(alt);
                }
            }
        }
        return alt;
    }

    Set<AlternateHandle.Id> addMe(Set<AlternateHandle.Id> skips) {
        if (skips == null) {
            skips = new HashSet<AlternateHandle.Id>();
        }
        skips.add(this.handle.getId());
        return skips;
    }

    private AlternateHandle[] loadAlternates() throws IOException {
        ArrayList<AlternateHandle> l = new ArrayList<AlternateHandle>(4);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = ObjectDirectory.open(this.alternatesFile);){
            String line;
            while ((line = br.readLine()) != null) {
                l.add(this.openAlternate(line));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return l.toArray(new AlternateHandle[0]);
    }

    private static BufferedReader open(File f) throws IOException, FileNotFoundException {
        return Files.newBufferedReader(f.toPath(), StandardCharsets.UTF_8);
    }

    private AlternateHandle openAlternate(String location) throws IOException {
        File objdir = this.fs.resolve(this.objects, location);
        return this.openAlternate(objdir);
    }

    private AlternateHandle openAlternate(File objdir) throws IOException {
        File parent = objdir.getParentFile();
        if (RepositoryCache.FileKey.isGitRepository(parent, this.fs)) {
            RepositoryCache.FileKey key = RepositoryCache.FileKey.exact(parent, this.fs);
            FileRepository db = (FileRepository)RepositoryCache.open(key);
            return new AlternateRepository(db);
        }
        ObjectDirectory db = new ObjectDirectory(this.config, objdir, null, this.fs, null);
        return new AlternateHandle(db);
    }

    @Override
    public File fileFor(AnyObjectId objectId) {
        return this.loose.fileFor(objectId);
    }

    @Override
    public ObjectDatabase newCachedDatabase() {
        return this.newCachedFileObjectDatabase();
    }

    CachedObjectDirectory newCachedFileObjectDatabase() {
        return new CachedObjectDirectory(this);
    }

    AlternateHandle.Id getAlternateId() {
        return new AlternateHandle.Id(this.objects);
    }

    static class AlternateHandle {
        final ObjectDirectory db;

        AlternateHandle(ObjectDirectory db) {
            this.db = db;
        }

        void close() {
            this.db.close();
        }

        public Id getId() {
            return this.db.getAlternateId();
        }

        static class Id {
            String alternateId;

            public Id(File object) {
                try {
                    this.alternateId = object.getCanonicalPath();
                }
                catch (Exception e) {
                    this.alternateId = null;
                }
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (o == null || !(o instanceof Id)) {
                    return false;
                }
                Id aId = (Id)o;
                return Objects.equals(this.alternateId, aId.alternateId);
            }

            public int hashCode() {
                if (this.alternateId == null) {
                    return 1;
                }
                return this.alternateId.hashCode();
            }
        }
    }

    static class AlternateRepository
    extends AlternateHandle {
        final FileRepository repository;

        AlternateRepository(FileRepository r) {
            super(r.getObjectDatabase());
            this.repository = r;
        }

        @Override
        void close() {
            this.repository.close();
        }
    }
}

