/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output;

import com.sun.star.awt.Size;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.libreoffice.report.ImageService;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.OutputRepository;
import org.libreoffice.report.ReportExecutionException;
import org.libreoffice.report.pentaho.DefaultNameGenerator;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.PngEncoder;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;

public class ImageProducer {
    private static final Logger LOGGER = Logger.getLogger(ImageProducer.class.getName());
    private final Map<Object, OfficeImage> imageCache;
    private final InputRepository inputRepository;
    private final OutputRepository outputRepository;
    private final ImageService imageService;

    public ImageProducer(InputRepository inputRepository, OutputRepository outputRepository, ImageService imageService) {
        if (inputRepository == null) {
            throw new NullPointerException();
        }
        if (outputRepository == null) {
            throw new NullPointerException();
        }
        if (imageService == null) {
            throw new NullPointerException();
        }
        this.inputRepository = inputRepository;
        this.outputRepository = outputRepository;
        this.imageService = imageService;
        this.imageCache = new HashMap<Object, OfficeImage>();
    }

    public OfficeImage produceImage(Object object, boolean bl) {
        LOGGER.config("Want to produce image " + object);
        if (object instanceof String) {
            return this.produceFromString((String)object, bl);
        }
        if (object instanceof URL) {
            return this.produceFromURL((URL)object, bl);
        }
        if (object instanceof Blob) {
            return this.produceFromBlob((Blob)object);
        }
        if (object instanceof byte[]) {
            return this.produceFromByteArray((byte[])object);
        }
        if (object instanceof Image) {
            return this.produceFromImage((Image)object);
        }
        return null;
    }

    private OfficeImage produceFromImage(Image image) {
        WaitingImageObserver waitingImageObserver = new WaitingImageObserver(image);
        waitingImageObserver.waitImageLoaded();
        PngEncoder pngEncoder = new PngEncoder(image, true, 0, 5);
        byte[] byArray = pngEncoder.pngEncode();
        return this.produceFromByteArray(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OfficeImage produceFromBlob(Blob blob) {
        try {
            InputStream inputStream = blob.getBinaryStream();
            int n = (int)blob.length();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
            try {
                IOUtils.getInstance().copyStreams(inputStream, byteArrayOutputStream);
            }
            finally {
                inputStream.close();
            }
            return this.produceFromByteArray(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            LOGGER.warning("Failed to produce image from Blob: " + iOException);
        }
        catch (SQLException sQLException) {
            LOGGER.warning("Failed to produce image from Blob: " + sQLException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OfficeImage produceFromByteArray(byte[] byArray) {
        ByteDataImageKey byteDataImageKey = new ByteDataImageKey(byArray);
        OfficeImage officeImage = this.imageCache.get(byteDataImageKey);
        if (officeImage != null) {
            return officeImage;
        }
        try {
            String string = this.imageService.getMimeType(byArray);
            Size size = this.imageService.getImageSize(byArray);
            OutputRepository outputRepository = this.outputRepository.openOutputRepository("Pictures", null);
            DefaultNameGenerator defaultNameGenerator = new DefaultNameGenerator(outputRepository);
            String string2 = defaultNameGenerator.generateName("image", string);
            OutputStream outputStream = outputRepository.createOutputStream(string2, string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                IOUtils.getInstance().copyStreams(byteArrayInputStream, outputStream);
            }
            finally {
                outputStream.close();
                outputRepository.closeOutputRepository();
            }
            CSSNumericValue cSSNumericValue = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.MM, (double)((double)size.Width / 100.0));
            CSSNumericValue cSSNumericValue2 = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.MM, (double)((double)size.Height / 100.0));
            OfficeImage officeImage2 = new OfficeImage("Pictures/" + string2, cSSNumericValue, cSSNumericValue2);
            this.imageCache.put(byteDataImageKey, officeImage2);
            return officeImage2;
        }
        catch (IOException iOException) {
            LOGGER.warning("Failed to load image from local input-repository: " + iOException);
        }
        catch (ReportExecutionException reportExecutionException) {
            LOGGER.warning("Failed to create image from local input-repository: " + reportExecutionException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OfficeImage produceFromString(String string, boolean bl) {
        try {
            URL uRL = new URL(string);
            return this.produceFromURL(uRL, bl);
        }
        catch (MalformedURLException malformedURLException) {
            OfficeImage officeImage = this.imageCache.get(string);
            if (officeImage != null) {
                return officeImage;
            }
            if (this.inputRepository.isReadable(string)) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
                    try (InputStream inputStream = this.inputRepository.createInputStream(string);){
                        IOUtils.getInstance().copyStreams(inputStream, byteArrayOutputStream);
                    }
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    Size size = this.imageService.getImageSize(byArray);
                    String string2 = this.imageService.getMimeType(byArray);
                    CSSNumericValue cSSNumericValue = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.MM, (double)((double)size.Width / 100.0));
                    CSSNumericValue cSSNumericValue2 = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.MM, (double)((double)size.Height / 100.0));
                    String string3 = this.copyToOutputRepository(string2, byArray);
                    OfficeImage officeImage2 = new OfficeImage(string3, cSSNumericValue, cSSNumericValue2);
                    this.imageCache.put(string, officeImage2);
                    return officeImage2;
                }
                catch (IOException iOException) {
                    LOGGER.warning("Failed to load image from local input-repository: " + iOException);
                }
                catch (ReportExecutionException reportExecutionException) {
                    LOGGER.warning("Failed to create image from local input-repository: " + reportExecutionException);
                }
            } else {
                try {
                    URI uRI = new URI(this.inputRepository.getRootURL());
                    URI uRI2 = uRI.resolve(string);
                    return this.produceFromURL(uRI2.toURL(), bl);
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (MalformedURLException malformedURLException2) {
                    // empty catch block
                }
            }
            OfficeImage officeImage3 = new OfficeImage(string, null, null);
            this.imageCache.put(string, officeImage3);
            return officeImage3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OfficeImage produceFromURL(URL uRL, boolean bl) {
        String string = uRL.toString();
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            Logger.getLogger(ImageProducer.class.getName()).log(Level.SEVERE, null, uRISyntaxException);
        }
        OfficeImage officeImage = this.imageCache.get(uRI);
        if (officeImage != null) {
            return officeImage;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
            URLConnection uRLConnection = uRL.openConnection();
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());){
                IOUtils.getInstance().copyStreams(bufferedInputStream, byteArrayOutputStream);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Size size = this.imageService.getImageSize(byArray);
            String string2 = this.imageService.getMimeType(byArray);
            CSSNumericValue cSSNumericValue = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.MM, (double)((double)size.Width / 100.0));
            CSSNumericValue cSSNumericValue2 = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.MM, (double)((double)size.Height / 100.0));
            if (bl) {
                OfficeImage officeImage2 = new OfficeImage(string, cSSNumericValue, cSSNumericValue2);
                this.imageCache.put(uRI, officeImage2);
                return officeImage2;
            }
            String string3 = this.copyToOutputRepository(string2, byArray);
            OfficeImage officeImage3 = new OfficeImage(string3, cSSNumericValue, cSSNumericValue2);
            this.imageCache.put(uRI, officeImage3);
            return officeImage3;
        }
        catch (IOException iOException) {
            LOGGER.warning("Failed to load image from local input-repository: " + iOException);
        }
        catch (ReportExecutionException reportExecutionException) {
            LOGGER.warning("Failed to create image from local input-repository: " + reportExecutionException);
        }
        if (!bl) {
            OfficeImage officeImage4 = new OfficeImage(string, null, null);
            this.imageCache.put(uRI, officeImage4);
            return officeImage4;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copyToOutputRepository(String string, byte[] byArray) throws IOException, ReportExecutionException {
        String string2 = string == null ? this.imageService.getMimeType(byArray) : string;
        OutputRepository outputRepository = this.outputRepository.openOutputRepository("Pictures", null);
        DefaultNameGenerator defaultNameGenerator = new DefaultNameGenerator(outputRepository);
        String string3 = defaultNameGenerator.generateName("image", string2);
        OutputStream outputStream = outputRepository.createOutputStream(string3, string2);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            IOUtils.getInstance().copyStreams(byteArrayInputStream, outputStream);
        }
        finally {
            outputStream.close();
            outputRepository.closeOutputRepository();
        }
        return "Pictures/" + string3;
    }

    public static class OfficeImage {
        private final CSSNumericValue width;
        private final CSSNumericValue height;
        private final String embeddableLink;

        private OfficeImage(String string, CSSNumericValue cSSNumericValue, CSSNumericValue cSSNumericValue2) {
            this.embeddableLink = string;
            this.width = cSSNumericValue;
            this.height = cSSNumericValue2;
        }

        public CSSNumericValue getWidth() {
            return this.width;
        }

        public CSSNumericValue getHeight() {
            return this.height;
        }

        public String getEmbeddableLink() {
            return this.embeddableLink;
        }
    }

    private static class ByteDataImageKey {
        private final byte[] keyData;
        private Integer hashCode;

        protected ByteDataImageKey(byte[] byArray) {
            if (byArray == null) {
                throw new NullPointerException();
            }
            this.keyData = byArray;
        }

        public boolean equals(Object object) {
            if (this != object) {
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ByteDataImageKey byteDataImageKey = (ByteDataImageKey)object;
                if (!Arrays.equals(this.keyData, byteDataImageKey.keyData)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            if (this.hashCode != null) {
                return this.hashCode;
            }
            int n = Math.min(this.keyData.length, 512);
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                byte by = this.keyData[i];
                n2 = by + n2 * 23;
            }
            this.hashCode = n2;
            return n2;
        }
    }
}

