/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrVector4sFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;
    public static final int W;

    public XrVector4sFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrVector4sFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int16_t")
    public short x() {
        return XrVector4sFB.nx(this.address());
    }

    @NativeType(value="int16_t")
    public short y() {
        return XrVector4sFB.ny(this.address());
    }

    @NativeType(value="int16_t")
    public short z() {
        return XrVector4sFB.nz(this.address());
    }

    @NativeType(value="int16_t")
    public short w() {
        return XrVector4sFB.nw(this.address());
    }

    public XrVector4sFB x(@NativeType(value="int16_t") short value) {
        XrVector4sFB.nx(this.address(), value);
        return this;
    }

    public XrVector4sFB y(@NativeType(value="int16_t") short value) {
        XrVector4sFB.ny(this.address(), value);
        return this;
    }

    public XrVector4sFB z(@NativeType(value="int16_t") short value) {
        XrVector4sFB.nz(this.address(), value);
        return this;
    }

    public XrVector4sFB w(@NativeType(value="int16_t") short value) {
        XrVector4sFB.nw(this.address(), value);
        return this;
    }

    public XrVector4sFB set(short x, short y, short z, short w) {
        this.x(x);
        this.y(y);
        this.z(z);
        this.w(w);
        return this;
    }

    public XrVector4sFB set(XrVector4sFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrVector4sFB malloc() {
        return (XrVector4sFB)XrVector4sFB.wrap(XrVector4sFB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrVector4sFB calloc() {
        return (XrVector4sFB)XrVector4sFB.wrap(XrVector4sFB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrVector4sFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrVector4sFB)XrVector4sFB.wrap(XrVector4sFB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrVector4sFB create(long address) {
        return (XrVector4sFB)XrVector4sFB.wrap(XrVector4sFB.class, (long)address);
    }

    @Nullable
    public static XrVector4sFB createSafe(long address) {
        return address == 0L ? null : (XrVector4sFB)XrVector4sFB.wrap(XrVector4sFB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrVector4sFB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrVector4sFB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrVector4sFB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrVector4sFB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrVector4sFB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrVector4sFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrVector4sFB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrVector4sFB malloc(MemoryStack stack) {
        return (XrVector4sFB)XrVector4sFB.wrap(XrVector4sFB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrVector4sFB calloc(MemoryStack stack) {
        return (XrVector4sFB)XrVector4sFB.wrap(XrVector4sFB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrVector4sFB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrVector4sFB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static short nx(long struct) {
        return UNSAFE.getShort(null, struct + (long)X);
    }

    public static short ny(long struct) {
        return UNSAFE.getShort(null, struct + (long)Y);
    }

    public static short nz(long struct) {
        return UNSAFE.getShort(null, struct + (long)Z);
    }

    public static short nw(long struct) {
        return UNSAFE.getShort(null, struct + (long)W);
    }

    public static void nx(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)X, value);
    }

    public static void ny(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)Y, value);
    }

    public static void nz(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)Z, value);
    }

    public static void nw(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)W, value);
    }

    static {
        Struct.Layout layout = XrVector4sFB.__struct((Struct.Member[])new Struct.Member[]{XrVector4sFB.__member((int)2), XrVector4sFB.__member((int)2), XrVector4sFB.__member((int)2), XrVector4sFB.__member((int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
        W = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrVector4sFB, Buffer>
    implements NativeResource {
        private static final XrVector4sFB ELEMENT_FACTORY = XrVector4sFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrVector4sFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int16_t")
        public short x() {
            return XrVector4sFB.nx(this.address());
        }

        @NativeType(value="int16_t")
        public short y() {
            return XrVector4sFB.ny(this.address());
        }

        @NativeType(value="int16_t")
        public short z() {
            return XrVector4sFB.nz(this.address());
        }

        @NativeType(value="int16_t")
        public short w() {
            return XrVector4sFB.nw(this.address());
        }

        public Buffer x(@NativeType(value="int16_t") short value) {
            XrVector4sFB.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="int16_t") short value) {
            XrVector4sFB.ny(this.address(), value);
            return this;
        }

        public Buffer z(@NativeType(value="int16_t") short value) {
            XrVector4sFB.nz(this.address(), value);
            return this;
        }

        public Buffer w(@NativeType(value="int16_t") short value) {
            XrVector4sFB.nw(this.address(), value);
            return this;
        }
    }
}

