/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.jline;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.felix.gogo.runtime.Parser;
import org.apache.felix.gogo.runtime.Token;
import org.jline.reader.CompletingParsedLine;

public class ParsedLineImpl
implements CompletingParsedLine {
    private final Parser.Program program;
    private final String source;
    private final int cursor;
    private final List<String> tokens;
    private final int wordIndex;
    private final int wordCursor;
    private final CharSequence rawWord;
    private final int rawWordCursor;

    public ParsedLineImpl(Parser.Program program, Token line, int cursor, List<Token> tokens) {
        this.program = program;
        this.source = line.toString();
        this.cursor = cursor - line.start();
        this.tokens = new ArrayList<String>();
        for (Token token : tokens) {
            this.tokens.add(this.unquote(token, null).toString());
        }
        int wi = tokens.size();
        int wc = 0;
        if (cursor >= 0) {
            for (int i = 0; i < tokens.size(); ++i) {
                Token t = tokens.get(i);
                if (t.start() > cursor) {
                    wi = i;
                    wc = 0;
                    this.tokens.add(i, "");
                    break;
                }
                if (t.start() + t.length() < cursor) continue;
                wi = i;
                wc = cursor - t.start();
                break;
            }
        }
        if (wi == tokens.size()) {
            this.tokens.add("");
            this.rawWord = "";
            this.wordCursor = 0;
        } else {
            this.rawWord = tokens.get(wi);
            int[] c = new int[]{wc};
            this.unquote(this.rawWord, c);
            this.wordCursor = c[0];
        }
        this.wordIndex = wi;
        this.rawWordCursor = wc;
    }

    public String word() {
        return this.tokens.get(this.wordIndex());
    }

    public int wordCursor() {
        return this.wordCursor;
    }

    public int wordIndex() {
        return this.wordIndex;
    }

    public List<String> words() {
        return this.tokens;
    }

    public String line() {
        return this.source;
    }

    public int cursor() {
        return this.cursor;
    }

    public Parser.Program program() {
        return this.program;
    }

    public int rawWordCursor() {
        return this.rawWordCursor;
    }

    public int rawWordLength() {
        return this.rawWord.length();
    }

    public CharSequence escape(CharSequence str, boolean complete) {
        Predicate<Character> needToBeEscaped;
        char first;
        StringBuilder sb = new StringBuilder(str);
        char quote = '\u0000';
        char c = first = this.rawWord.length() > 0 ? this.rawWord.charAt(0) : (char)'\u0000';
        if (first == '\'') {
            quote = '\'';
            needToBeEscaped = i -> i.charValue() == '\'';
        } else if (first == '\"') {
            quote = '\"';
            needToBeEscaped = i -> i.charValue() == '\"';
        } else {
            needToBeEscaped = i -> i.charValue() == ' ' || i.charValue() == '\t';
        }
        for (int i2 = 0; i2 < sb.length(); ++i2) {
            if (!needToBeEscaped.test(Character.valueOf(str.charAt(i2)))) continue;
            sb.insert(i2++, '\\');
        }
        if (quote != '\u0000') {
            sb.insert(0, quote);
            if (complete) {
                sb.append(quote);
            }
        }
        return sb;
    }

    private CharSequence unquote(CharSequence arg, int[] cursor) {
        boolean hasEscape = false;
        for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            if (c != '\\' && c != '\"' && c != '\'') continue;
            hasEscape = true;
            break;
        }
        if (!hasEscape) {
            return arg;
        }
        boolean singleQuoted = false;
        boolean doubleQuoted = false;
        boolean escaped = false;
        StringBuilder buf = new StringBuilder(arg.length());
        for (int i = 0; i < arg.length(); ++i) {
            if (cursor != null && cursor[0] == i) {
                cursor[0] = buf.length();
                cursor = null;
            }
            char c = arg.charAt(i);
            if (doubleQuoted && escaped) {
                if (c != '\"' && c != '\\' && c != '$' && c != '%') {
                    buf.append('\\');
                }
                buf.append(c);
                escaped = false;
                continue;
            }
            if (escaped) {
                buf.append(c);
                escaped = false;
                continue;
            }
            if (singleQuoted) {
                if (c == '\'') {
                    singleQuoted = false;
                    continue;
                }
                buf.append(c);
                continue;
            }
            if (doubleQuoted) {
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                if (c == '\"') {
                    doubleQuoted = false;
                    continue;
                }
                buf.append(c);
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '\'') {
                singleQuoted = true;
                continue;
            }
            if (c == '\"') {
                doubleQuoted = true;
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }
}

