/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.mcpserver;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.action.mcpserver.McpAsyncServerHolder;
import org.opensearch.ml.action.mcpserver.McpToolsHelper;
import org.opensearch.ml.common.transport.mcpserver.requests.McpToolBaseInput;
import org.opensearch.ml.common.transport.mcpserver.requests.register.MLMcpToolsRegisterNodeRequest;
import org.opensearch.ml.common.transport.mcpserver.requests.register.MLMcpToolsRegisterNodesRequest;
import org.opensearch.ml.common.transport.mcpserver.requests.register.McpToolRegisterInput;
import org.opensearch.ml.common.transport.mcpserver.responses.register.MLMcpToolsRegisterNodeResponse;
import org.opensearch.ml.common.transport.mcpserver.responses.register.MLMcpToolsRegisterNodesResponse;
import org.opensearch.ml.rest.mcpserver.ToolFactoryWrapper;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TransportMcpToolsRegisterOnNodesAction
extends TransportNodesAction<MLMcpToolsRegisterNodesRequest, MLMcpToolsRegisterNodesResponse, MLMcpToolsRegisterNodeRequest, MLMcpToolsRegisterNodeResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportMcpToolsRegisterOnNodesAction.class);
    TransportService transportService;
    ClusterService clusterService;
    ThreadPool threadPool;
    Client client;
    NamedXContentRegistry xContentRegistry;
    ToolFactoryWrapper toolFactoryWrapper;
    McpToolsHelper mcpToolsHelper;

    @Inject
    public TransportMcpToolsRegisterOnNodesAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry, ToolFactoryWrapper toolFactoryWrapper, McpToolsHelper mcpToolsHelper) {
        super("cluster:admin/opensearch/ml/mcp_tools/register_on_nodes", threadPool, clusterService, transportService, actionFilters, MLMcpToolsRegisterNodesRequest::new, MLMcpToolsRegisterNodeRequest::new, "management", MLMcpToolsRegisterNodeResponse.class);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.toolFactoryWrapper = toolFactoryWrapper;
        this.mcpToolsHelper = mcpToolsHelper;
    }

    protected MLMcpToolsRegisterNodesResponse newResponse(MLMcpToolsRegisterNodesRequest nodesRequest, List<MLMcpToolsRegisterNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLMcpToolsRegisterNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLMcpToolsRegisterNodeRequest newNodeRequest(MLMcpToolsRegisterNodesRequest request) {
        return new MLMcpToolsRegisterNodeRequest(request.getMcpTools());
    }

    protected MLMcpToolsRegisterNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLMcpToolsRegisterNodeResponse(in);
    }

    protected MLMcpToolsRegisterNodeResponse nodeOperation(MLMcpToolsRegisterNodeRequest request) {
        return this.registerToolsOnNode(request.getMcpTools());
    }

    private MLMcpToolsRegisterNodeResponse registerToolsOnNode(List<McpToolRegisterInput> mcpTools) {
        AtomicReference exception = new AtomicReference();
        Flux.fromStream(mcpTools.stream()).flatMap(tool -> {
            if (!McpAsyncServerHolder.IN_MEMORY_MCP_TOOLS.containsKey(tool.getName())) {
                return McpAsyncServerHolder.getMcpAsyncServerInstance().addTool(this.mcpToolsHelper.createToolSpecification((McpToolBaseInput)tool)).doOnSuccess(x -> McpAsyncServerHolder.IN_MEMORY_MCP_TOOLS.put(tool.getName(), tool.getVersion()));
            }
            return Mono.empty();
        }).doOnError(e -> {
            log.error("Failed to register tool: {} in MCP server memory on node: {}", mcpTools.stream().map(McpToolBaseInput::getName).toList(), (Object)this.clusterService.localNode().getId());
            exception.set(e);
        }).doOnComplete(() -> log.debug("Successfully register tools on node: {}", (Object)this.clusterService.localNode().getId())).subscribe();
        if (exception.get() != null) {
            String errorMsg = ((Throwable)exception.get()).getMessage();
            throw new FailedNodeException(this.clusterService.localNode().getId(), errorMsg, (Throwable)new OpenSearchException(errorMsg, new Object[0]));
        }
        return new MLMcpToolsRegisterNodeResponse(this.clusterService.localNode(), Boolean.valueOf(true));
    }
}

