/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.env.Environment;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.neuralsearch.processor.util.ProcessorUtils;

public class ProcessorDocumentUtils {
    public static void validateMapTypeValue(String sourceKey, Map<String, Object> sourceValue, Object fieldMap, String indexName, ClusterService clusterService, Environment environment, boolean allowEmpty) {
        ProcessorDocumentUtils.validateMapTypeValue(sourceKey, sourceValue, fieldMap, 1L, indexName, clusterService, environment, allowEmpty);
    }

    private static void validateMapTypeValue(String sourceKey, Map<String, Object> sourceValue, Object fieldMap, long depth, String indexName, ClusterService clusterService, Environment environment, boolean allowEmpty) {
        if (Objects.isNull(sourceValue)) {
            return;
        }
        ProcessorDocumentUtils.validateDepth(sourceKey, depth, indexName, clusterService, environment);
        if (!(fieldMap instanceof Map)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] configuration doesn't match actual value type, configuration type is: %s, actual value type is: %s", sourceKey, fieldMap.getClass().getName(), sourceValue.getClass().getName()));
        }
        ((Map)fieldMap).forEach((key, nextFieldMap) -> {
            Object nextSourceValue = sourceValue.get(key);
            if (nextSourceValue != null) {
                if (nextSourceValue instanceof List) {
                    ProcessorDocumentUtils.validateListTypeValue(key, (List)nextSourceValue, fieldMap, depth + 1L, indexName, clusterService, environment, allowEmpty);
                } else if (nextSourceValue instanceof Map) {
                    ProcessorDocumentUtils.validateMapTypeValue(key, (Map)nextSourceValue, nextFieldMap, depth + 1L, indexName, clusterService, environment, allowEmpty);
                } else {
                    if (!(nextSourceValue instanceof String)) {
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "map type field [%s] is neither string nor nested type, cannot process it", key));
                    }
                    if (!allowEmpty && StringUtils.isBlank((CharSequence)((String)nextSourceValue))) {
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "map type field [%s] has empty string value, cannot process it", key));
                    }
                }
            }
        });
    }

    private static void validateListTypeValue(String sourceKey, List sourceValue, Object fieldMap, long depth, String indexName, ClusterService clusterService, Environment environment, boolean allowEmpty) {
        ProcessorDocumentUtils.validateDepth(sourceKey, depth, indexName, clusterService, environment);
        if (CollectionUtils.isEmpty((Collection)sourceValue)) {
            return;
        }
        for (Object element : sourceValue) {
            if (Objects.isNull(element)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "list type field [%s] has null, cannot process it", sourceKey));
            }
            if (element instanceof List) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "list type field [%s] is nested list type, cannot process it", sourceKey));
            }
            if (element instanceof Map) {
                ProcessorDocumentUtils.validateMapTypeValue(sourceKey, (Map)element, ((Map)fieldMap).get(sourceKey), depth + 1L, indexName, clusterService, environment, allowEmpty);
                continue;
            }
            if (!(element instanceof String)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "list type field [%s] has non string value, cannot process it", sourceKey));
            }
            if (allowEmpty || !StringUtils.isBlank((CharSequence)element.toString())) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "list type field [%s] has empty string, cannot process it", sourceKey));
        }
    }

    private static void validateDepth(String sourceKey, long depth, String indexName, ClusterService clusterService, Environment environment) {
        Settings settings = Optional.ofNullable(clusterService.state().metadata().index(indexName)).map(IndexMetadata::getSettings).orElse(environment.settings());
        long maxDepth = (Long)MapperService.INDEX_MAPPING_DEPTH_LIMIT_SETTING.get(settings);
        if (depth > maxDepth) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "map type field [%s] reaches max depth limit, cannot process it", sourceKey));
        }
    }

    public static Map<String, Object> unflattenJson(Map<String, Object> originalJsonMap) {
        if (originalJsonMap == null) {
            throw new IllegalArgumentException("originalJsonMap cannot be null");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Stack<ProcessJsonObjectItem> stack = new Stack<ProcessJsonObjectItem>();
        for (Map.Entry<String, Object> entry : originalJsonMap.entrySet()) {
            stack.push(new ProcessJsonObjectItem(entry.getKey(), entry.getValue(), result));
        }
        while (!stack.isEmpty()) {
            ProcessJsonObjectItem item = (ProcessJsonObjectItem)stack.pop();
            String key = item.key;
            Object value = item.value;
            Map<String, Object> currentMap = item.targetMap;
            if (value instanceof Map) {
                HashMap<String, Object> nestedMap = new HashMap<String, Object>();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    stack.push(new ProcessJsonObjectItem((String)entry.getKey(), entry.getValue(), nestedMap));
                }
                value = nestedMap;
            } else if (value instanceof List) {
                value = ProcessorDocumentUtils.handleList((List)value);
            }
            ProcessorDocumentUtils.unflattenSingleItem(key, value, currentMap);
        }
        return result;
    }

    public static Map<String, String> flattenAndFlip(Map<String, Object> map) {
        HashMap<String, String> flippedMap = new HashMap<String, String>();
        ProcessorDocumentUtils.flattenAndFlip("", map, flippedMap);
        return flippedMap;
    }

    private static void flattenAndFlip(String path, Map<String, Object> map, Map<String, String> flippedMap) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String currentKey;
            String key = entry.getKey();
            Object value = entry.getValue();
            String string = currentKey = path.isEmpty() ? key : path + "." + key;
            if (value instanceof Map) {
                ProcessorDocumentUtils.flattenAndFlip(currentKey, ProcessorUtils.unsafeCastToObjectMap(value), flippedMap);
                continue;
            }
            if (value instanceof String) {
                String traversedPath = currentKey.contains(".") ? currentKey.substring(0, currentKey.lastIndexOf(46)) : "";
                String currentValue = traversedPath.isEmpty() ? value.toString() : traversedPath + "." + String.valueOf(value);
                flippedMap.put(currentValue, currentKey);
                continue;
            }
            throw new IllegalStateException("Unexpected data structure at " + String.valueOf(value));
        }
    }

    public static void unflattenIngestDoc(IngestDocument document) {
        if (document == null || document.getSourceAndMetadata() == null) {
            return;
        }
        Map sourceAndMetadataMap = document.getSourceAndMetadata();
        Map<String, Object> unflattened = ProcessorDocumentUtils.unflattenJson(sourceAndMetadataMap);
        unflattened.forEach((arg_0, arg_1) -> ((IngestDocument)document).setFieldValue(arg_0, arg_1));
        sourceAndMetadataMap.keySet().removeIf(key -> key.contains("."));
    }

    private static List<Object> handleList(List<Object> list) {
        ArrayList<Object> result = new ArrayList<Object>();
        Stack<ProcessJsonListItem> stack = new Stack<ProcessJsonListItem>();
        for (int i = list.size() - 1; i >= 0; --i) {
            stack.push(new ProcessJsonListItem(list.get(i), result));
        }
        while (!stack.isEmpty()) {
            ProcessJsonListItem item = (ProcessJsonListItem)stack.pop();
            Object value = item.value;
            List<Object> targetList = item.targetList;
            if (value instanceof Map) {
                HashMap<String, Object> nestedMap = new HashMap<String, Object>();
                Map sourceMap = (Map)value;
                for (Map.Entry entry : sourceMap.entrySet()) {
                    stack.push(new ProcessJsonListItem(new ProcessJsonObjectItem((String)entry.getKey(), entry.getValue(), nestedMap), targetList));
                }
                targetList.add(nestedMap);
                continue;
            }
            if (value instanceof List) {
                ArrayList<Object> nestedList = new ArrayList<Object>();
                for (Object listItem : (List)value) {
                    stack.push(new ProcessJsonListItem(listItem, nestedList));
                }
                targetList.add(nestedList);
                continue;
            }
            if (value instanceof ProcessJsonObjectItem) {
                ProcessJsonObjectItem processJsonObjectItem = (ProcessJsonObjectItem)value;
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                ProcessorDocumentUtils.unflattenSingleItem(processJsonObjectItem.key, processJsonObjectItem.value, tempMap);
                processJsonObjectItem.targetMap.putAll(tempMap);
                continue;
            }
            targetList.add(value);
        }
        return result;
    }

    private static void unflattenSingleItem(String key, Object value, Map<String, Object> result) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new IllegalArgumentException("Field name cannot be null or empty");
        }
        if (key.contains(".")) {
            String[] parts = key.split("\\.", -1);
            Map current = result;
            for (int i = 0; i < parts.length; ++i) {
                if (StringUtils.isBlank((CharSequence)parts[i])) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Field name '%s' contains invalid dot usage", key));
                }
                if (i == parts.length - 1) {
                    current.put((String)parts[i], (Object)value);
                    continue;
                }
                current = (Map)current.computeIfAbsent((String)parts[i], k -> new HashMap());
            }
        } else {
            result.put((String)key, (Object)value);
        }
    }

    private static class ProcessJsonObjectItem {
        String key;
        Object value;
        Map<String, Object> targetMap;

        ProcessJsonObjectItem(String key, Object value, Map<String, Object> targetMap) {
            this.key = key;
            this.value = value;
            this.targetMap = targetMap;
        }
    }

    private static class ProcessJsonListItem {
        Object value;
        List<Object> targetList;

        ProcessJsonListItem(Object value, List<Object> targetList) {
            this.value = value;
            this.targetList = targetList;
        }
    }
}

