/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.feature.store;

import com.o19s.es.ltr.feature.FeatureSet;
import com.o19s.es.ltr.ranker.LtrRanker;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class FeatureSupplier
extends AbstractMap<String, Float>
implements Supplier<LtrRanker.FeatureVector> {
    private Supplier<LtrRanker.FeatureVector> vectorSupplier;
    private final FeatureSet featureSet;

    FeatureSupplier(FeatureSet featureSet) {
        this.featureSet = featureSet;
    }

    @Override
    public LtrRanker.FeatureVector get() {
        return this.vectorSupplier.get();
    }

    public void set(Supplier<LtrRanker.FeatureVector> supplier) {
        this.vectorSupplier = supplier;
    }

    @Override
    public boolean containsKey(Object featureName) {
        return this.featureSet.hasFeature((String)featureName);
    }

    @Override
    public Float get(Object featureName) {
        int featureOrdinal;
        try {
            featureOrdinal = this.featureSet.featureOrdinal((String)featureName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return Float.valueOf(this.vectorSupplier.get().getFeatureScore(featureOrdinal));
    }

    @Override
    public Set<Map.Entry<String, Float>> entrySet() {
        return new AbstractSet<Map.Entry<String, Float>>(){

            @Override
            public Iterator<Map.Entry<String, Float>> iterator() {
                return new Iterator<Map.Entry<String, Float>>(){
                    private int index;

                    @Override
                    public boolean hasNext() {
                        LtrRanker.FeatureVector featureVector = this.getFeatureVector();
                        if (featureVector != null) {
                            return this.index < FeatureSupplier.this.featureSet.size();
                        }
                        return false;
                    }

                    @Override
                    public Map.Entry<String, Float> next() {
                        LtrRanker.FeatureVector featureVector = this.getFeatureVector();
                        if (featureVector != null) {
                            float score = featureVector.getFeatureScore(this.index);
                            String featureName = FeatureSupplier.this.featureSet.feature(this.index).name();
                            ++this.index;
                            return new AbstractMap.SimpleImmutableEntry<String, Float>(featureName, Float.valueOf(score));
                        }
                        return null;
                    }
                };
            }

            @Override
            public int size() {
                LtrRanker.FeatureVector featureVector = this.getFeatureVector();
                if (featureVector != null) {
                    return FeatureSupplier.this.featureSet.size();
                }
                return 0;
            }

            private LtrRanker.FeatureVector getFeatureVector() {
                if (FeatureSupplier.this.vectorSupplier != null) {
                    return FeatureSupplier.this.vectorSupplier.get();
                }
                return null;
            }
        };
    }
}

