/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.ranker;

import com.o19s.es.ltr.ranker.LtrRanker;
import com.o19s.es.ltr.ranker.NullRanker;
import java.util.Map;

public class LogLtrRanker
implements LtrRanker {
    private final LogConsumer logger;
    private final NullRanker ranker;

    public LogLtrRanker(NullRanker ranker, LogConsumer consumer) {
        this.ranker = ranker;
        assert (this.ranker.getClass() == NullRanker.class);
        this.logger = consumer;
    }

    public LogLtrRanker(LogConsumer consumer, int modelSize) {
        this.ranker = new NullRanker(modelSize);
        this.logger = consumer;
    }

    @Override
    public String name() {
        return "log(" + this.ranker.name() + ")";
    }

    @Override
    public LtrRanker.FeatureVector newFeatureVector(LtrRanker.FeatureVector reuse) {
        VectorWrapper wrapper;
        if (reuse == null) {
            wrapper = new VectorWrapper(this.logger);
        } else {
            assert (reuse instanceof VectorWrapper);
            wrapper = (VectorWrapper)reuse;
        }
        wrapper.reset(this.ranker);
        return wrapper;
    }

    @Override
    public float score(LtrRanker.FeatureVector point) {
        assert (point instanceof VectorWrapper);
        return this.ranker.score(((VectorWrapper)point).inner);
    }

    public LogConsumer getLogConsumer() {
        return this.logger;
    }

    @FunctionalInterface
    public static interface LogConsumer {
        public void accept(int var1, float var2);

        default public Map<String, Object> getExtraLoggingMap() {
            return null;
        }

        default public void reset() {
        }
    }

    private static class VectorWrapper
    implements LtrRanker.FeatureVector {
        private LtrRanker.FeatureVector inner;
        private final LogConsumer logger;

        VectorWrapper(LogConsumer consumer) {
            this.logger = consumer;
        }

        @Override
        public void setFeatureScore(int featureId, float score) {
            this.inner.setFeatureScore(featureId, score);
            this.logger.accept(featureId, score);
        }

        @Override
        public float getFeatureScore(int featureId) {
            return this.inner.getFeatureScore(featureId);
        }

        void reset(LtrRanker ranker) {
            this.inner = ranker.newFeatureVector(this.inner);
            this.logger.reset();
        }

        @Override
        public float getDefaultScore() {
            return this.inner.getDefaultScore();
        }
    }
}

