/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth.http.jwt;

import com.nimbusds.jwt.proc.BadJWTException;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.security.WeakKeyException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.SpecialPermission;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.security.DefaultObjectMapper;
import org.opensearch.security.auth.HTTPAuthenticator;
import org.opensearch.security.filter.SecurityRequest;
import org.opensearch.security.filter.SecurityResponse;
import org.opensearch.security.user.AuthCredentials;
import org.opensearch.security.util.KeyUtils;

public class HTTPJwtAuthenticator
implements HTTPAuthenticator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    protected final DeprecationLogger deprecationLog = DeprecationLogger.getLogger(this.getClass());
    private static final Pattern BASIC = Pattern.compile("^\\s*Basic\\s.*", 2);
    private static final String BEARER = "bearer ";
    private final List<JwtParser> jwtParsers = new ArrayList<JwtParser>();
    private final String jwtHeaderName;
    private final boolean isDefaultAuthHeader;
    private final String jwtUrlParameter;
    private final List<String> rolesKey;
    private final List<String> subjectKey;
    private final List<String> requiredAudience;
    private final String requireIssuer;
    private final int clockSkewToleranceSeconds;

    public HTTPJwtAuthenticator(Settings settings, Path configPath) {
        List signingKeys = settings.getAsList("signing_key");
        this.jwtUrlParameter = settings.get("jwt_url_parameter");
        this.jwtHeaderName = settings.get("jwt_header", "Authorization");
        this.isDefaultAuthHeader = "Authorization".equalsIgnoreCase(this.jwtHeaderName);
        this.rolesKey = settings.getAsList("roles_key");
        this.subjectKey = settings.getAsList("subject_key");
        this.requiredAudience = settings.getAsList("required_audience");
        this.requireIssuer = settings.get("required_issuer");
        this.clockSkewToleranceSeconds = settings.getAsInt("jwt_clock_skew_tolerance_seconds", Integer.valueOf(30));
        if (!this.jwtHeaderName.equals("Authorization")) {
            this.deprecationLog.deprecate("jwt_header", "The 'jwt_header' setting will be removed in the next major version of OpenSearch.  Consult https://github.com/opensearch-project/security/issues/3886 for more details.", new Object[0]);
        }
        for (String key : signingKeys) {
            JwtParser jwtParser;
            JwtParserBuilder jwtParserBuilder = KeyUtils.createJwtParserBuilderFromSigningKey(key, this.log);
            if (jwtParserBuilder == null) {
                jwtParser = null;
            } else {
                if (this.requireIssuer != null) {
                    jwtParserBuilder.requireIssuer(this.requireIssuer);
                }
                jwtParserBuilder.clockSkewSeconds((long)this.clockSkewToleranceSeconds);
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission((Permission)new SpecialPermission());
                }
                jwtParser = AccessController.doPrivileged(() -> ((JwtParserBuilder)jwtParserBuilder).build());
            }
            this.jwtParsers.add(jwtParser);
        }
    }

    @Override
    public AuthCredentials extractCredentials(final SecurityRequest request, ThreadContext context) throws OpenSearchSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AuthCredentials creds = AccessController.doPrivileged(new PrivilegedAction<AuthCredentials>(){
            final /* synthetic */ HTTPJwtAuthenticator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public AuthCredentials run() {
                return this.this$0.extractCredentials0(request);
            }
        });
        return creds;
    }

    private AuthCredentials extractCredentials0(SecurityRequest request) {
        if (this.jwtParsers.isEmpty() || this.jwtParsers.getFirst() == null) {
            this.log.error("Missing Signing Key. JWT authentication will not work");
            return null;
        }
        String jwtToken = request.header(this.jwtHeaderName);
        if (this.isDefaultAuthHeader && jwtToken != null && BASIC.matcher(jwtToken).matches()) {
            jwtToken = null;
        }
        if ((jwtToken == null || jwtToken.isEmpty()) && this.jwtUrlParameter != null) {
            jwtToken = request.params().get(this.jwtUrlParameter);
        } else {
            request.params().get(this.jwtUrlParameter);
        }
        if (jwtToken == null || jwtToken.length() == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("No JWT token found in '{}' {} header", (Object)(this.jwtUrlParameter == null ? this.jwtHeaderName : this.jwtUrlParameter), (Object)(this.jwtUrlParameter == null ? "header" : "url parameter"));
            }
            return null;
        }
        int index = jwtToken.toLowerCase().indexOf(BEARER);
        if (index > -1) {
            jwtToken = jwtToken.substring(index + BEARER.length());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("No Bearer scheme found in header");
        }
        for (JwtParser jwtParser : this.jwtParsers) {
            try {
                String subject;
                Claims claims = (Claims)jwtParser.parseClaimsJws((CharSequence)jwtToken).getBody();
                if (!this.requiredAudience.isEmpty()) {
                    this.assertValidAudienceClaim(claims);
                }
                if ((subject = this.extractSubject(claims)) == null) {
                    this.log.error("No subject found in JWT token");
                    return null;
                }
                String[] roles = this.extractRoles(claims);
                AuthCredentials ac = new AuthCredentials(subject, roles).markComplete();
                for (Map.Entry claim : claims.entrySet()) {
                    String key = "attr.jwt." + (String)claim.getKey();
                    Object value = claim.getValue();
                    if (value instanceof Collection) {
                        try {
                            String jsonValue = DefaultObjectMapper.writeValueAsString(value, false);
                            ac.addAttribute(key, jsonValue);
                        }
                        catch (Exception e) {
                            this.log.warn("Failed to convert list claim to JSON for key: " + key, (Throwable)e);
                            ac.addAttribute(key, String.valueOf(value));
                        }
                        continue;
                    }
                    ac.addAttribute(key, String.valueOf(value));
                }
                return ac;
            }
            catch (WeakKeyException e) {
                this.log.error("Cannot authenticate user with JWT because of ", (Throwable)e);
                return null;
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Invalid or expired JWT token.", (Throwable)e);
            }
        }
        this.log.debug("Unable to authenticate JWT Token with any configured signing key");
        return null;
    }

    private void assertValidAudienceClaim(Claims claims) throws BadJWTException {
        if (this.requiredAudience.isEmpty()) {
            return;
        }
        if (Collections.disjoint(claims.getAudience(), this.requiredAudience)) {
            throw new BadJWTException("Claim of 'aud' doesn't contain any required audience.");
        }
    }

    @Override
    public Optional<SecurityResponse> reRequestAuthentication(SecurityRequest channel, AuthCredentials creds) {
        return Optional.of(new SecurityResponse(401, Map.of("WWW-Authenticate", "Bearer realm=\"OpenSearch Security\""), ""));
    }

    @Override
    public Set<String> getSensitiveUrlParams() {
        if (this.jwtUrlParameter != null) {
            return Set.of(this.jwtUrlParameter);
        }
        return Collections.emptySet();
    }

    @Override
    public String getType() {
        return "jwt";
    }

    protected String extractSubject(Claims claims) {
        String subject = claims.getSubject();
        if (this.subjectKey != null && !this.subjectKey.isEmpty()) {
            Object node = claims;
            for (String key : this.subjectKey) {
                if (!(node instanceof Map)) {
                    this.log.warn("While following subject_key path {}, expected a JSON object before '{}', but found '{}' ({}).", this.subjectKey, (Object)key, node, node.getClass());
                    return null;
                }
                Map map = (Map)node;
                node = map.get(key);
                if (node != null) continue;
                this.log.warn("Failed to find '{}' in JWT claims while following subject_key path {}.", (Object)key, this.subjectKey);
                return null;
            }
            if (node instanceof String) {
                String str = (String)node;
                return str.trim();
            }
            this.log.warn("Expected a String at the end of subject_key path {}, but found '{}' ({}). Converting to String.", this.subjectKey, node, node.getClass());
            return String.valueOf(node).trim();
        }
        return subject;
    }

    protected String[] extractRoles(Claims claims) {
        if (this.rolesKey == null || this.rolesKey.isEmpty()) {
            return new String[0];
        }
        Object node = claims;
        for (String key : this.rolesKey) {
            if (!(node instanceof Map)) {
                this.log.warn("While following roles_key path {}, expected a JSON object before '{}', but found '{}' ({}).", this.rolesKey, (Object)key, node, node.getClass());
                return new String[0];
            }
            Map map = (Map)node;
            node = map.get(key);
            if (node != null) continue;
            this.log.warn("Failed to find '{}' in JWT claims while following roles_key path {}.", (Object)key, this.rolesKey);
            return new String[0];
        }
        LinkedHashSet<String> collected = new LinkedHashSet<String>();
        if (node instanceof String) {
            String str = (String)node;
            Arrays.stream(str.split(",")).map(String::trim).filter(Predicate.not(String::isEmpty)).forEach(collected::add);
        } else if (node instanceof Collection) {
            Collection col = (Collection)node;
            col.stream().filter(Objects::nonNull).map(Object::toString).map(String::trim).filter(Predicate.not(String::isEmpty)).forEach(collected::add);
        } else {
            this.log.warn("Expected a String or Collection at the end of roles_key path {}, but found '{}' ({}). Converting to String.", this.rolesKey, node, node.getClass());
            collected.add(node.toString().trim());
        }
        return collected.toArray(new String[0]);
    }
}

