/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.securityanalytics.action.AckAlertsRequest;

public class AckCorrelationAlertsRequest
extends ActionRequest {
    private final List<String> correlationAlertIds;

    public AckCorrelationAlertsRequest(List<String> correlationAlertIds) {
        this.correlationAlertIds = correlationAlertIds;
    }

    public AckCorrelationAlertsRequest(StreamInput in) throws IOException {
        this.correlationAlertIds = Collections.unmodifiableList(in.readStringList());
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.correlationAlertIds == null || this.correlationAlertIds.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"alert ids list cannot be empty", validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.correlationAlertIds);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("correlation_alert_ids", this.correlationAlertIds).endObject();
    }

    public static AckAlertsRequest readFrom(StreamInput sin) throws IOException {
        return new AckAlertsRequest(sin);
    }

    public List<String> getCorrelationAlertIds() {
        return this.correlationAlertIds;
    }
}

