/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.get.GetIndexRequest;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.securityanalytics.action.GetIndexMappingsResponse;
import org.opensearch.securityanalytics.action.GetMappingsViewResponse;
import org.opensearch.securityanalytics.logtype.LogTypeService;
import org.opensearch.securityanalytics.mapper.IndexTemplateManager;
import org.opensearch.securityanalytics.mapper.MapperUtils;
import org.opensearch.securityanalytics.mapper.MappingsTraverser;
import org.opensearch.securityanalytics.model.CreateMappingResult;
import org.opensearch.securityanalytics.model.LogType;
import org.opensearch.securityanalytics.util.IndexUtils;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.IndicesAdminClient;

public class MapperService {
    private static final Logger log = LogManager.getLogger(MapperService.class);
    private ClusterService clusterService;
    private IndicesAdminClient indicesClient;
    private IndexNameExpressionResolver indexNameExpressionResolver;
    private IndexTemplateManager indexTemplateManager;
    private LogTypeService logTypeService;

    public MapperService() {
    }

    public MapperService(Client client, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, IndexTemplateManager indexTemplateManager, LogTypeService logTypeService) {
        this.indicesClient = client.admin().indices();
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.indexTemplateManager = indexTemplateManager;
        this.logTypeService = logTypeService;
    }

    public void createMappingAction(String indexName, String logType, boolean partial, ActionListener<AcknowledgedResponse> actionListener) {
        this.createMappingAction(indexName, logType, null, partial, actionListener);
    }

    public void createMappingAction(final String indexName, final String logType, final String aliasMappings, final boolean partial, final ActionListener<AcknowledgedResponse> actionListener) {
        boolean shouldUpsertIndexTemplate;
        String index = indexName;
        boolean bl = shouldUpsertIndexTemplate = !IndexUtils.isConcreteIndex(indexName, this.clusterService.state());
        if (IndexUtils.isDataStream(indexName, this.clusterService.state()) || IndexUtils.isAlias(indexName, this.clusterService.state())) {
            log.debug("{} is an alias or datastream. Fetching write index for create mapping action.", (Object)indexName);
            String writeIndex = IndexUtils.getWriteIndex(indexName, this.clusterService.state());
            if (writeIndex != null) {
                log.debug("Write index for {} is {}", (Object)indexName, (Object)writeIndex);
                index = writeIndex;
            }
        }
        GetMappingsRequest getMappingsRequest = (GetMappingsRequest)new GetMappingsRequest().indices(new String[]{index});
        this.indicesClient.getMappings(getMappingsRequest, (ActionListener)new ActionListener<GetMappingsResponse>(this){
            final /* synthetic */ MapperService this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(GetMappingsResponse getMappingsResponse) {
                this.this$0.applyAliasMappings(getMappingsResponse.getMappings(), logType, aliasMappings, partial, new ActionListener<Collection<CreateMappingResult>>(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void onResponse(Collection<CreateMappingResult> createMappingResponse) {
                        log.debug("Completed create mappings for {}", (Object)indexName);
                        Optional<AcknowledgedResponse> notAckd = createMappingResponse.stream().map(e -> e.getAcknowledgedResponse()).filter(e -> !e.isAcknowledged()).findFirst();
                        AcknowledgedResponse ack = new AcknowledgedResponse(!notAckd.isPresent());
                        if (shouldUpsertIndexTemplate) {
                            this.this$1.this$0.indexTemplateManager.upsertIndexTemplateWithAliasMappings(indexName, createMappingResponse, (ActionListener<AcknowledgedResponse>)actionListener);
                        } else {
                            actionListener.onResponse((Object)ack);
                        }
                    }

                    public void onFailure(Exception e) {
                        log.debug("Failed to create mappings for {}", (Object)indexName);
                        actionListener.onFailure(e);
                    }
                });
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        });
    }

    private void applyAliasMappings(Map<String, MappingMetadata> indexMappings, String logType, String aliasMappings, boolean partial, final ActionListener<Collection<CreateMappingResult>> actionListener) {
        int numOfIndices = indexMappings.size();
        GroupedActionListener doCreateMappingActionsListener = new GroupedActionListener((ActionListener)new ActionListener<Collection<CreateMappingResult>>(){

            public void onResponse(Collection<CreateMappingResult> response) {
                actionListener.onResponse(response);
            }

            public void onFailure(Exception e) {
                actionListener.onFailure((Exception)((Object)new SecurityAnalyticsException("Failed applying mappings to index", RestStatus.INTERNAL_SERVER_ERROR, e)));
            }
        }, numOfIndices);
        indexMappings.forEach((k, v) -> {
            String indexName = k;
            MappingMetadata mappingMetadata = v;
            this.doCreateMapping(indexName, mappingMetadata, logType, aliasMappings, partial, (ActionListener<CreateMappingResult>)doCreateMappingActionsListener);
        });
    }

    private void doCreateMapping(final String indexName, final MappingMetadata mappingMetadata, String logType, String aliasMappings, final boolean partial, final ActionListener<CreateMappingResult> actionListener) {
        try {
            if (aliasMappings != null) {
                Pair<List<String>, List<String>> validationResult = MapperUtils.validateIndexMappings(indexName, mappingMetadata, aliasMappings);
                List missingPathsInIndex = (List)validationResult.getLeft();
                List presentPathsInIndex = (List)validationResult.getRight();
                if (missingPathsInIndex.size() > 0 && !partial) {
                    actionListener.onFailure((Exception)new IllegalArgumentException("Not all paths were found in index mappings: " + missingPathsInIndex.stream().collect(Collectors.joining(", ", "[", "]"))));
                }
                Map<String, Object> presentPathsMappings = MapperUtils.getFieldMappingsFlat(mappingMetadata, presentPathsInIndex);
                Map<String, Object> filteredAliasMappings = this.filterNonApplicableAliases(mappingMetadata, missingPathsInIndex, aliasMappings);
                HashMap<String, Object> allMappings = new HashMap<String, Object>(presentPathsMappings);
                allMappings.putAll((Map)filteredAliasMappings.get("properties"));
                final HashMap<String, HashMap<String, Object>> mappingsRoot = new HashMap<String, HashMap<String, Object>>();
                mappingsRoot.put("properties", allMappings);
                PutMappingRequest request = new PutMappingRequest(new String[]{indexName}).source(filteredAliasMappings);
                this.indicesClient.putMapping(request, (ActionListener)new ActionListener<AcknowledgedResponse>(this){

                    public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                        CreateMappingResult result = new CreateMappingResult(acknowledgedResponse, indexName, mappingsRoot);
                        actionListener.onResponse((Object)result);
                    }

                    public void onFailure(Exception e) {
                        actionListener.onFailure(e);
                    }
                });
            } else {
                this.logTypeService.getRuleFieldMappingsAllSchemas(logType, new ActionListener<List<LogType.Mapping>>(this){
                    final /* synthetic */ MapperService this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void onResponse(List<LogType.Mapping> mappings) {
                        try {
                            List<String> indexFields = MapperUtils.extractAllFieldsFlat(mappingMetadata);
                            HashMap<String, Map<String, String>> aliasMappingFields = new HashMap<String, Map<String, String>>();
                            XContentBuilder aliasMappingsObj = XContentFactory.jsonBuilder().startObject();
                            for (LogType.Mapping mapping : mappings) {
                                if (indexFields.contains(mapping.getRawField())) {
                                    aliasMappingFields.put(mapping.getEcs(), Map.of("type", "alias", "path", mapping.getRawField()));
                                    continue;
                                }
                                if (indexFields.contains(mapping.getOcsf11())) {
                                    aliasMappingFields.put(mapping.getEcs(), Map.of("type", "alias", "path", mapping.getOcsf11()));
                                    continue;
                                }
                                if (!indexFields.contains(mapping.getOcsf())) continue;
                                aliasMappingFields.put(mapping.getEcs(), Map.of("type", "alias", "path", mapping.getOcsf()));
                            }
                            aliasMappingsObj.field("properties", aliasMappingFields);
                            String aliasMappings = aliasMappingsObj.endObject().toString();
                            Pair<List<String>, List<String>> validationResult = MapperUtils.validateIndexMappings(indexName, mappingMetadata, aliasMappings);
                            List missingPathsInIndex = (List)validationResult.getLeft();
                            List presentPathsInIndex = (List)validationResult.getRight();
                            if (missingPathsInIndex.size() > 0 && !partial) {
                                actionListener.onFailure((Exception)new IllegalArgumentException("Not all paths were found in index mappings: " + missingPathsInIndex.stream().collect(Collectors.joining(", ", "[", "]"))));
                            }
                            Map<String, Object> presentPathsMappings = MapperUtils.getFieldMappingsFlat(mappingMetadata, presentPathsInIndex);
                            Map<String, Object> filteredAliasMappings = this.this$0.filterNonApplicableAliases(mappingMetadata, missingPathsInIndex, aliasMappings);
                            HashMap<String, Object> allMappings = new HashMap<String, Object>(presentPathsMappings);
                            allMappings.putAll((Map)filteredAliasMappings.get("properties"));
                            final HashMap<String, HashMap<String, Object>> mappingsRoot = new HashMap<String, HashMap<String, Object>>();
                            mappingsRoot.put("properties", allMappings);
                            PutMappingRequest request = new PutMappingRequest(new String[]{indexName}).source(filteredAliasMappings);
                            this.this$0.indicesClient.putMapping(request, (ActionListener)new ActionListener<AcknowledgedResponse>(this){

                                public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                                    CreateMappingResult result = new CreateMappingResult(acknowledgedResponse, indexName, mappingsRoot);
                                    actionListener.onResponse((Object)result);
                                }

                                public void onFailure(Exception e) {
                                    actionListener.onFailure(e);
                                }
                            });
                        }
                        catch (IOException ex) {
                            actionListener.onFailure((Exception)ex);
                        }
                    }

                    public void onFailure(Exception e) {
                        actionListener.onFailure(e);
                    }
                });
            }
        }
        catch (IOException | IllegalArgumentException e) {
            actionListener.onFailure(e);
        }
    }

    private Map<String, Object> filterNonApplicableAliases(MappingMetadata indexMappingMetadata, List<String> missingPathsInIndex, String aliasMappingsJSON) throws IOException {
        boolean excludeSomeAliases;
        MappingsTraverser mappingsTraverser = new MappingsTraverser(aliasMappingsJSON, Set.of());
        Map<String, Object> filteredAliasMappings = mappingsTraverser.traverseAndCopyAsFlat();
        ArrayList<Pair<String, String>> propertiesToSkip = new ArrayList<Pair<String, String>>();
        if (missingPathsInIndex.size() > 0) {
            propertiesToSkip.addAll(missingPathsInIndex.stream().map(e -> Pair.of((Object)"path", (Object)e)).collect(Collectors.toList()));
        }
        List<String> nonAliasIndexFields = MapperUtils.getAllNonAliasFieldsFromIndex(indexMappingMetadata);
        List<String> aliasFields = MapperUtils.getAllAliases(aliasMappingsJSON);
        Set<String> aliasesToInclude = aliasFields.stream().filter(e -> !nonAliasIndexFields.contains(e)).collect(Collectors.toSet());
        boolean bl = excludeSomeAliases = aliasesToInclude.size() < aliasFields.size();
        if (propertiesToSkip.size() > 0 || excludeSomeAliases) {
            mappingsTraverser = new MappingsTraverser(aliasMappingsJSON, propertiesToSkip);
            filteredAliasMappings = aliasesToInclude.size() > 0 ? mappingsTraverser.traverseAndCopyWithFilter(aliasesToInclude) : mappingsTraverser.traverseAndCopyAsFlat();
        }
        return filteredAliasMappings;
    }

    public void updateMappingAction(String indexName, String field, String alias, final ActionListener<AcknowledgedResponse> actionListener) {
        PutMappingRequest request = new PutMappingRequest(new String[]{indexName}).source(new String[]{field, alias});
        this.indicesClient.putMapping(request, (ActionListener)new ActionListener<AcknowledgedResponse>(this){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                actionListener.onResponse((Object)acknowledgedResponse);
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        });
    }

    public void getMappingAction(final String indexName, final ActionListener<GetIndexMappingsResponse> actionListener) {
        try {
            this.resolveConcreteIndex(indexName, new ActionListener<String>(this){
                final /* synthetic */ MapperService this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(String concreteIndex) {
                    this.this$0.doGetMappingAction(indexName, concreteIndex, (ActionListener<GetIndexMappingsResponse>)actionListener);
                }

                public void onFailure(Exception e) {
                    actionListener.onFailure(e);
                }
            });
        }
        catch (IOException e) {
            throw SecurityAnalyticsException.wrap(e);
        }
    }

    public void doGetMappingAction(final String indexName, String concreteIndexName, final ActionListener<GetIndexMappingsResponse> actionListener) {
        GetMappingsRequest getMappingsRequest = (GetMappingsRequest)new GetMappingsRequest().indices(new String[]{concreteIndexName});
        this.indicesClient.getMappings(getMappingsRequest, (ActionListener)new ActionListener<GetMappingsResponse>(this){
            final /* synthetic */ MapperService this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(GetMappingsResponse getMappingsResponse) {
                this.this$0.logTypeService.getRequiredFieldsForAllLogTypes((ActionListener<Map<String, Set<String>>>)ActionListener.wrap(requiredFieldMap -> {
                    try {
                        MappingMetadata mappingMetadata = (MappingMetadata)getMappingsResponse.mappings().entrySet().iterator().next().getValue();
                        HashSet<String> appliedAliases = new HashSet<String>();
                        List<Pair<String, String>> indexAliasPathPairs = MapperUtils.getAllAliasPathPairs(mappingMetadata);
                        for (String logType : requiredFieldMap.keySet()) {
                            Set requiredFields = (Set)requiredFieldMap.get(logType);
                            for (Pair<String, String> p1 : indexAliasPathPairs) {
                                if (!requiredFields.contains(p1.getKey())) continue;
                                appliedAliases.add((String)p1.getKey());
                            }
                        }
                        MappingsTraverser mappingsTraverser = new MappingsTraverser(mappingMetadata);
                        Map<String, Object> filteredMapping = mappingsTraverser.traverseAndCopyWithFilter(appliedAliases);
                        HashMap<String, MappingMetadata> outIndexMappings = new HashMap<String, MappingMetadata>();
                        Map<String, Map<String, Object>> root = Map.of("_doc", filteredMapping);
                        MappingMetadata outMappingMetadata = new MappingMetadata("_doc", root);
                        outIndexMappings.put(indexName, outMappingMetadata);
                        actionListener.onResponse((Object)new GetIndexMappingsResponse(outIndexMappings));
                    }
                    catch (IOException e) {
                        actionListener.onFailure((Exception)e);
                    }
                }, arg_0 -> ((ActionListener)actionListener).onFailure(arg_0)));
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        });
    }

    public void getMappingsViewAction(String indexName, final String logType, final ActionListener<GetMappingsViewResponse> actionListener) {
        try {
            this.resolveConcreteIndex(indexName, new ActionListener<String>(this){
                final /* synthetic */ MapperService this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(String concreteIndex) {
                    this.this$0.doGetMappingsView(logType, (ActionListener<GetMappingsViewResponse>)actionListener, concreteIndex);
                }

                public void onFailure(Exception e) {
                    actionListener.onFailure(e);
                }
            });
        }
        catch (IOException e) {
            throw SecurityAnalyticsException.wrap(e);
        }
    }

    private void doGetMappingsView(final String logType, final ActionListener<GetMappingsViewResponse> actionListener, String concreteIndex) {
        GetMappingsRequest getMappingsRequest = (GetMappingsRequest)new GetMappingsRequest().indices(new String[]{concreteIndex});
        this.indicesClient.getMappings(getMappingsRequest, (ActionListener)new ActionListener<GetMappingsResponse>(this){
            final /* synthetic */ MapperService this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(GetMappingsResponse getMappingsResponse) {
                this.this$0.logTypeService.getRequiredFields(logType, (ActionListener<List<LogType.Mapping>>)ActionListener.wrap(requiredFields -> {
                    try {
                        MappingMetadata mappingMetadata = (MappingMetadata)getMappingsResponse.mappings().entrySet().iterator().next().getValue();
                        List<String> allFieldsFromIndex = MapperUtils.getAllNonAliasFieldsFromIndex(mappingMetadata);
                        ArrayList<String> applyableAliases = new ArrayList<String>();
                        ArrayList<String> pathsOfApplyableAliases = new ArrayList<String>();
                        ArrayList<String> unmappedFieldAliases = new ArrayList<String>();
                        for (LogType.Mapping requiredField : requiredFields) {
                            String alias = requiredField.getEcs();
                            String rawPath = requiredField.getRawField();
                            String ocsfPath = requiredField.getOcsf();
                            String ocsf11Path = requiredField.getOcsf11();
                            if (allFieldsFromIndex.contains(rawPath)) {
                                if (applyableAliases.contains(alias) || applyableAliases.contains(rawPath)) continue;
                                if (alias != null) {
                                    applyableAliases.add(alias);
                                } else {
                                    applyableAliases.add(rawPath);
                                }
                                pathsOfApplyableAliases.add(rawPath);
                                continue;
                            }
                            if (allFieldsFromIndex.contains(ocsf11Path)) {
                                applyableAliases.add(alias);
                                pathsOfApplyableAliases.add(ocsf11Path);
                                continue;
                            }
                            if (allFieldsFromIndex.contains(ocsfPath)) {
                                applyableAliases.add(alias);
                                pathsOfApplyableAliases.add(ocsfPath);
                                continue;
                            }
                            if ((alias != null || allFieldsFromIndex.contains(rawPath)) && allFieldsFromIndex.contains(alias)) continue;
                            if (alias != null) {
                                unmappedFieldAliases.add(alias);
                                continue;
                            }
                            unmappedFieldAliases.add(rawPath);
                        }
                        HashSet setOfUnmappedFieldAliases = new HashSet(unmappedFieldAliases);
                        List<String> filteredUnmappedFieldAliases = setOfUnmappedFieldAliases.stream().filter(e -> false == applyableAliases.contains(e)).collect(Collectors.toList());
                        HashMap<String, Map<String, String>> aliasMappingFields = new HashMap<String, Map<String, String>>();
                        XContentBuilder aliasMappingsObj = XContentFactory.jsonBuilder().startObject();
                        for (LogType.Mapping mapping : requiredFields) {
                            if (allFieldsFromIndex.contains(mapping.getOcsf11())) {
                                aliasMappingFields.put(mapping.getEcs(), Map.of("type", "alias", "path", mapping.getOcsf11()));
                                continue;
                            }
                            if (allFieldsFromIndex.contains(mapping.getOcsf())) {
                                aliasMappingFields.put(mapping.getEcs(), Map.of("type", "alias", "path", mapping.getOcsf()));
                                continue;
                            }
                            if (mapping.getEcs() != null) {
                                MapperService.shouldUpdateEcsMappingAndMaybeUpdates(mapping, aliasMappingFields, pathsOfApplyableAliases);
                                continue;
                            }
                            if (mapping.getEcs() != null) continue;
                            aliasMappingFields.put(mapping.getRawField(), Map.of("type", "alias", "path", mapping.getRawField()));
                        }
                        aliasMappingsObj.field("properties", aliasMappingFields);
                        String aliasMappingsJson = aliasMappingsObj.endObject().toString();
                        Map<String, Object> aliasMappings = MapperUtils.getAliasMappingsWithFilter(aliasMappingsJson, applyableAliases);
                        List<String> unmappedIndexFields = allFieldsFromIndex.stream().filter(e -> !pathsOfApplyableAliases.contains(e)).collect(Collectors.toList());
                        actionListener.onResponse((Object)new GetMappingsViewResponse(aliasMappings, unmappedIndexFields, filteredUnmappedFieldAliases, this.this$0.logTypeService.getIocFieldsList(logType)));
                    }
                    catch (Exception e2) {
                        actionListener.onFailure(e2);
                    }
                }, arg_0 -> ((ActionListener)actionListener).onFailure(arg_0)));
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        });
    }

    private static void shouldUpdateEcsMappingAndMaybeUpdates(LogType.Mapping mapping, Map<String, Map<String, String>> aliasMappingFields, List<String> pathsOfApplyableAliases) {
        if (aliasMappingFields.containsKey(mapping.getEcs())) {
            if (pathsOfApplyableAliases.contains(mapping.getRawField())) {
                aliasMappingFields.put(mapping.getEcs(), Map.of("type", "alias", "path", mapping.getRawField()));
            }
        } else {
            aliasMappingFields.put(mapping.getEcs(), Map.of("type", "alias", "path", mapping.getRawField()));
        }
    }

    private void resolveConcreteIndex(final String indexName, final ActionListener<String> actionListener) throws IOException {
        this.indicesClient.getIndex((GetIndexRequest)new GetIndexRequest().indices(new String[]{indexName}), (ActionListener)new ActionListener<GetIndexResponse>(this){
            final /* synthetic */ MapperService this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(GetIndexResponse getIndexResponse) {
                String[] indices = getIndexResponse.indices();
                if (indices.length == 0) {
                    actionListener.onFailure((Exception)SecurityAnalyticsException.wrap(new IllegalArgumentException("Invalid index name: [" + indexName + "]")));
                } else if (indices.length == 1) {
                    actionListener.onResponse((Object)indices[0]);
                } else if (indices.length > 1) {
                    String writeIndex = IndexUtils.getWriteIndex(indexName, this.this$0.clusterService.state());
                    if (writeIndex != null) {
                        actionListener.onResponse((Object)writeIndex);
                    } else {
                        actionListener.onResponse((Object)IndexUtils.getNewestIndexByCreationDate(indices, this.this$0.clusterService.state()));
                    }
                }
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        });
    }

    void setIndicesAdminClient(IndicesAdminClient client) {
        this.indicesClient = client;
    }

    void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public void setIndexNameExpressionResolver(IndexNameExpressionResolver indexNameExpressionResolver) {
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    public void setIndexTemplateManager(IndexTemplateManager indexTemplateManager) {
        this.indexTemplateManager = indexTemplateManager;
    }
}

