/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.UUIDs;
import org.opensearch.commons.alerting.model.action.Action;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.model.DetectorTrigger;

public class CorrelationRuleTrigger
implements Writeable,
ToXContentObject {
    private static final Logger log = LogManager.getLogger(DetectorTrigger.class);
    private String id;
    private String name;
    private String severity;
    private List<Action> actions;
    private static final String ID_FIELD = "id";
    private static final String SEVERITY_FIELD = "severity";
    private static final String ACTIONS_FIELD = "actions";
    private static final String NAME_FIELD = "name";
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(CorrelationRuleTrigger.class, new ParseField("id", new String[0]), CorrelationRuleTrigger::parse);

    public CorrelationRuleTrigger(String id, String name, String severity, List<Action> actions) {
        this.id = id == null ? UUIDs.base64UUID() : id;
        this.name = name;
        this.severity = severity;
        this.actions = actions;
    }

    public CorrelationRuleTrigger(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readString(), sin.readString(), sin.readList(Action::readFrom));
    }

    public Map<String, Object> asTemplateArg() {
        return Map.of(ACTIONS_FIELD, this.actions.stream().map(Action::asTemplateArg));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.name);
        out.writeString(this.severity);
        out.writeCollection(this.actions);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Action[] actionArray = new Action[]{};
        actionArray = this.actions.toArray(actionArray);
        return builder.startObject().field(ID_FIELD, this.id).field(NAME_FIELD, this.name).field(SEVERITY_FIELD, this.severity).field(ACTIONS_FIELD, (Object)actionArray).endObject();
    }

    public static CorrelationRuleTrigger parse(XContentParser xcp) throws IOException {
        String id = null;
        String name = null;
        String severity = null;
        ArrayList<Action> actions = new ArrayList<Action>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block12: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "id": {
                    id = xcp.text();
                    continue block12;
                }
                case "name": {
                    name = xcp.text();
                    continue block12;
                }
                case "severity": {
                    severity = xcp.text();
                    continue block12;
                }
                case "actions": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        Action action = Action.parse((XContentParser)xcp);
                        actions.add(action);
                    }
                    continue block12;
                }
            }
            xcp.skipChildren();
        }
        return new CorrelationRuleTrigger(id, name, severity, actions);
    }

    public static CorrelationRuleTrigger readFrom(StreamInput sin) throws IOException {
        return new CorrelationRuleTrigger(sin);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorrelationRuleTrigger that = (CorrelationRuleTrigger)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.severity, that.severity) && Objects.equals(this.actions, that.actions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.severity, this.actions);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSeverity() {
        return this.severity;
    }

    public List<Action> getActions() {
        return this.actions;
    }
}

