/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.securityanalytics.action.IndexCustomLogTypeAction;
import org.opensearch.securityanalytics.action.IndexCustomLogTypeRequest;
import org.opensearch.securityanalytics.action.IndexCustomLogTypeResponse;
import org.opensearch.securityanalytics.model.CustomLogType;
import org.opensearch.transport.client.node.NodeClient;

public class RestIndexCustomLogTypeAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestIndexCustomLogTypeAction.class);

    public String getName() {
        return "index_custom_log_type_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_security_analytics/logtype"), new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.getDefault(), "%s/{%s}", "/_plugins/_security_analytics/logtype", "custom_logtype_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        log.debug(String.format(Locale.getDefault(), "%s %s", request.method(), "/_plugins/_security_analytics/logtype"));
        WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;
        if (request.hasParam("refresh")) {
            refreshPolicy = WriteRequest.RefreshPolicy.parse((String)request.param("refresh"));
        }
        String id = request.param("custom_logtype_id", "");
        XContentParser xcp = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        CustomLogType logType = CustomLogType.parse(xcp, id, null);
        IndexCustomLogTypeRequest customLogTypeRequest = new IndexCustomLogTypeRequest(id, refreshPolicy, request.method(), logType);
        return channel -> client.execute((ActionType)IndexCustomLogTypeAction.INSTANCE, (ActionRequest)customLogTypeRequest, this.indexCustomLogTypeResponse((RestChannel)channel, request.method()));
    }

    private RestResponseListener<IndexCustomLogTypeResponse> indexCustomLogTypeResponse(RestChannel channel, final RestRequest.Method restMethod) {
        return new RestResponseListener<IndexCustomLogTypeResponse>(this, channel){

            public RestResponse buildResponse(IndexCustomLogTypeResponse response) throws Exception {
                RestStatus returnStatus = RestStatus.CREATED;
                if (restMethod == RestRequest.Method.PUT) {
                    returnStatus = RestStatus.OK;
                }
                BytesRestResponse restResponse = new BytesRestResponse(returnStatus, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
                if (restMethod == RestRequest.Method.POST) {
                    String location = String.format(Locale.getDefault(), "%s/%s", "/_plugins/_security_analytics/logtype", response.getId());
                    restResponse.addHeader("Location", location);
                }
                return restResponse;
            }
        };
    }
}

