/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.rules.backend;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.securityanalytics.rules.aggregation.AggregationItem;
import org.opensearch.securityanalytics.rules.backend.OSQueryBackend;
import org.opensearch.securityanalytics.rules.condition.ConditionAND;
import org.opensearch.securityanalytics.rules.condition.ConditionFieldEqualsValueExpression;
import org.opensearch.securityanalytics.rules.condition.ConditionItem;
import org.opensearch.securityanalytics.rules.condition.ConditionNOT;
import org.opensearch.securityanalytics.rules.condition.ConditionOR;
import org.opensearch.securityanalytics.rules.condition.ConditionType;
import org.opensearch.securityanalytics.rules.condition.ConditionValueExpression;
import org.opensearch.securityanalytics.rules.exceptions.SigmaConditionError;
import org.opensearch.securityanalytics.rules.exceptions.SigmaError;
import org.opensearch.securityanalytics.rules.exceptions.SigmaValueError;
import org.opensearch.securityanalytics.rules.objects.SigmaCondition;
import org.opensearch.securityanalytics.rules.objects.SigmaRule;
import org.opensearch.securityanalytics.rules.types.SigmaBool;
import org.opensearch.securityanalytics.rules.types.SigmaCIDRExpression;
import org.opensearch.securityanalytics.rules.types.SigmaCompareExpression;
import org.opensearch.securityanalytics.rules.types.SigmaExpansion;
import org.opensearch.securityanalytics.rules.types.SigmaNull;
import org.opensearch.securityanalytics.rules.types.SigmaNumber;
import org.opensearch.securityanalytics.rules.types.SigmaRegularExpression;
import org.opensearch.securityanalytics.rules.types.SigmaString;
import org.opensearch.securityanalytics.rules.types.SigmaType;
import org.opensearch.securityanalytics.rules.utils.AnyOneOf;
import org.opensearch.securityanalytics.rules.utils.Either;

public abstract class QueryBackend {
    private boolean convertOrAsIn;
    private boolean convertAndAsIn;
    private boolean collectErrors;
    protected boolean enableFieldMappings;
    private List<Pair<SigmaRule, SigmaError>> errors;
    protected Map<String, String> fieldMappings;
    private Map<String, Object> queryFields;
    protected Map<String, Object> ruleQueryFields;

    public QueryBackend(Map<String, String> fieldMappings, boolean convertAndAsIn, boolean enableFieldMappings, boolean convertOrAsIn, boolean collectErrors) {
        this.convertAndAsIn = convertAndAsIn;
        this.convertOrAsIn = convertOrAsIn;
        this.collectErrors = collectErrors;
        this.enableFieldMappings = enableFieldMappings;
        this.errors = new ArrayList<Pair<SigmaRule, SigmaError>>();
        this.queryFields = new HashMap<String, Object>();
        this.fieldMappings = this.enableFieldMappings ? fieldMappings : new HashMap<String, String>();
    }

    public List<Object> convertRule(SigmaRule rule) throws SigmaValueError, SigmaConditionError {
        this.ruleQueryFields = new HashMap<String, Object>();
        ArrayList<Object> queries = new ArrayList<Object>();
        try {
            for (SigmaCondition condition : rule.getDetection().getParsedCondition()) {
                Pair<ConditionItem, AggregationItem> parsedItems = condition.parsed();
                ConditionItem conditionItem = (ConditionItem)parsedItems.getLeft();
                AggregationItem aggItem = (AggregationItem)parsedItems.getRight();
                Object query = conditionItem instanceof ConditionAND ? this.convertCondition(new ConditionType(Either.left(AnyOneOf.leftVal((ConditionAND)conditionItem))), false, false) : (conditionItem instanceof ConditionOR ? this.convertCondition(new ConditionType(Either.left(AnyOneOf.middleVal((ConditionOR)conditionItem))), false, false) : (conditionItem instanceof ConditionNOT ? this.convertCondition(new ConditionType(Either.left(AnyOneOf.rightVal((ConditionNOT)conditionItem))), true, false) : (conditionItem instanceof ConditionFieldEqualsValueExpression ? this.convertCondition(new ConditionType(Either.right(Either.left((ConditionFieldEqualsValueExpression)conditionItem))), false, false) : this.convertCondition(new ConditionType(Either.right(Either.right((ConditionValueExpression)conditionItem))), false, false))));
                queries.add(query);
                if (aggItem == null) continue;
                aggItem.setTimeframe(rule.getDetection().getTimeframe());
                queries.add(this.convertAggregation(aggItem));
            }
            this.queryFields.putAll(this.ruleQueryFields);
        }
        catch (SigmaValueError ex) {
            if (this.collectErrors) {
                this.errors.add((Pair<SigmaRule, SigmaError>)Pair.of((Object)rule, (Object)ex));
            }
            throw ex;
        }
        return queries;
    }

    public Object convertCondition(ConditionType conditionType, boolean isConditionNot, boolean applyDeMorgans) throws SigmaValueError {
        if (conditionType.isConditionOR()) {
            if (this.decideConvertConditionAsInExpression(Either.right(conditionType.getConditionOR()))) {
                return this.convertConditionAsInExpression(Either.right(conditionType.getConditionOR()), isConditionNot, applyDeMorgans);
            }
            return this.convertConditionOr(conditionType.getConditionOR(), isConditionNot, applyDeMorgans);
        }
        if (conditionType.isConditionAND()) {
            if (this.decideConvertConditionAsInExpression(Either.left(conditionType.getConditionAND()))) {
                return this.convertConditionAsInExpression(Either.left(conditionType.getConditionAND()), isConditionNot, applyDeMorgans);
            }
            return this.convertConditionAnd(conditionType.getConditionAND(), isConditionNot, applyDeMorgans);
        }
        if (conditionType.isConditionNOT()) {
            return this.convertConditionNot(conditionType.getConditionNOT(), isConditionNot, applyDeMorgans);
        }
        if (conditionType.isEqualsValueExpression()) {
            if (isConditionNot) {
                return this.convertConditionFieldEqValNot(conditionType, isConditionNot, applyDeMorgans);
            }
            return this.convertConditionFieldEqVal(conditionType.getEqualsValueExpression(), isConditionNot, applyDeMorgans);
        }
        if (conditionType.isValueExpression()) {
            return this.convertConditionVal(conditionType.getValueExpression(), applyDeMorgans);
        }
        throw new IllegalArgumentException("Unexpected data type in condition parse tree");
    }

    public String convertConditionFieldEqValNot(ConditionType conditionType, boolean isConditionNot, boolean applyDeMorgans) throws SigmaValueError {
        String baseString = this.convertConditionFieldEqVal(conditionType.getEqualsValueExpression(), isConditionNot, applyDeMorgans).toString();
        String addExists = this.convertExistsField(conditionType.getEqualsValueExpression()).toString();
        return String.format(Locale.getDefault(), "%s%s", baseString, addExists);
    }

    public boolean decideConvertConditionAsInExpression(Either<ConditionAND, ConditionOR> condition) {
        ConditionFieldEqualsValueExpression equalsValueExpression;
        if (!this.convertOrAsIn && condition.isRight() || !this.convertAndAsIn && condition.isLeft()) {
            return false;
        }
        ConditionItem cond = condition.isLeft() ? (ConditionItem)condition.getLeft() : (ConditionItem)condition.get();
        for (Either<AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression>, String> arg : cond.getArgs()) {
            if (!arg.isLeft() && arg.getLeft().isMiddle()) continue;
            return false;
        }
        HashSet<String> fields = new HashSet<String>();
        for (Either<AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression>, String> arg : cond.getArgs()) {
            equalsValueExpression = arg.getLeft().getMiddle();
            fields.add(equalsValueExpression.getField());
        }
        if (fields.size() != 1) {
            return false;
        }
        for (Either<AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression>, String> arg : cond.getArgs()) {
            equalsValueExpression = arg.getLeft().getMiddle();
            if (equalsValueExpression.getValue() instanceof SigmaString || equalsValueExpression.getValue() instanceof SigmaNumber) continue;
            return false;
        }
        return true;
    }

    public Map<String, Object> getQueryFields() {
        return this.queryFields;
    }

    public void resetQueryFields() {
        this.queryFields.clear();
        if (this.ruleQueryFields != null) {
            this.ruleQueryFields.clear();
        }
    }

    public abstract Object convertConditionAsInExpression(Either<ConditionAND, ConditionOR> var1, boolean var2, boolean var3);

    public abstract Object convertConditionAnd(ConditionAND var1, boolean var2, boolean var3);

    public abstract Object convertConditionOr(ConditionOR var1, boolean var2, boolean var3);

    public abstract Object convertConditionNot(ConditionNOT var1, boolean var2, boolean var3);

    public Object convertConditionFieldEqVal(ConditionFieldEqualsValueExpression condition, boolean isConditionNot, boolean applyDeMorgans) throws SigmaValueError {
        if (condition.getValue() instanceof SigmaString) {
            return this.convertConditionFieldEqValStr(condition, applyDeMorgans);
        }
        if (condition.getValue() instanceof SigmaNumber) {
            return this.convertConditionFieldEqValNum(condition, applyDeMorgans);
        }
        if (condition.getValue() instanceof SigmaBool) {
            return this.convertConditionFieldEqValBool(condition, applyDeMorgans);
        }
        if (condition.getValue() instanceof SigmaRegularExpression) {
            return this.convertConditionFieldEqValRe(condition, applyDeMorgans);
        }
        if (condition.getValue() instanceof SigmaCIDRExpression) {
            return this.convertConditionFieldEqValCidr(condition, applyDeMorgans);
        }
        if (condition.getValue() instanceof SigmaCompareExpression) {
            return this.convertConditionFieldEqValOpVal(condition, applyDeMorgans);
        }
        if (condition.getValue() instanceof SigmaNull) {
            return this.convertConditionFieldEqValNull(condition, applyDeMorgans);
        }
        if (condition.getValue() instanceof SigmaExpansion) {
            return this.convertConditionFieldEqValQueryExpansion(condition, isConditionNot, applyDeMorgans);
        }
        throw new IllegalArgumentException("Unexpected value type class in condition parse tree: " + condition.getValue().getClass().getName());
    }

    public abstract Object convertConditionFieldEqValStr(ConditionFieldEqualsValueExpression var1, boolean var2) throws SigmaValueError;

    public abstract Object convertConditionFieldEqValNum(ConditionFieldEqualsValueExpression var1, boolean var2);

    public abstract Object convertConditionFieldEqValBool(ConditionFieldEqualsValueExpression var1, boolean var2);

    public abstract Object convertConditionFieldEqValRe(ConditionFieldEqualsValueExpression var1, boolean var2);

    public abstract Object convertConditionFieldEqValCidr(ConditionFieldEqualsValueExpression var1, boolean var2);

    public abstract Object convertConditionFieldEqValOpVal(ConditionFieldEqualsValueExpression var1, boolean var2);

    public abstract Object convertConditionFieldEqValNull(ConditionFieldEqualsValueExpression var1, boolean var2);

    public abstract Object convertExistsField(ConditionFieldEqualsValueExpression var1);

    public Object convertConditionFieldEqValQueryExpansion(ConditionFieldEqualsValueExpression condition, boolean isConditionNot, boolean applyDeMorgans) {
        ArrayList<Either<AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression>, String>> args = new ArrayList<Either<AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression>, String>>();
        for (SigmaType sigmaType : ((SigmaExpansion)condition.getValue()).getValues()) {
            args.add(Either.left(AnyOneOf.middleVal(new ConditionFieldEqualsValueExpression(condition.getField(), sigmaType))));
        }
        ConditionOR conditionOR = new ConditionOR(false, args);
        return this.convertConditionOr(conditionOR, isConditionNot, applyDeMorgans);
    }

    public Object convertConditionVal(ConditionValueExpression condition, boolean applyDeMorgans) throws SigmaValueError {
        if (condition.getValue() instanceof SigmaString) {
            return this.convertConditionValStr(condition, applyDeMorgans);
        }
        if (condition.getValue() instanceof SigmaNumber) {
            return this.convertConditionValNum(condition, applyDeMorgans);
        }
        if (condition.getValue() instanceof SigmaBool) {
            throw new SigmaValueError("Boolean values can't appear as standalone value without a field name.");
        }
        if (condition.getValue() instanceof SigmaRegularExpression) {
            return this.convertConditionValRe(condition, applyDeMorgans);
        }
        throw new IllegalArgumentException("Unexpected value type class in condition parse tree: " + condition.getValue().getClass().getName());
    }

    public abstract Object convertConditionValStr(ConditionValueExpression var1, boolean var2) throws SigmaValueError;

    public abstract Object convertConditionValNum(ConditionValueExpression var1, boolean var2);

    public abstract Object convertConditionValRe(ConditionValueExpression var1, boolean var2);

    public abstract OSQueryBackend.AggregationQueries convertAggregation(AggregationItem var1);
}

