/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.action;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.rest.RestRequest;
import org.opensearch.securityanalytics.threatIntel.common.SourceConfigDtoValidator;
import org.opensearch.securityanalytics.threatIntel.model.SATIFSourceConfigDto;
import org.opensearch.securityanalytics.threatIntel.sacommons.IndexTIFSourceConfigRequest;

public class SAIndexTIFSourceConfigRequest
extends ActionRequest
implements IndexTIFSourceConfigRequest {
    private static final SourceConfigDtoValidator VALIDATOR = new SourceConfigDtoValidator();
    private String tifSourceConfigId;
    private final RestRequest.Method method;
    private SATIFSourceConfigDto saTifSourceConfigDto;

    public SAIndexTIFSourceConfigRequest(String tifSourceConfigId, RestRequest.Method method, SATIFSourceConfigDto saTifSourceConfigDto) {
        this.tifSourceConfigId = tifSourceConfigId;
        this.method = method;
        this.saTifSourceConfigDto = saTifSourceConfigDto;
    }

    public SAIndexTIFSourceConfigRequest(StreamInput sin) throws IOException {
        this(sin.readString(), (RestRequest.Method)sin.readEnum(RestRequest.Method.class), SATIFSourceConfigDto.readFrom(sin));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.tifSourceConfigId);
        out.writeEnum((Enum)this.method);
        this.saTifSourceConfigDto.writeTo(out);
    }

    @Override
    public String getTIFConfigId() {
        return this.tifSourceConfigId;
    }

    public void setTIFConfigId(String tifConfigId) {
        this.tifSourceConfigId = tifConfigId;
    }

    @Override
    public SATIFSourceConfigDto getTIFConfigDto() {
        return this.saTifSourceConfigDto;
    }

    public void setTIFConfigDto(SATIFSourceConfigDto saTifSourceConfigDto) {
        this.saTifSourceConfigDto = saTifSourceConfigDto;
    }

    public RestRequest.Method getMethod() {
        return this.method;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException errors = new ActionRequestValidationException();
        List<String> errorMsgs = VALIDATOR.validateSourceConfigDto(this.saTifSourceConfigDto);
        if (!errorMsgs.isEmpty()) {
            errorMsgs.forEach(arg_0 -> ((ActionRequestValidationException)errors).addValidationError(arg_0));
        }
        return errors.validationErrors().isEmpty() ? null : errors;
    }
}

