/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.action.PublishFindingsRequest;
import org.opensearch.commons.alerting.action.SubscribeFindingsResponse;
import org.opensearch.commons.alerting.model.Finding;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.InputStreamStreamInput;
import org.opensearch.core.common.io.stream.OutputStreamStreamOutput;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.correlation.JoinEngine;
import org.opensearch.securityanalytics.correlation.VectorEmbeddingsEngine;
import org.opensearch.securityanalytics.correlation.alert.CorrelationAlertService;
import org.opensearch.securityanalytics.correlation.alert.notifications.NotificationService;
import org.opensearch.securityanalytics.logtype.LogTypeService;
import org.opensearch.securityanalytics.model.CustomLogType;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.securityanalytics.util.CorrelationIndices;
import org.opensearch.securityanalytics.util.DetectorIndices;
import org.opensearch.securityanalytics.util.IndexUtils;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportCorrelateFindingAction
extends HandledTransportAction<ActionRequest, SubscribeFindingsResponse>
implements SecureTransportAction {
    private static final Logger log = LogManager.getLogger(TransportCorrelateFindingAction.class);
    private final DetectorIndices detectorIndices;
    private final CorrelationIndices correlationIndices;
    private final LogTypeService logTypeService;
    private final ClusterService clusterService;
    private final Settings settings;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final ThreadPool threadPool;
    private volatile TimeValue indexTimeout;
    private volatile long corrTimeWindow;
    private volatile long setupTimestamp;
    private volatile boolean enableAutoCorrelation;
    private final CorrelationAlertService correlationAlertService;
    private final NotificationService notificationService;

    @Inject
    public TransportCorrelateFindingAction(TransportService transportService, Client client, NamedXContentRegistry xContentRegistry, DetectorIndices detectorIndices, CorrelationIndices correlationIndices, LogTypeService logTypeService, ClusterService clusterService, Settings settings, ActionFilters actionFilters, CorrelationAlertService correlationAlertService, NotificationService notificationService) {
        super("cluster:admin/opensearch/alerting/findings/subscribe", transportService, actionFilters, PublishFindingsRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.detectorIndices = detectorIndices;
        this.correlationIndices = correlationIndices;
        this.logTypeService = logTypeService;
        this.clusterService = clusterService;
        this.settings = settings;
        this.correlationAlertService = correlationAlertService;
        this.notificationService = notificationService;
        this.threadPool = this.detectorIndices.getThreadPool();
        this.indexTimeout = (TimeValue)SecurityAnalyticsSettings.INDEX_TIMEOUT.get(this.settings);
        this.corrTimeWindow = ((TimeValue)SecurityAnalyticsSettings.CORRELATION_TIME_WINDOW.get(this.settings)).getMillis();
        this.enableAutoCorrelation = (Boolean)SecurityAnalyticsSettings.ENABLE_AUTO_CORRELATIONS.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.INDEX_TIMEOUT, it -> {
            this.indexTimeout = it;
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.CORRELATION_TIME_WINDOW, it -> {
            this.corrTimeWindow = it.getMillis();
        });
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.ENABLE_AUTO_CORRELATIONS, it -> {
            this.enableAutoCorrelation = it;
        });
        this.setupTimestamp = System.currentTimeMillis();
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<SubscribeFindingsResponse> actionListener) {
        try {
            PublishFindingsRequest transformedRequest = this.transformRequest(request);
            AsyncCorrelateFindingAction correlateFindingAction = new AsyncCorrelateFindingAction(task, transformedRequest, this.readUserFromThreadContext(this.threadPool), actionListener);
            if (!this.correlationIndices.correlationIndexExists()) {
                try {
                    this.correlationIndices.initCorrelationIndex((ActionListener<CreateIndexResponse>)ActionListener.wrap(response -> {
                        if (response.isAcknowledged()) {
                            IndexUtils.correlationIndexUpdated();
                            if (IndexUtils.correlationIndexUpdated.booleanValue()) {
                                IndexUtils.lastUpdatedCorrelationHistoryIndex = IndexUtils.getIndexNameWithAlias(this.clusterService.state(), ".opensearch-sap-correlation-history-write");
                            }
                            if (!this.correlationIndices.correlationMetadataIndexExists()) {
                                try {
                                    this.correlationIndices.initCorrelationMetadataIndex((ActionListener<CreateIndexResponse>)ActionListener.wrap(createIndexResponse -> {
                                        if (createIndexResponse.isAcknowledged()) {
                                            IndexUtils.correlationMetadataIndexUpdated();
                                            this.correlationIndices.setupCorrelationIndex(this.indexTimeout, this.setupTimestamp, (ActionListener<BulkResponse>)ActionListener.wrap(bulkResponse -> {
                                                if (bulkResponse.hasFailures()) {
                                                    correlateFindingAction.onFailures((Exception)new OpenSearchStatusException(createIndexResponse.toString(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                                                }
                                                correlateFindingAction.start();
                                            }, correlateFindingAction::onFailures));
                                        } else {
                                            correlateFindingAction.onFailures((Exception)new OpenSearchStatusException("Failed to create correlation metadata Index", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                                        }
                                    }, correlateFindingAction::onFailures));
                                }
                                catch (Exception ex) {
                                    correlateFindingAction.onFailures(ex);
                                }
                            }
                            if (!this.correlationIndices.correlationAlertIndexExists()) {
                                try {
                                    this.correlationIndices.initCorrelationAlertIndex((ActionListener<CreateIndexResponse>)ActionListener.wrap(createIndexResponse -> {
                                        if (createIndexResponse.isAcknowledged()) {
                                            IndexUtils.correlationAlertIndexUpdated();
                                        } else {
                                            correlateFindingAction.onFailures((Exception)new OpenSearchStatusException("Failed to create correlation metadata Index", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                                        }
                                    }, correlateFindingAction::onFailures));
                                }
                                catch (Exception ex) {
                                    correlateFindingAction.onFailures(ex);
                                }
                            }
                        } else {
                            correlateFindingAction.onFailures((Exception)new OpenSearchStatusException("Failed to create correlation Index", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                        }
                    }, correlateFindingAction::onFailures));
                }
                catch (Exception ex) {
                    correlateFindingAction.onFailures(ex);
                }
            } else {
                correlateFindingAction.start();
            }
        }
        catch (Exception e) {
            throw new SecurityAnalyticsException("Unknown exception occurred", RestStatus.INTERNAL_SERVER_ERROR, e);
        }
    }

    private PublishFindingsRequest transformRequest(ActionRequest request) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamStreamOutput osso = new OutputStreamStreamOutput((OutputStream)baos);
        request.writeTo((StreamOutput)osso);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        InputStreamStreamInput issi = new InputStreamStreamInput((InputStream)bais);
        return new PublishFindingsRequest((StreamInput)issi);
    }

    public class AsyncCorrelateFindingAction {
        private final PublishFindingsRequest request;
        private final JoinEngine joinEngine;
        private final VectorEmbeddingsEngine vectorEmbeddingsEngine;
        private final ActionListener<SubscribeFindingsResponse> listener;
        private final AtomicReference<Object> response;
        private final AtomicBoolean counter = new AtomicBoolean();
        private final Task task;

        AsyncCorrelateFindingAction(Task task, PublishFindingsRequest request, User user, ActionListener<SubscribeFindingsResponse> listener) {
            this.task = task;
            this.request = request;
            this.listener = listener;
            this.response = new AtomicReference();
            this.joinEngine = new JoinEngine(TransportCorrelateFindingAction.this.client, request, TransportCorrelateFindingAction.this.xContentRegistry, TransportCorrelateFindingAction.this.corrTimeWindow, TransportCorrelateFindingAction.this.indexTimeout, this, TransportCorrelateFindingAction.this.logTypeService, TransportCorrelateFindingAction.this.enableAutoCorrelation, TransportCorrelateFindingAction.this.correlationAlertService, TransportCorrelateFindingAction.this.notificationService, user);
            this.vectorEmbeddingsEngine = new VectorEmbeddingsEngine(TransportCorrelateFindingAction.this.client, TransportCorrelateFindingAction.this.indexTimeout, TransportCorrelateFindingAction.this.corrTimeWindow, this);
        }

        void start() {
            TransportCorrelateFindingAction.this.threadPool.getThreadContext().stashContext();
            String monitorId = this.request.getMonitorId();
            Finding finding = this.request.getFinding();
            if (TransportCorrelateFindingAction.this.detectorIndices.detectorIndexExists()) {
                NestedQueryBuilder queryBuilder = QueryBuilders.nestedQuery((String)"detector", (QueryBuilder)QueryBuilders.matchQuery((String)"detector.monitor_id", (Object)monitorId), (ScoreMode)ScoreMode.None);
                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                searchSourceBuilder.query((QueryBuilder)queryBuilder);
                searchSourceBuilder.fetchSource(true);
                searchSourceBuilder.size(1);
                SearchRequest searchRequest = new SearchRequest();
                searchRequest.indices(new String[]{".opensearch-sap-detectors-config"});
                searchRequest.source(searchSourceBuilder);
                searchRequest.preference(Preference.PRIMARY_FIRST.type());
                searchRequest.setCancelAfterTimeInterval(TimeValue.timeValueSeconds((long)30L));
                TransportCorrelateFindingAction.this.client.search(searchRequest, ActionListener.wrap(response -> {
                    SearchHits hits;
                    if (response.isTimedOut()) {
                        this.onFailures((Exception)new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0]));
                    }
                    if ((hits = response.getHits()).getHits().length > 0) {
                        try {
                            SearchHit hit = hits.getAt(0);
                            XContentParser xcp = XContentType.JSON.xContent().createParser(TransportCorrelateFindingAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                            Detector detector = Detector.docParse(xcp, hit.getId(), hit.getVersion());
                            this.joinEngine.onSearchDetectorResponse(detector, finding);
                        }
                        catch (Exception e) {
                            log.error("Exception for request {}", (Object)searchRequest.toString(), (Object)e);
                            this.onFailures(e);
                        }
                    } else {
                        this.onFailures((Exception)new OpenSearchStatusException("detector not found given monitor id " + this.request.getMonitorId(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                    }
                }, this::onFailures));
            } else {
                this.onFailures((Exception)((Object)new SecurityAnalyticsException(String.format(Locale.getDefault(), "Detector index %s doesnt exist", ".opensearch-sap-detectors-config"), RestStatus.INTERNAL_SERVER_ERROR, new RuntimeException())));
            }
        }

        public void initCorrelationIndex(String detectorType, Map<String, List<String>> correlatedFindings, List<String> correlationRules) {
            try {
                if (!IndexUtils.correlationIndexUpdated.booleanValue()) {
                    IndexUtils.updateIndexMapping(".opensearch-sap-correlation-history-write", CorrelationIndices.correlationMappings(), TransportCorrelateFindingAction.this.clusterService.state(), TransportCorrelateFindingAction.this.client.admin().indices(), (ActionListener<AcknowledgedResponse>)ActionListener.wrap(response -> {
                        if (response.isAcknowledged()) {
                            IndexUtils.correlationIndexUpdated();
                            this.getTimestampFeature(detectorType, correlatedFindings, null, correlationRules);
                        } else {
                            this.onFailures((Exception)new OpenSearchStatusException("Failed to create correlation Index", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                        }
                    }, this::onFailures), true);
                } else {
                    this.getTimestampFeature(detectorType, correlatedFindings, null, correlationRules);
                }
            }
            catch (Exception ex) {
                this.onFailures(ex);
            }
        }

        public void getTimestampFeature(String detectorType, Map<String, List<String>> correlatedFindings, Finding orphanFinding, List<String> correlationRules) {
            try {
                if (!TransportCorrelateFindingAction.this.correlationIndices.correlationMetadataIndexExists()) {
                    TransportCorrelateFindingAction.this.correlationIndices.initCorrelationMetadataIndex((ActionListener<CreateIndexResponse>)ActionListener.wrap(response -> {
                        if (response.isAcknowledged()) {
                            IndexUtils.correlationMetadataIndexUpdated();
                            TransportCorrelateFindingAction.this.correlationIndices.setupCorrelationIndex(TransportCorrelateFindingAction.this.indexTimeout, TransportCorrelateFindingAction.this.setupTimestamp, (ActionListener<BulkResponse>)ActionListener.wrap(bulkResponse -> {
                                if (bulkResponse.hasFailures()) {
                                    this.onFailures((Exception)new OpenSearchStatusException(bulkResponse.toString(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                                }
                                long findingTimestamp = this.request.getFinding().getTimestamp().toEpochMilli();
                                SearchRequest searchMetadataIndexRequest = this.getSearchMetadataIndexRequest();
                                TransportCorrelateFindingAction.this.client.search(searchMetadataIndexRequest, ActionListener.wrap(searchMetadataResponse -> {
                                    if (searchMetadataResponse.getHits().getHits().length == 0) {
                                        this.onFailures((Exception)new ResourceNotFoundException("Failed to find hits in metadata index for finding id {}", new Object[]{this.request.getFinding().getId()}));
                                    }
                                    String id = searchMetadataResponse.getHits().getHits()[0].getId();
                                    long newScoreTimestamp = findingTimestamp - 1728000000L;
                                    Map hitSource = searchMetadataResponse.getHits().getHits()[0].getSourceAsMap();
                                    long scoreTimestamp = (Long)hitSource.get("scoreTimestamp");
                                    if (newScoreTimestamp > scoreTimestamp) {
                                        try {
                                            IndexRequest scoreIndexRequest = this.getCorrelationMetadataIndexRequest(id, newScoreTimestamp);
                                            TransportCorrelateFindingAction.this.client.index(scoreIndexRequest, ActionListener.wrap(indexResponse -> {
                                                SearchRequest searchRequest = this.getSearchLogTypeIndexRequest();
                                                TransportCorrelateFindingAction.this.client.search(searchRequest, ActionListener.wrap(searchResponse -> {
                                                    if (searchResponse.isTimedOut()) {
                                                        this.onFailures((Exception)new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0]));
                                                    }
                                                    SearchHit[] hits = searchResponse.getHits().getHits();
                                                    HashMap<String, CustomLogType> logTypes = new HashMap<String, CustomLogType>();
                                                    for (SearchHit hit : hits) {
                                                        Map sourceMap = hit.getSourceAsMap();
                                                        logTypes.put(sourceMap.get("name").toString(), new CustomLogType(sourceMap));
                                                    }
                                                    if (correlatedFindings != null) {
                                                        if (correlatedFindings.isEmpty()) {
                                                            this.vectorEmbeddingsEngine.insertOrphanFindings(detectorType, this.request.getFinding(), Long.valueOf(1728000L).floatValue(), logTypes);
                                                        }
                                                        for (Map.Entry correlatedFinding : correlatedFindings.entrySet()) {
                                                            this.vectorEmbeddingsEngine.insertCorrelatedFindings(detectorType, this.request.getFinding(), (String)correlatedFinding.getKey(), (List)correlatedFinding.getValue(), Long.valueOf(1728000L).floatValue(), correlationRules, logTypes);
                                                        }
                                                    } else {
                                                        this.vectorEmbeddingsEngine.insertOrphanFindings(detectorType, orphanFinding, Long.valueOf(1728000L).floatValue(), logTypes);
                                                    }
                                                }, this::onFailures));
                                            }, this::onFailures));
                                        }
                                        catch (Exception ex) {
                                            this.onFailures(ex);
                                        }
                                    } else {
                                        float timestampFeature = Long.valueOf((findingTimestamp - scoreTimestamp) / 1000L).floatValue();
                                        SearchRequest searchRequest = this.getSearchLogTypeIndexRequest();
                                        this.insertFindings(timestampFeature, searchRequest, correlatedFindings, detectorType, correlationRules, orphanFinding);
                                    }
                                }, this::onFailures));
                            }, this::onFailures));
                        } else {
                            OpenSearchStatusException e = new OpenSearchStatusException("Failed to create correlation metadata Index", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
                            this.onFailures((Exception)e);
                        }
                    }, this::onFailures));
                } else {
                    long findingTimestamp = this.request.getFinding().getTimestamp().toEpochMilli();
                    SearchRequest searchMetadataIndexRequest = this.getSearchMetadataIndexRequest();
                    TransportCorrelateFindingAction.this.client.search(searchMetadataIndexRequest, ActionListener.wrap(response -> {
                        if (response.getHits().getHits().length == 0) {
                            this.onFailures((Exception)new ResourceNotFoundException("Failed to find hits in metadata index for finding id {}", new Object[]{this.request.getFinding().getId()}));
                        } else {
                            String id = response.getHits().getHits()[0].getId();
                            long newScoreTimestamp = findingTimestamp - 1728000000L;
                            Map hitSource = response.getHits().getHits()[0].getSourceAsMap();
                            long scoreTimestamp = (Long)hitSource.get("scoreTimestamp");
                            if (newScoreTimestamp > scoreTimestamp) {
                                IndexRequest scoreIndexRequest = this.getCorrelationMetadataIndexRequest(id, newScoreTimestamp);
                                TransportCorrelateFindingAction.this.client.index(scoreIndexRequest, ActionListener.wrap(indexResponse -> {
                                    SearchRequest searchRequest = this.getSearchLogTypeIndexRequest();
                                    TransportCorrelateFindingAction.this.client.search(searchRequest, ActionListener.wrap(searchResponse -> {
                                        if (searchResponse.isTimedOut()) {
                                            this.onFailures((Exception)new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0]));
                                        }
                                        SearchHit[] hits = searchResponse.getHits().getHits();
                                        HashMap<String, CustomLogType> logTypes = new HashMap<String, CustomLogType>();
                                        for (SearchHit hit : hits) {
                                            Map sourceMap = hit.getSourceAsMap();
                                            logTypes.put(sourceMap.get("name").toString(), new CustomLogType(sourceMap));
                                        }
                                        if (correlatedFindings != null) {
                                            if (correlatedFindings.isEmpty()) {
                                                this.vectorEmbeddingsEngine.insertOrphanFindings(detectorType, this.request.getFinding(), Long.valueOf(1728000L).floatValue(), logTypes);
                                            }
                                            for (Map.Entry correlatedFinding : correlatedFindings.entrySet()) {
                                                this.vectorEmbeddingsEngine.insertCorrelatedFindings(detectorType, this.request.getFinding(), (String)correlatedFinding.getKey(), (List)correlatedFinding.getValue(), Long.valueOf(1728000L).floatValue(), correlationRules, logTypes);
                                            }
                                        } else {
                                            this.vectorEmbeddingsEngine.insertOrphanFindings(detectorType, orphanFinding, Long.valueOf(1728000L).floatValue(), logTypes);
                                        }
                                    }, this::onFailures));
                                }, this::onFailures));
                            } else {
                                float timestampFeature = Long.valueOf((findingTimestamp - scoreTimestamp) / 1000L).floatValue();
                                SearchRequest searchRequest = this.getSearchLogTypeIndexRequest();
                                this.insertFindings(timestampFeature, searchRequest, correlatedFindings, detectorType, correlationRules, orphanFinding);
                            }
                        }
                    }, this::onFailures));
                }
            }
            catch (Exception ex) {
                this.onFailures(ex);
            }
        }

        private SearchRequest getSearchLogTypeIndexRequest() {
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)"source"));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            searchSourceBuilder.fetchSource(true);
            searchSourceBuilder.size(10000);
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.indices(new String[]{".opensearch-sap-log-types-config"});
            searchRequest.source(searchSourceBuilder);
            searchRequest.setCancelAfterTimeInterval(TimeValue.timeValueSeconds((long)30L));
            return searchRequest;
        }

        private IndexRequest getCorrelationMetadataIndexRequest(String id, long newScoreTimestamp) throws IOException {
            XContentBuilder scoreBuilder = XContentFactory.jsonBuilder().startObject();
            scoreBuilder.field("scoreTimestamp", newScoreTimestamp);
            scoreBuilder.field("root", false);
            scoreBuilder.endObject();
            return (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap-correlation-metadata").id(id).source(scoreBuilder).timeout(TransportCorrelateFindingAction.this.indexTimeout)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        }

        private void insertFindings(float timestampFeature, SearchRequest searchRequest, Map<String, List<String>> correlatedFindings, String detectorType, List<String> correlationRules, Finding orphanFinding) {
            TransportCorrelateFindingAction.this.client.search(searchRequest, ActionListener.wrap(response -> {
                if (response.isTimedOut()) {
                    this.onFailures((Exception)new OpenSearchStatusException("Search request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0]));
                }
                SearchHit[] hits = response.getHits().getHits();
                HashMap<String, CustomLogType> logTypes = new HashMap<String, CustomLogType>();
                for (SearchHit hit : hits) {
                    Map sourceMap = hit.getSourceAsMap();
                    logTypes.put(sourceMap.get("name").toString(), new CustomLogType(sourceMap));
                }
                if (correlatedFindings != null) {
                    if (correlatedFindings.isEmpty()) {
                        this.vectorEmbeddingsEngine.insertOrphanFindings(detectorType, this.request.getFinding(), timestampFeature, logTypes);
                    }
                    for (Map.Entry correlatedFinding : correlatedFindings.entrySet()) {
                        this.vectorEmbeddingsEngine.insertCorrelatedFindings(detectorType, this.request.getFinding(), (String)correlatedFinding.getKey(), (List)correlatedFinding.getValue(), timestampFeature, correlationRules, logTypes);
                    }
                } else {
                    this.vectorEmbeddingsEngine.insertOrphanFindings(detectorType, orphanFinding, timestampFeature, logTypes);
                }
            }, this::onFailures));
        }

        private SearchRequest getSearchMetadataIndexRequest() {
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)"scoreTimestamp", (long)0L));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            searchSourceBuilder.fetchSource(true);
            searchSourceBuilder.size(1);
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.indices(new String[]{".opensearch-sap-correlation-metadata"});
            searchRequest.source(searchSourceBuilder);
            searchRequest.preference(Preference.PRIMARY_FIRST.type());
            searchRequest.setCancelAfterTimeInterval(TimeValue.timeValueSeconds((long)30L));
            return searchRequest;
        }

        public void onOperation() {
            this.response.set(RestStatus.OK);
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(null);
            }
        }

        public void onFailures(Exception t) {
            log.error("Exception occurred while processing correlations for monitor id " + this.request.getMonitorId() + " and finding id " + this.request.getFinding().getId(), (Throwable)t);
            if (this.counter.compareAndSet(false, true)) {
                this.finishHim(t);
            }
        }

        private void finishHim(Exception t) {
            TransportCorrelateFindingAction.this.threadPool.executor("generic").execute((Runnable)ActionRunnable.supply(this.listener, () -> {
                if (t != null) {
                    if (t instanceof OpenSearchStatusException) {
                        throw t;
                    }
                    throw SecurityAnalyticsException.wrap(t);
                }
                return new SubscribeFindingsResponse(RestStatus.OK);
            }));
        }
    }
}

