/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.securityanalytics.action.GetCorrelationAlertsAction;
import org.opensearch.securityanalytics.action.GetCorrelationAlertsRequest;
import org.opensearch.securityanalytics.action.GetCorrelationAlertsResponse;
import org.opensearch.securityanalytics.correlation.alert.CorrelationAlertService;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportGetCorrelationAlertsAction
extends HandledTransportAction<GetCorrelationAlertsRequest, GetCorrelationAlertsResponse>
implements SecureTransportAction {
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private final Settings settings;
    private final ThreadPool threadPool;
    private final CorrelationAlertService correlationAlertService;
    private volatile Boolean filterByEnabled;
    private static final Logger log = LogManager.getLogger(TransportGetCorrelationAlertsAction.class);

    @Inject
    public TransportGetCorrelationAlertsAction(TransportService transportService, CorrelationAlertService correlationAlertService, ActionFilters actionFilters, ClusterService clusterService, GetCorrelationAlertsAction getCorrelationAlertsAction, ThreadPool threadPool, Settings settings, NamedXContentRegistry xContentRegistry, Client client) {
        super("cluster:admin/opensearch/securityanalytics/correlationAlerts/get", transportService, actionFilters, GetCorrelationAlertsRequest::new);
        this.xContentRegistry = xContentRegistry;
        this.correlationAlertService = correlationAlertService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.settings = settings;
        this.filterByEnabled = (Boolean)SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES, this::setFilterByEnabled);
    }

    protected void doExecute(Task task, GetCorrelationAlertsRequest request, ActionListener<GetCorrelationAlertsResponse> actionListener) {
        User user = this.readUserFromThreadContext(this.threadPool);
        String validateBackendRoleMessage = this.validateUserBackendRoles(user, this.filterByEnabled);
        if (!"".equals(validateBackendRoleMessage)) {
            actionListener.onFailure((Exception)new OpenSearchStatusException("Do not have permissions to resource", RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        this.threadPool.getThreadContext().stashContext();
        if (request.getCorrelationRuleId() != null) {
            this.correlationAlertService.getCorrelationAlerts(request.getCorrelationRuleId(), request.getTable(), actionListener);
        } else {
            this.correlationAlertService.getCorrelationAlerts(null, request.getTable(), actionListener);
        }
    }

    private void setFilterByEnabled(boolean filterByEnabled) {
        this.filterByEnabled = filterByEnabled;
    }
}

