/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ubi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.opensearch.ubi.QueryResponse;

public class QueryRequest {
    private final String timestamp = sdf.format(new Date());
    private final String queryId;
    private final String clientId;
    private final String userQuery;
    private final String query;
    private final String application;
    private final Map<String, String> queryAttributes;
    private final QueryResponse queryResponse;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.getDefault());

    public QueryRequest(String queryId, String userQuery, String clientId, String query, String application, Map<String, String> queryAttributes, QueryResponse queryResponse) {
        this.queryId = queryId;
        this.clientId = clientId;
        this.userQuery = userQuery;
        this.query = query;
        this.application = application;
        this.queryAttributes = queryAttributes;
        this.queryResponse = queryResponse;
    }

    public String toString() {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = AccessController.doPrivileged(() -> {
            try {
                return objectMapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException ex) {
                throw new RuntimeException(ex);
            }
        });
        return "[" + json + "]";
    }

    public Map<String, String> getQueryAttributes() {
        return this.queryAttributes;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getApplication() {
        return this.application;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getUserQuery() {
        if (this.userQuery == null) {
            return "";
        }
        return this.userQuery;
    }

    public String getClientId() {
        if (this.clientId == null) {
            return "";
        }
        return this.clientId;
    }

    public String getQuery() {
        if (this.query == null) {
            return "";
        }
        return this.query;
    }

    public QueryResponse getQueryResponse() {
        return this.queryResponse;
    }
}

