/*
 * Decompiled with CFR 0.152.
 */
package EcdhEdkWrapping_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import BoundedInts_Compile.uint8;
import EcdhEdkWrapping_Compile.EcdhUnwrapInfo;
import EcdhEdkWrapping_Compile.__default;
import MaterialWrapping_Compile.UnwrapInput;
import MaterialWrapping_Compile.UnwrapMaterial;
import MaterialWrapping_Compile.UnwrapOutput;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.AESDecryptInput;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;
import software.amazon.cryptography.primitives.internaldafny.types.Error;

public class EcdhUnwrap
implements UnwrapMaterial<EcdhUnwrapInfo>,
ActionWithResult<UnwrapInput, UnwrapOutput<EcdhUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>,
Action<UnwrapInput, Result<UnwrapOutput<EcdhUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error>> {
    public DafnySequence<? extends Byte> _senderPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public DafnySequence<? extends Byte> _recipientPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public DafnySequence<? extends Byte> _sharedSecret = DafnySequence.empty(uint8._typeDescriptor());
    public DafnySequence<? extends Byte> _keyringVersion = DafnySequence.empty(uint8._typeDescriptor());
    public ECDHCurveSpec _curveSpec = ECDHCurveSpec.Default();
    public AtomicPrimitivesClient _crypto = null;
    private static final TypeDescriptor<EcdhUnwrap> _TYPE = TypeDescriptor.referenceWithInitializer(EcdhUnwrap.class, () -> null);

    public void __ctor(DafnySequence<? extends Byte> senderPublicKey, DafnySequence<? extends Byte> recipientPublicKey, DafnySequence<? extends Byte> sharedSecret, DafnySequence<? extends Byte> keyringVersion, ECDHCurveSpec curveSpec, AtomicPrimitivesClient crypto) {
        this._senderPublicKey = senderPublicKey;
        this._recipientPublicKey = recipientPublicKey;
        this._sharedSecret = sharedSecret;
        this._keyringVersion = keyringVersion;
        this._curveSpec = curveSpec;
        this._crypto = crypto;
    }

    @Override
    public Result<UnwrapOutput<EcdhUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> Invoke(UnwrapInput input) {
        Result<DafnySequence<? extends Byte>, Error> _out2;
        boolean _out1;
        Result<UnwrapOutput<EcdhUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = Result.Default(UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput.Default(EcdhUnwrapInfo._typeDescriptor(), EcdhUnwrapInfo.Default()));
        AlgorithmSuiteInfo _0_suite = input.dtor_algorithmSuite();
        DafnySequence<? extends Byte> _1_wrappedMaterial = input.dtor_wrappedMaterial();
        DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> _2_aad = input.dtor_encryptionContext();
        Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _3_valueOrError0 = Outcome.Default(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        _3_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), Long.compareUnsigned(_1_wrappedMaterial.cardinalityInt(), Constants_Compile.__default.CIPHERTEXT__WRAPPED__MATERIAL__INDEX()) > 0, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received ciphertext is shorter than expected.")));
        if (_3_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _3_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()));
            return res;
        }
        int _4_KeyLength = AlgorithmSuites_Compile.__default.GetEncryptKeyLength(_0_suite);
        Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _5_valueOrError1 = Outcome.Default(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        _5_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_1_wrappedMaterial.length()).compareTo(Helpers.unsignedToBigInteger((long)Constants_Compile.__default.ECDH__WRAPPED__KEY__MATERIAL__INDEX()).add(BigInteger.valueOf(_4_KeyLength))) > 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received EDK Ciphertext of incorrect length3.")));
        if (_5_valueOrError1.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _5_valueOrError1.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()));
            return res;
        }
        DafnySequence _6_kdfNonce = _1_wrappedMaterial.take(Constants_Compile.__default.ECDH__COMMITMENT__KEY__INDEX());
        DafnySequence _7_iv = DafnySequence.Create(uint8._typeDescriptor(), (BigInteger)BigInteger.valueOf(Constants_Compile.__default.ECDH__AES__256__ENC__ALG().dtor_ivLength()), _8___v0_boxed0 -> {
            BigInteger _8___v0 = _8___v0_boxed0;
            return (byte)0;
        });
        DafnySequence _9_commitmentKey = _1_wrappedMaterial.subsequence(Helpers.unsignedToInt((long)Constants_Compile.__default.ECDH__COMMITMENT__KEY__INDEX()), Helpers.unsignedToInt((long)Constants_Compile.__default.ECDH__WRAPPED__KEY__MATERIAL__INDEX()));
        DafnySequence _10_wrappedKey = _1_wrappedMaterial.subsequence(Helpers.unsignedToInt((long)Constants_Compile.__default.ECDH__WRAPPED__KEY__MATERIAL__INDEX()), Helpers.unsignedToInt((long)(Constants_Compile.__default.ECDH__WRAPPED__KEY__MATERIAL__INDEX() + (long)_4_KeyLength)));
        DafnySequence _11_authTag = _1_wrappedMaterial.drop(Constants_Compile.__default.ECDH__WRAPPED__KEY__MATERIAL__INDEX() + (long)_4_KeyLength);
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _12_valueOrError2 = Result.Default(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), ValidUTF8Bytes.defaultValue());
        _12_valueOrError2 = UTF8.__default.Encode(__default.CurveSpecTypeToString(this.curveSpec())).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), __default::E);
        if (_12_valueOrError2.IsFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _12_valueOrError2.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()));
            return res;
        }
        DafnySequence<? extends Byte> _13_curveSpecUtf8 = _12_valueOrError2.Extract(ValidUTF8Bytes._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<DafnySequence, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _14_valueOrError3 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        _14_valueOrError3 = CanonicalEncryptionContext_Compile.__default.EncryptionContextToAAD(input.dtor_encryptionContext());
        if (_14_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _14_valueOrError3.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()));
            return res;
        }
        DafnySequence _15_canonicalizedEC = _14_valueOrError3.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence<? extends Byte> _16_fixedInfo = __default.SerializeFixedInfo(Constants_Compile.__default.ECDH__KDF__UTF8(), _13_curveSpecUtf8, this.senderPublicKey(), this.recipientPublicKey(), (DafnySequence<? extends Byte>)_15_canonicalizedEC, this.keyringVersion());
        Result<DafnySequence, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _17_valueOrError4 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out0 = __default.DeriveSharedKeyingMaterial(this.sharedSecret(), _16_fixedInfo, (DafnySequence<? extends Byte>)_6_kdfNonce, this.crypto());
        _17_valueOrError4 = _out0;
        if (_17_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _17_valueOrError4.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()));
            return res;
        }
        DafnySequence _18_derivedKeyingMaterial = _17_valueOrError4.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence _19_calculatedCommitmentKey = _18_derivedKeyingMaterial.take(32);
        DafnySequence _20_sharedKeyingMaterial = _18_derivedKeyingMaterial.drop(32);
        Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _21_valueOrError5 = Outcome.Default(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        _21_valueOrError5 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), (long)_19_calculatedCommitmentKey.cardinalityInt() == (long)_9_commitmentKey.cardinalityInt(), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Calculated commitment key length does NOT match expected commitment key length")));
        if (_21_valueOrError5.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _21_valueOrError5.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()));
            return res;
        }
        boolean _22_check_q = _out1 = this.commitmentKeyCheck((DafnySequence<? extends Byte>)_19_calculatedCommitmentKey, (DafnySequence<? extends Byte>)_9_commitmentKey);
        Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _23_valueOrError6 = Outcome.Default(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        _23_valueOrError6 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _22_check_q, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Commitment keys do not match")));
        if (_23_valueOrError6.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _23_valueOrError6.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()));
            return res;
        }
        Result<DafnySequence<? extends Byte>, Error> _24_maybeUnwrappedPdk = _out2 = this.crypto().AESDecrypt(AESDecryptInput.create(Constants_Compile.__default.ECDH__AES__256__ENC__ALG(), (DafnySequence<? extends Byte>)_20_sharedKeyingMaterial, (DafnySequence<? extends Byte>)_10_wrappedKey, (DafnySequence<? extends Byte>)_11_authTag, (DafnySequence<? extends Byte>)_7_iv, _16_fixedInfo));
        Result<DafnySequence, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _25_valueOrError7 = Result.Default(DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence.empty(uint8._typeDescriptor()));
        _25_valueOrError7 = _24_maybeUnwrappedPdk.MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _26_e_boxed0 -> {
            Error _26_e = _26_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_26_e);
        });
        if (_25_valueOrError7.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _25_valueOrError7.PropagateFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()));
            return res;
        }
        DafnySequence _27_unwrappedPdk = _25_valueOrError7.Extract((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Outcome<software.amazon.cryptography.materialproviders.internaldafny.types.Error> _28_valueOrError8 = Outcome.Default(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        _28_valueOrError8 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), (long)_27_unwrappedPdk.cardinalityInt() == (long)AlgorithmSuites_Compile.__default.GetEncryptKeyLength(input.dtor_algorithmSuite()), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Key Length")));
        if (_28_valueOrError8.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _28_valueOrError8.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()));
            return res;
        }
        UnwrapOutput<EcdhUnwrapInfo> _29_output = UnwrapOutput.create(EcdhUnwrapInfo._typeDescriptor(), (DafnySequence<? extends Byte>)_27_unwrappedPdk, EcdhUnwrapInfo.create());
        res = Result.create_Success(UnwrapOutput._typeDescriptor(EcdhUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _29_output);
        return res;
    }

    public boolean commitmentKeyCheck(DafnySequence<? extends Byte> calculatedCommitmentKey, DafnySequence<? extends Byte> serializedCommitmentKey) {
        boolean res = false;
        byte _0_diff_q = 0;
        long _hi0 = serializedCommitmentKey.cardinalityInt();
        long _1_i = 0L;
        while (Long.compareUnsigned(_1_i, _hi0) < 0) {
            _0_diff_q = (byte)(_0_diff_q | (byte)((Byte)calculatedCommitmentKey.select(Helpers.unsignedToInt((long)_1_i)) ^ (Byte)serializedCommitmentKey.select(Helpers.unsignedToInt((long)_1_i))));
            ++_1_i;
        }
        res = !(_0_diff_q != 0);
        return res;
    }

    public DafnySequence<? extends Byte> senderPublicKey() {
        return this._senderPublicKey;
    }

    public DafnySequence<? extends Byte> recipientPublicKey() {
        return this._recipientPublicKey;
    }

    public DafnySequence<? extends Byte> sharedSecret() {
        return this._sharedSecret;
    }

    public DafnySequence<? extends Byte> keyringVersion() {
        return this._keyringVersion;
    }

    public ECDHCurveSpec curveSpec() {
        return this._curveSpec;
    }

    public AtomicPrimitivesClient crypto() {
        return this._crypto;
    }

    public static TypeDescriptor<EcdhUnwrap> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "EcdhEdkWrapping.EcdhUnwrap";
    }
}

