/*
 * Decompiled with CFR 0.152.
 */
package KMSKeystoreOperations_Compile;

import AwsArnParsing_Compile.AwsArn;
import AwsArnParsing_Compile.AwsKmsIdentifier;
import Structure_Compile.BranchKeyContext;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.keystore.internaldafny.types.Discovery;
import software.amazon.cryptography.keystore.internaldafny.types.Error;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration_discovery;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration_kmsKeyArn;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration_kmsMRKeyArn;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration_mrDiscovery;
import software.amazon.cryptography.keystore.internaldafny.types.MRDiscovery;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue;
import software.amazon.cryptography.services.kms.internaldafny.types.DataKeySpec;
import software.amazon.cryptography.services.kms.internaldafny.types.DecryptRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.DecryptResponse;
import software.amazon.cryptography.services.kms.internaldafny.types.EncryptionAlgorithmSpec;
import software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyWithoutPlaintextRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyWithoutPlaintextResponse;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenList;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.cryptography.services.kms.internaldafny.types.KeyIdType;
import software.amazon.cryptography.services.kms.internaldafny.types.NumberOfBytesType;
import software.amazon.cryptography.services.kms.internaldafny.types.ReEncryptRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.ReEncryptResponse;
import software.amazon.cryptography.services.kms.internaldafny.types.RecipientInfo;
import software.amazon.cryptography.services.kms.internaldafny.types.RegionType;

public class __default {
    public static DafnySequence<? extends Character> replaceRegion(DafnySequence<? extends Character> arn, DafnySequence<? extends Character> region) {
        Result<AwsArn, DafnySequence<? extends Character>> _0_parsed = AwsArnParsing_Compile.__default.ParseAwsKmsArn(arn);
        if (_0_parsed.is_Failure()) {
            return arn;
        }
        if (!AwsArnParsing_Compile.__default.IsMultiRegionAwsKmsArn(_0_parsed.dtor_value())) {
            return arn;
        }
        DafnySequence<? extends Character> _1_newArn = _0_parsed.dtor_value().ToArnString(Option.create_Some(RegionType._typeDescriptor(), region));
        if (software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__KeyIdType(_1_newArn)) {
            return _1_newArn;
        }
        return arn;
    }

    public static DafnySequence<? extends Character> GetArn(KMSConfiguration kmsConfiguration, DafnySequence<? extends Character> discoverdArn) {
        MRDiscovery _6___mcc_h3;
        KMSConfiguration _source0 = kmsConfiguration;
        if (_source0.is_kmsKeyArn()) {
            DafnySequence<? extends Character> _0___mcc_h0;
            DafnySequence<? extends Character> _1_arn = _0___mcc_h0 = ((KMSConfiguration_kmsKeyArn)_source0)._kmsKeyArn;
            return _1_arn;
        }
        if (_source0.is_kmsMRKeyArn()) {
            DafnySequence<? extends Character> _2___mcc_h1;
            DafnySequence<? extends Character> _3_arn = _2___mcc_h1 = ((KMSConfiguration_kmsMRKeyArn)_source0)._kmsMRKeyArn;
            return _3_arn;
        }
        if (_source0.is_discovery()) {
            Discovery _4___mcc_h2;
            Discovery _5_obj = _4___mcc_h2 = ((KMSConfiguration_discovery)_source0)._discovery;
            return discoverdArn;
        }
        MRDiscovery _7_region = _6___mcc_h3 = ((KMSConfiguration_mrDiscovery)_source0)._mrDiscovery;
        return __default.replaceRegion(discoverdArn, _7_region.dtor_region());
    }

    public static boolean AttemptKmsOperation_q(KMSConfiguration kmsConfiguration, DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>> encryptionContext) {
        MRDiscovery _6___mcc_h3;
        KMSConfiguration _source0 = kmsConfiguration;
        if (_source0.is_kmsKeyArn()) {
            DafnySequence<? extends Character> _0___mcc_h0 = ((KMSConfiguration_kmsKeyArn)_source0)._kmsKeyArn;
            DafnySequence<? extends Character> _1_arn = _0___mcc_h0;
            return _1_arn.equals((Object)((DafnySequence)encryptionContext.get(Structure_Compile.__default.KMS__FIELD()))) && KmsArn_Compile.__default.ValidKmsArn_q(_1_arn);
        }
        if (_source0.is_kmsMRKeyArn()) {
            DafnySequence<? extends Character> _2___mcc_h1 = ((KMSConfiguration_kmsMRKeyArn)_source0)._kmsMRKeyArn;
            DafnySequence<? extends Character> _3_arn = _2___mcc_h1;
            return __default.MrkMatch(_3_arn, (DafnySequence<? extends Character>)((DafnySequence)encryptionContext.get(Structure_Compile.__default.KMS__FIELD()))) && KmsArn_Compile.__default.ValidKmsArn_q(_3_arn);
        }
        if (_source0.is_discovery()) {
            Discovery _4___mcc_h2;
            Discovery _5_obj = _4___mcc_h2 = ((KMSConfiguration_discovery)_source0)._discovery;
            return KmsArn_Compile.__default.ValidKmsArn_q((DafnySequence<? extends Character>)((DafnySequence)encryptionContext.get(Structure_Compile.__default.KMS__FIELD())));
        }
        MRDiscovery _7_obj = _6___mcc_h3 = ((KMSConfiguration_mrDiscovery)_source0)._mrDiscovery;
        return KmsArn_Compile.__default.ValidKmsArn_q((DafnySequence<? extends Character>)((DafnySequence)encryptionContext.get(Structure_Compile.__default.KMS__FIELD())));
    }

    public static boolean Compatible_q(KMSConfiguration kmsConfiguration, DafnySequence<? extends Character> keyId) {
        DafnySequence<? extends Character> _2___mcc_h1;
        KMSConfiguration _source0 = kmsConfiguration;
        if (_source0.is_kmsKeyArn()) {
            DafnySequence<? extends Character> _0___mcc_h0;
            DafnySequence<? extends Character> _1_arn = _0___mcc_h0 = ((KMSConfiguration_kmsKeyArn)_source0)._kmsKeyArn;
            return _1_arn.equals(keyId);
        }
        DafnySequence<? extends Character> _3_arn = _2___mcc_h1 = ((KMSConfiguration_kmsMRKeyArn)_source0)._kmsMRKeyArn;
        return __default.MrkMatch(_3_arn, keyId);
    }

    public static boolean OptCompatible_q(KMSConfiguration kmsConfiguration, Option<DafnySequence<? extends Character>> keyId) {
        return keyId.is_Some() && __default.Compatible_q(kmsConfiguration, keyId.dtor_value());
    }

    public static boolean MrkMatch(DafnySequence<? extends Character> x, DafnySequence<? extends Character> y) {
        Result<AwsArn, DafnySequence<? extends Character>> _0_xArn = AwsArnParsing_Compile.__default.ParseAwsKmsArn(x);
        Result<AwsArn, DafnySequence<? extends Character>> _1_yArn = AwsArnParsing_Compile.__default.ParseAwsKmsArn(y);
        if (_0_xArn.is_Failure() || _1_yArn.is_Failure()) {
            return false;
        }
        return AwsKmsMrkMatchForDecrypt_Compile.__default.AwsKmsMrkMatchForDecrypt(AwsKmsIdentifier.create_AwsKmsArnIdentifier(_0_xArn.dtor_value()), AwsKmsIdentifier.create_AwsKmsArnIdentifier(_1_yArn.dtor_value()));
    }

    public static boolean HasKeyId(KMSConfiguration kmsConfiguration) {
        return kmsConfiguration.is_kmsKeyArn() || kmsConfiguration.is_kmsMRKeyArn();
    }

    public static DafnySequence<? extends Character> GetKeyId(KMSConfiguration kmsConfiguration) {
        DafnySequence<? extends Character> _2___mcc_h1;
        KMSConfiguration _source0 = kmsConfiguration;
        if (_source0.is_kmsKeyArn()) {
            DafnySequence<? extends Character> _0___mcc_h0;
            DafnySequence<? extends Character> _1_arn = _0___mcc_h0 = ((KMSConfiguration_kmsKeyArn)_source0)._kmsKeyArn;
            return _1_arn;
        }
        DafnySequence<? extends Character> _3_arn = _2___mcc_h1 = ((KMSConfiguration_kmsMRKeyArn)_source0)._kmsMRKeyArn;
        return _3_arn;
    }

    public static Result<GenerateDataKeyWithoutPlaintextResponse, Error> GenerateKey(DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>> encryptionContext, KMSConfiguration kmsConfiguration, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens, IKMSClient kmsClient) {
        Result<GenerateDataKeyWithoutPlaintextResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out0;
        Result<GenerateDataKeyWithoutPlaintextResponse, Error> res = Result.Default(GenerateDataKeyWithoutPlaintextResponse._typeDescriptor(), Error._typeDescriptor(), GenerateDataKeyWithoutPlaintextResponse.Default());
        DafnySequence<? extends Character> _0_kmsKeyArn = __default.GetKeyId(kmsConfiguration);
        GenerateDataKeyWithoutPlaintextRequest _1_generatorRequest = GenerateDataKeyWithoutPlaintextRequest.create(_0_kmsKeyArn, Option.create_Some(BranchKeyContext._typeDescriptor(), encryptionContext), Option.create_None(DataKeySpec._typeDescriptor()), Option.create_Some(NumberOfBytesType._typeDescriptor(), 32), Option.create_Some(GrantTokenList._typeDescriptor(), grantTokens), Option.create_None(TypeDescriptor.BOOLEAN));
        Result<GenerateDataKeyWithoutPlaintextResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _2_maybeGenerateResponse = _out0 = kmsClient.GenerateDataKeyWithoutPlaintext(_1_generatorRequest);
        Result<GenerateDataKeyWithoutPlaintextResponse, Error> _3_valueOrError0 = Result.Default(GenerateDataKeyWithoutPlaintextResponse._typeDescriptor(), Error._typeDescriptor(), GenerateDataKeyWithoutPlaintextResponse.Default());
        _3_valueOrError0 = _2_maybeGenerateResponse.MapFailure(GenerateDataKeyWithoutPlaintextResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _4_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _4_e = _4_e_boxed0;
            return Error.create_ComAmazonawsKms(_4_e);
        });
        if (_3_valueOrError0.IsFailure(GenerateDataKeyWithoutPlaintextResponse._typeDescriptor(), Error._typeDescriptor())) {
            res = _3_valueOrError0.PropagateFailure(GenerateDataKeyWithoutPlaintextResponse._typeDescriptor(), Error._typeDescriptor(), GenerateDataKeyWithoutPlaintextResponse._typeDescriptor());
            return res;
        }
        GenerateDataKeyWithoutPlaintextResponse _5_generateResponse = _3_valueOrError0.Extract(GenerateDataKeyWithoutPlaintextResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _6_valueOrError1 = Outcome.Default(Error._typeDescriptor());
        _6_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _5_generateResponse.dtor_KeyId().is_Some(), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from KMS GenerateDataKey:: Invalid Key Id")));
        if (_6_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _6_valueOrError1.PropagateFailure(Error._typeDescriptor(), GenerateDataKeyWithoutPlaintextResponse._typeDescriptor());
            return res;
        }
        Outcome<Error> _7_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _7_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _5_generateResponse.dtor_CiphertextBlob().is_Some() && software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__CiphertextType(_5_generateResponse.dtor_CiphertextBlob().dtor_value()), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS GenerateDataKey: Invalid ciphertext")));
        if (_7_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _7_valueOrError2.PropagateFailure(Error._typeDescriptor(), GenerateDataKeyWithoutPlaintextResponse._typeDescriptor());
            return res;
        }
        res = Result.create_Success(GenerateDataKeyWithoutPlaintextResponse._typeDescriptor(), Error._typeDescriptor(), _5_generateResponse);
        return res;
    }

    public static Result<ReEncryptResponse, Error> ReEncryptKey(DafnySequence<? extends Byte> ciphertext, DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>> sourceEncryptionContext, DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>> destinationEncryptionContext, KMSConfiguration kmsConfiguration, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens, IKMSClient kmsClient) {
        Result<ReEncryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out0;
        Result<ReEncryptResponse, Error> res = Result.Default(ReEncryptResponse._typeDescriptor(), Error._typeDescriptor(), ReEncryptResponse.Default());
        DafnySequence<? extends Character> _0_kmsKeyArn = __default.GetKeyId(kmsConfiguration);
        ReEncryptRequest _1_reEncryptRequest = ReEncryptRequest.create(ciphertext, Option.create_Some(BranchKeyContext._typeDescriptor(), sourceEncryptionContext), Option.create_Some(KeyIdType._typeDescriptor(), _0_kmsKeyArn), _0_kmsKeyArn, Option.create_Some(BranchKeyContext._typeDescriptor(), destinationEncryptionContext), Option.create_None(EncryptionAlgorithmSpec._typeDescriptor()), Option.create_None(EncryptionAlgorithmSpec._typeDescriptor()), Option.create_Some(GrantTokenList._typeDescriptor(), grantTokens), Option.create_None(TypeDescriptor.BOOLEAN));
        Result<ReEncryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _2_maybeReEncryptResponse = _out0 = kmsClient.ReEncrypt(_1_reEncryptRequest);
        Result<ReEncryptResponse, Error> _3_valueOrError0 = Result.Default(ReEncryptResponse._typeDescriptor(), Error._typeDescriptor(), ReEncryptResponse.Default());
        _3_valueOrError0 = _2_maybeReEncryptResponse.MapFailure(ReEncryptResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _4_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _4_e = _4_e_boxed0;
            return Error.create_ComAmazonawsKms(_4_e);
        });
        if (_3_valueOrError0.IsFailure(ReEncryptResponse._typeDescriptor(), Error._typeDescriptor())) {
            res = _3_valueOrError0.PropagateFailure(ReEncryptResponse._typeDescriptor(), Error._typeDescriptor(), ReEncryptResponse._typeDescriptor());
            return res;
        }
        ReEncryptResponse _5_reEncryptResponse = _3_valueOrError0.Extract(ReEncryptResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _6_valueOrError1 = Outcome.Default(Error._typeDescriptor());
        _6_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _5_reEncryptResponse.dtor_SourceKeyId().is_Some() && _5_reEncryptResponse.dtor_KeyId().is_Some() && _5_reEncryptResponse.dtor_SourceKeyId().dtor_value().equals(_0_kmsKeyArn) && _5_reEncryptResponse.dtor_KeyId().dtor_value().equals(_0_kmsKeyArn), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from KMS ReEncrypt:: Invalid Key Id")));
        if (_6_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _6_valueOrError1.PropagateFailure(Error._typeDescriptor(), ReEncryptResponse._typeDescriptor());
            return res;
        }
        Outcome<Error> _7_valueOrError2 = Outcome.Default(Error._typeDescriptor());
        _7_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _5_reEncryptResponse.dtor_CiphertextBlob().is_Some() && software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__CiphertextType(_5_reEncryptResponse.dtor_CiphertextBlob().dtor_value()), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS ReEncrypt: Invalid ciphertext.")));
        if (_7_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _7_valueOrError2.PropagateFailure(Error._typeDescriptor(), ReEncryptResponse._typeDescriptor());
            return res;
        }
        res = Result.create_Success(ReEncryptResponse._typeDescriptor(), Error._typeDescriptor(), _5_reEncryptResponse);
        return res;
    }

    public static Result<DecryptResponse, Error> DecryptKey(DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>> encryptionContext, DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> item, KMSConfiguration kmsConfiguration, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens, IKMSClient kmsClient) {
        Result<DecryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out0;
        Result<DecryptResponse, Error> output = Result.Default(DecryptResponse._typeDescriptor(), Error._typeDescriptor(), DecryptResponse.Default());
        DafnySequence<? extends Character> _0_kmsKeyArn = __default.GetArn(kmsConfiguration, (DafnySequence<? extends Character>)((DafnySequence)encryptionContext.get(Structure_Compile.__default.KMS__FIELD())));
        Result<DecryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _1_maybeDecryptResponse = _out0 = kmsClient.Decrypt(DecryptRequest.create(((AttributeValue)item.get(Structure_Compile.__default.BRANCH__KEY__FIELD())).dtor_B(), Option.create_Some(BranchKeyContext._typeDescriptor(), encryptionContext), Option.create_Some(GrantTokenList._typeDescriptor(), grantTokens), Option.create_Some(KeyIdType._typeDescriptor(), _0_kmsKeyArn), Option.create_None(EncryptionAlgorithmSpec._typeDescriptor()), Option.create_None(RecipientInfo._typeDescriptor()), Option.create_None(TypeDescriptor.BOOLEAN)));
        Result<DecryptResponse, Error> _2_valueOrError0 = Result.Default(DecryptResponse._typeDescriptor(), Error._typeDescriptor(), DecryptResponse.Default());
        _2_valueOrError0 = _1_maybeDecryptResponse.MapFailure(DecryptResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _3_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _3_e = _3_e_boxed0;
            return Error.create_ComAmazonawsKms(_3_e);
        });
        if (_2_valueOrError0.IsFailure(DecryptResponse._typeDescriptor(), Error._typeDescriptor())) {
            output = _2_valueOrError0.PropagateFailure(DecryptResponse._typeDescriptor(), Error._typeDescriptor(), DecryptResponse._typeDescriptor());
            return output;
        }
        DecryptResponse _4_decryptResponse = _2_valueOrError0.Extract(DecryptResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Error> _5_valueOrError1 = Outcome.Default(Error._typeDescriptor());
        _5_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _4_decryptResponse.dtor_Plaintext().is_Some() && 32L == (long)_4_decryptResponse.dtor_Plaintext().dtor_value().cardinalityInt(), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS Decrypt: Key is not 32 bytes.")));
        if (_5_valueOrError1.IsFailure(Error._typeDescriptor())) {
            output = _5_valueOrError1.PropagateFailure(Error._typeDescriptor(), DecryptResponse._typeDescriptor());
            return output;
        }
        output = Result.create_Success(DecryptResponse._typeDescriptor(), Error._typeDescriptor(), _4_decryptResponse);
        return output;
    }

    public String toString() {
        return "KMSKeystoreOperations._default";
    }
}

