/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders;

import Wrappers_Compile.Result;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.IKeyring;
import software.amazon.cryptography.materialproviders.ToDafny;
import software.amazon.cryptography.materialproviders.ToNative;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.model.OnDecryptInput;
import software.amazon.cryptography.materialproviders.model.OnDecryptOutput;

public final class Keyring
implements IKeyring {
    private final software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring _impl;

    private Keyring(software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring iKeyring) {
        Objects.requireNonNull(iKeyring, "Missing value for required argument `iKeyring`");
        this._impl = iKeyring;
    }

    public static Keyring wrap(software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring iKeyring) {
        return new Keyring(iKeyring);
    }

    public static <I extends IKeyring> Keyring wrap(I iKeyring) {
        Objects.requireNonNull(iKeyring, "Missing value for required argument `iKeyring`");
        if (iKeyring instanceof Keyring) {
            return (Keyring)iKeyring;
        }
        return Keyring.wrap(new NativeWrapper(iKeyring));
    }

    public software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring impl() {
        return this._impl;
    }

    @Override
    public OnDecryptOutput OnDecrypt(OnDecryptInput input) {
        software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput dafnyValue = ToDafny.OnDecryptInput(input);
        Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, Error> result = this._impl.OnDecrypt(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.OnDecryptOutput(result.dtor_value());
    }

    @Override
    public software.amazon.cryptography.materialproviders.model.OnEncryptOutput OnEncrypt(software.amazon.cryptography.materialproviders.model.OnEncryptInput input) {
        OnEncryptInput dafnyValue = ToDafny.OnEncryptInput(input);
        Result<OnEncryptOutput, Error> result = this._impl.OnEncrypt(dafnyValue);
        if (result.is_Failure()) {
            throw ToNative.Error(result.dtor_error());
        }
        return ToNative.OnEncryptOutput(result.dtor_value());
    }

    protected static final class NativeWrapper
    implements software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring {
        protected final IKeyring _impl;

        NativeWrapper(IKeyring nativeImpl) {
            if (nativeImpl instanceof Keyring) {
                throw new IllegalArgumentException("Recursive wrapping is strictly forbidden.");
            }
            this._impl = nativeImpl;
        }

        @Override
        public Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, Error> OnDecrypt(software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput dafnyInput) {
            try {
                OnDecryptInput nativeInput = ToNative.OnDecryptInput(dafnyInput);
                OnDecryptOutput nativeOutput = this._impl.OnDecrypt(nativeInput);
                software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput dafnyOutput = ToDafny.OnDecryptOutput(nativeOutput);
                return Result.create_Success(software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), dafnyOutput);
            }
            catch (RuntimeException ex) {
                return Result.create_Failure(software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput._typeDescriptor(), Error._typeDescriptor(), ToDafny.Error(ex));
            }
        }

        @Override
        public Result<software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput, Error> OnDecrypt_k(software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput dafnyInput) {
            throw new RuntimeException("Not supported at this time.");
        }

        @Override
        public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput dafnyInput) {
            try {
                software.amazon.cryptography.materialproviders.model.OnEncryptInput nativeInput = ToNative.OnEncryptInput(dafnyInput);
                software.amazon.cryptography.materialproviders.model.OnEncryptOutput nativeOutput = this._impl.OnEncrypt(nativeInput);
                OnEncryptOutput dafnyOutput = ToDafny.OnEncryptOutput(nativeOutput);
                return Result.create_Success(OnEncryptOutput._typeDescriptor(), Error._typeDescriptor(), dafnyOutput);
            }
            catch (RuntimeException ex) {
                return Result.create_Failure(OnEncryptOutput._typeDescriptor(), Error._typeDescriptor(), ToDafny.Error(ex));
            }
        }

        @Override
        public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput dafnyInput) {
            throw new RuntimeException("Not supported at this time.");
        }
    }
}

