/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.CryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.model.DefaultCache;
import software.amazon.cryptography.materialproviders.model.MultiThreadedCache;
import software.amazon.cryptography.materialproviders.model.NoCache;
import software.amazon.cryptography.materialproviders.model.SingleThreadedCache;
import software.amazon.cryptography.materialproviders.model.StormTrackingCache;

public class CacheType {
    private final DefaultCache Default;
    private final NoCache No;
    private final SingleThreadedCache SingleThreaded;
    private final MultiThreadedCache MultiThreaded;
    private final StormTrackingCache StormTracking;
    private final ICryptographicMaterialsCache Shared;

    protected CacheType(BuilderImpl builder) {
        this.Default = builder.Default();
        this.No = builder.No();
        this.SingleThreaded = builder.SingleThreaded();
        this.MultiThreaded = builder.MultiThreaded();
        this.StormTracking = builder.StormTracking();
        this.Shared = builder.Shared();
    }

    public DefaultCache Default() {
        return this.Default;
    }

    public NoCache No() {
        return this.No;
    }

    public SingleThreadedCache SingleThreaded() {
        return this.SingleThreaded;
    }

    public MultiThreadedCache MultiThreaded() {
        return this.MultiThreaded;
    }

    public StormTrackingCache StormTracking() {
        return this.StormTracking;
    }

    public ICryptographicMaterialsCache Shared() {
        return this.Shared;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected DefaultCache Default;
        protected NoCache No;
        protected SingleThreadedCache SingleThreaded;
        protected MultiThreadedCache MultiThreaded;
        protected StormTrackingCache StormTracking;
        protected ICryptographicMaterialsCache Shared;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CacheType model) {
            this.Default = model.Default();
            this.No = model.No();
            this.SingleThreaded = model.SingleThreaded();
            this.MultiThreaded = model.MultiThreaded();
            this.StormTracking = model.StormTracking();
            this.Shared = model.Shared();
        }

        @Override
        public Builder Default(DefaultCache Default) {
            this.Default = Default;
            return this;
        }

        @Override
        public DefaultCache Default() {
            return this.Default;
        }

        @Override
        public Builder No(NoCache No) {
            this.No = No;
            return this;
        }

        @Override
        public NoCache No() {
            return this.No;
        }

        @Override
        public Builder SingleThreaded(SingleThreadedCache SingleThreaded) {
            this.SingleThreaded = SingleThreaded;
            return this;
        }

        @Override
        public SingleThreadedCache SingleThreaded() {
            return this.SingleThreaded;
        }

        @Override
        public Builder MultiThreaded(MultiThreadedCache MultiThreaded) {
            this.MultiThreaded = MultiThreaded;
            return this;
        }

        @Override
        public MultiThreadedCache MultiThreaded() {
            return this.MultiThreaded;
        }

        @Override
        public Builder StormTracking(StormTrackingCache StormTracking) {
            this.StormTracking = StormTracking;
            return this;
        }

        @Override
        public StormTrackingCache StormTracking() {
            return this.StormTracking;
        }

        @Override
        public Builder Shared(ICryptographicMaterialsCache Shared) {
            this.Shared = CryptographicMaterialsCache.wrap(Shared);
            return this;
        }

        @Override
        public ICryptographicMaterialsCache Shared() {
            return this.Shared;
        }

        @Override
        public CacheType build() {
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`CacheType` is a Union. A Union MUST have one and only one value set.");
            }
            return new CacheType(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.Default, this.No, this.SingleThreaded, this.MultiThreaded, this.StormTracking, this.Shared};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder Default(DefaultCache var1);

        public DefaultCache Default();

        public Builder No(NoCache var1);

        public NoCache No();

        public Builder SingleThreaded(SingleThreadedCache var1);

        public SingleThreadedCache SingleThreaded();

        public Builder MultiThreaded(MultiThreadedCache var1);

        public MultiThreadedCache MultiThreaded();

        public Builder StormTracking(StormTrackingCache var1);

        public StormTrackingCache StormTracking();

        public Builder Shared(ICryptographicMaterialsCache var1);

        public ICryptographicMaterialsCache Shared();

        public CacheType build();
    }
}

