/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.cryptography.materialproviders.model.DiscoveryFilter;

public class CreateAwsKmsDiscoveryKeyringInput {
    private final KmsClient kmsClient;
    private final DiscoveryFilter discoveryFilter;
    private final List<String> grantTokens;

    protected CreateAwsKmsDiscoveryKeyringInput(BuilderImpl builder) {
        this.kmsClient = builder.kmsClient();
        this.discoveryFilter = builder.discoveryFilter();
        this.grantTokens = builder.grantTokens();
    }

    public KmsClient kmsClient() {
        return this.kmsClient;
    }

    public DiscoveryFilter discoveryFilter() {
        return this.discoveryFilter;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected KmsClient kmsClient;
        protected DiscoveryFilter discoveryFilter;
        protected List<String> grantTokens;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CreateAwsKmsDiscoveryKeyringInput model) {
            this.kmsClient = model.kmsClient();
            this.discoveryFilter = model.discoveryFilter();
            this.grantTokens = model.grantTokens();
        }

        @Override
        public Builder kmsClient(KmsClient kmsClient) {
            this.kmsClient = kmsClient;
            return this;
        }

        @Override
        public KmsClient kmsClient() {
            return this.kmsClient;
        }

        @Override
        public Builder discoveryFilter(DiscoveryFilter discoveryFilter) {
            this.discoveryFilter = discoveryFilter;
            return this;
        }

        @Override
        public DiscoveryFilter discoveryFilter() {
            return this.discoveryFilter;
        }

        @Override
        public Builder grantTokens(List<String> grantTokens) {
            this.grantTokens = grantTokens;
            return this;
        }

        @Override
        public List<String> grantTokens() {
            return this.grantTokens;
        }

        @Override
        public CreateAwsKmsDiscoveryKeyringInput build() {
            if (Objects.isNull(this.kmsClient())) {
                throw new IllegalArgumentException("Missing value for required field `kmsClient`");
            }
            return new CreateAwsKmsDiscoveryKeyringInput(this);
        }
    }

    public static interface Builder {
        public Builder kmsClient(KmsClient var1);

        public KmsClient kmsClient();

        public Builder discoveryFilter(DiscoveryFilter var1);

        public DiscoveryFilter discoveryFilter();

        public Builder grantTokens(List<String> var1);

        public List<String> grantTokens();

        public CreateAwsKmsDiscoveryKeyringInput build();
    }
}

