/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.AesWrappingAlg;

public class CreateRawAesKeyringInput {
    private final String keyNamespace;
    private final String keyName;
    private final ByteBuffer wrappingKey;
    private final AesWrappingAlg wrappingAlg;

    protected CreateRawAesKeyringInput(BuilderImpl builder) {
        this.keyNamespace = builder.keyNamespace();
        this.keyName = builder.keyName();
        this.wrappingKey = builder.wrappingKey();
        this.wrappingAlg = builder.wrappingAlg();
    }

    public String keyNamespace() {
        return this.keyNamespace;
    }

    public String keyName() {
        return this.keyName;
    }

    public ByteBuffer wrappingKey() {
        return this.wrappingKey;
    }

    public AesWrappingAlg wrappingAlg() {
        return this.wrappingAlg;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String keyNamespace;
        protected String keyName;
        protected ByteBuffer wrappingKey;
        protected AesWrappingAlg wrappingAlg;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CreateRawAesKeyringInput model) {
            this.keyNamespace = model.keyNamespace();
            this.keyName = model.keyName();
            this.wrappingKey = model.wrappingKey();
            this.wrappingAlg = model.wrappingAlg();
        }

        @Override
        public Builder keyNamespace(String keyNamespace) {
            this.keyNamespace = keyNamespace;
            return this;
        }

        @Override
        public String keyNamespace() {
            return this.keyNamespace;
        }

        @Override
        public Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        @Override
        public String keyName() {
            return this.keyName;
        }

        @Override
        public Builder wrappingKey(ByteBuffer wrappingKey) {
            this.wrappingKey = wrappingKey;
            return this;
        }

        @Override
        public ByteBuffer wrappingKey() {
            return this.wrappingKey;
        }

        @Override
        public Builder wrappingAlg(AesWrappingAlg wrappingAlg) {
            this.wrappingAlg = wrappingAlg;
            return this;
        }

        @Override
        public AesWrappingAlg wrappingAlg() {
            return this.wrappingAlg;
        }

        @Override
        public CreateRawAesKeyringInput build() {
            if (Objects.isNull(this.keyNamespace())) {
                throw new IllegalArgumentException("Missing value for required field `keyNamespace`");
            }
            if (Objects.isNull(this.keyName())) {
                throw new IllegalArgumentException("Missing value for required field `keyName`");
            }
            if (Objects.isNull(this.wrappingKey())) {
                throw new IllegalArgumentException("Missing value for required field `wrappingKey`");
            }
            if (Objects.isNull((Object)this.wrappingAlg())) {
                throw new IllegalArgumentException("Missing value for required field `wrappingAlg`");
            }
            return new CreateRawAesKeyringInput(this);
        }
    }

    public static interface Builder {
        public Builder keyNamespace(String var1);

        public String keyNamespace();

        public Builder keyName(String var1);

        public String keyName();

        public Builder wrappingKey(ByteBuffer var1);

        public ByteBuffer wrappingKey();

        public Builder wrappingAlg(AesWrappingAlg var1);

        public AesWrappingAlg wrappingAlg();

        public CreateRawAesKeyringInput build();
    }
}

