/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.EncryptionMaterials;

public class ValidEncryptionMaterialsTransitionInput {
    private final EncryptionMaterials start;
    private final EncryptionMaterials stop;

    protected ValidEncryptionMaterialsTransitionInput(BuilderImpl builder) {
        this.start = builder.start();
        this.stop = builder.stop();
    }

    public EncryptionMaterials start() {
        return this.start;
    }

    public EncryptionMaterials stop() {
        return this.stop;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected EncryptionMaterials start;
        protected EncryptionMaterials stop;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ValidEncryptionMaterialsTransitionInput model) {
            this.start = model.start();
            this.stop = model.stop();
        }

        @Override
        public Builder start(EncryptionMaterials start) {
            this.start = start;
            return this;
        }

        @Override
        public EncryptionMaterials start() {
            return this.start;
        }

        @Override
        public Builder stop(EncryptionMaterials stop) {
            this.stop = stop;
            return this;
        }

        @Override
        public EncryptionMaterials stop() {
            return this.stop;
        }

        @Override
        public ValidEncryptionMaterialsTransitionInput build() {
            if (Objects.isNull(this.start())) {
                throw new IllegalArgumentException("Missing value for required field `start`");
            }
            if (Objects.isNull(this.stop())) {
                throw new IllegalArgumentException("Missing value for required field `stop`");
            }
            return new ValidEncryptionMaterialsTransitionInput(this);
        }
    }

    public static interface Builder {
        public Builder start(EncryptionMaterials var1);

        public EncryptionMaterials start();

        public Builder stop(EncryptionMaterials var1);

        public EncryptionMaterials stop();

        public ValidEncryptionMaterialsTransitionInput build();
    }
}

