/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.internaldafny.types;

import BoundedInts_Compile.uint8;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm;

public class ECDSASignInput {
    public ECDSASignatureAlgorithm _signatureAlgorithm;
    public DafnySequence<? extends Byte> _signingKey;
    public DafnySequence<? extends Byte> _message;
    private static final TypeDescriptor<ECDSASignInput> _TYPE = TypeDescriptor.referenceWithInitializer(ECDSASignInput.class, () -> ECDSASignInput.Default());
    private static final ECDSASignInput theDefault = ECDSASignInput.create(ECDSASignatureAlgorithm.Default(), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));

    public ECDSASignInput(ECDSASignatureAlgorithm signatureAlgorithm, DafnySequence<? extends Byte> signingKey, DafnySequence<? extends Byte> message) {
        this._signatureAlgorithm = signatureAlgorithm;
        this._signingKey = signingKey;
        this._message = message;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ECDSASignInput o = (ECDSASignInput)other;
        return Objects.equals(this._signatureAlgorithm, o._signatureAlgorithm) && Objects.equals(this._signingKey, o._signingKey) && Objects.equals(this._message, o._message);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._signatureAlgorithm);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._signingKey);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._message);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyPrimitivesTypes.ECDSASignInput.ECDSASignInput");
        s.append("(");
        s.append(Helpers.toString((Object)this._signatureAlgorithm));
        s.append(", ");
        s.append(Helpers.toString(this._signingKey));
        s.append(", ");
        s.append(Helpers.toString(this._message));
        s.append(")");
        return s.toString();
    }

    public static TypeDescriptor<ECDSASignInput> _typeDescriptor() {
        return _TYPE;
    }

    public static ECDSASignInput Default() {
        return theDefault;
    }

    public static ECDSASignInput create(ECDSASignatureAlgorithm signatureAlgorithm, DafnySequence<? extends Byte> signingKey, DafnySequence<? extends Byte> message) {
        return new ECDSASignInput(signatureAlgorithm, signingKey, message);
    }

    public static ECDSASignInput create_ECDSASignInput(ECDSASignatureAlgorithm signatureAlgorithm, DafnySequence<? extends Byte> signingKey, DafnySequence<? extends Byte> message) {
        return ECDSASignInput.create(signatureAlgorithm, signingKey, message);
    }

    public boolean is_ECDSASignInput() {
        return true;
    }

    public ECDSASignatureAlgorithm dtor_signatureAlgorithm() {
        return this._signatureAlgorithm;
    }

    public DafnySequence<? extends Byte> dtor_signingKey() {
        return this._signingKey;
    }

    public DafnySequence<? extends Byte> dtor_message() {
        return this._message;
    }
}

