/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.primitives.model.DigestAlgorithm;

public class HMacInput {
    private final DigestAlgorithm digestAlgorithm;
    private final ByteBuffer key;
    private final ByteBuffer message;

    protected HMacInput(BuilderImpl builder) {
        this.digestAlgorithm = builder.digestAlgorithm();
        this.key = builder.key();
        this.message = builder.message();
    }

    public DigestAlgorithm digestAlgorithm() {
        return this.digestAlgorithm;
    }

    public ByteBuffer key() {
        return this.key;
    }

    public ByteBuffer message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected DigestAlgorithm digestAlgorithm;
        protected ByteBuffer key;
        protected ByteBuffer message;

        protected BuilderImpl() {
        }

        protected BuilderImpl(HMacInput model) {
            this.digestAlgorithm = model.digestAlgorithm();
            this.key = model.key();
            this.message = model.message();
        }

        @Override
        public Builder digestAlgorithm(DigestAlgorithm digestAlgorithm) {
            this.digestAlgorithm = digestAlgorithm;
            return this;
        }

        @Override
        public DigestAlgorithm digestAlgorithm() {
            return this.digestAlgorithm;
        }

        @Override
        public Builder key(ByteBuffer key) {
            this.key = key;
            return this;
        }

        @Override
        public ByteBuffer key() {
            return this.key;
        }

        @Override
        public Builder message(ByteBuffer message) {
            this.message = message;
            return this;
        }

        @Override
        public ByteBuffer message() {
            return this.message;
        }

        @Override
        public HMacInput build() {
            if (Objects.isNull((Object)this.digestAlgorithm())) {
                throw new IllegalArgumentException("Missing value for required field `digestAlgorithm`");
            }
            if (Objects.isNull(this.key())) {
                throw new IllegalArgumentException("Missing value for required field `key`");
            }
            if (Objects.isNull(this.message())) {
                throw new IllegalArgumentException("Missing value for required field `message`");
            }
            return new HMacInput(this);
        }
    }

    public static interface Builder {
        public Builder digestAlgorithm(DigestAlgorithm var1);

        public DigestAlgorithm digestAlgorithm();

        public Builder key(ByteBuffer var1);

        public ByteBuffer key();

        public Builder message(ByteBuffer var1);

        public ByteBuffer message();

        public HMacInput build();
    }
}

