/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.util.Objects;
import software.amazon.cryptography.primitives.model.ECCPublicKey;

public class ParsePublicKeyOutput {
    private final ECCPublicKey publicKey;

    protected ParsePublicKeyOutput(BuilderImpl builder) {
        this.publicKey = builder.publicKey();
    }

    public ECCPublicKey publicKey() {
        return this.publicKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ECCPublicKey publicKey;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ParsePublicKeyOutput model) {
            this.publicKey = model.publicKey();
        }

        @Override
        public Builder publicKey(ECCPublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Override
        public ECCPublicKey publicKey() {
            return this.publicKey;
        }

        @Override
        public ParsePublicKeyOutput build() {
            if (Objects.isNull(this.publicKey())) {
                throw new IllegalArgumentException("Missing value for required field `publicKey`");
            }
            return new ParsePublicKeyOutput(this);
        }
    }

    public static interface Builder {
        public Builder publicKey(ECCPublicKey var1);

        public ECCPublicKey publicKey();

        public ParsePublicKeyOutput build();
    }
}

