/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.ml;

import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.EncodingType;
import com.knuddels.jtokkit.api.IntArrayList;
import com.knuddels.jtokkit.api.ModelType;
import java.util.ArrayList;
import java.util.List;

public class TokenizerUtil {
    private static final EncodingRegistry registry = Encodings.newDefaultEncodingRegistry();
    private static final Encoding encoding = registry.getEncoding(EncodingType.CL100K_BASE);

    public static int countTokens(String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        return encoding.countTokens(text);
    }

    public static int countTokens(String text, ModelType modelType) {
        return registry.getEncodingForModel(modelType).countTokens(text);
    }

    public static String truncateString(String text, int tokenLimit) {
        IntArrayList tokens = encoding.encode(text);
        if (tokens.size() <= tokenLimit) {
            return text;
        }
        ArrayList<Integer> tokenList = new ArrayList<Integer>();
        for (int i = 0; i < tokens.size(); ++i) {
            tokenList.add(tokens.get(i));
        }
        return TokenizerUtil.decode(tokenList.subList(0, tokenLimit));
    }

    private static String decode(List<Integer> tokens) {
        IntArrayList intArrayList = new IntArrayList();
        for (Integer token : tokens) {
            intArrayList.add(token.intValue());
        }
        return encoding.decode(intArrayList);
    }
}

