/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.searchrelevance.settings.SearchRelevanceSettingsAccessor;
import org.opensearch.searchrelevance.transport.searchConfiguration.PutSearchConfigurationAction;
import org.opensearch.searchrelevance.transport.searchConfiguration.PutSearchConfigurationRequest;
import org.opensearch.searchrelevance.utils.TextValidationUtil;
import org.opensearch.transport.client.node.NodeClient;

public class RestPutSearchConfigurationAction
extends BaseRestHandler {
    private static final Logger LOGGER = LogManager.getLogger(RestPutSearchConfigurationAction.class);
    private static final String PUT_SEARCH_CONFIGURATION_ACTION = "put_search_configuration_action";
    private SearchRelevanceSettingsAccessor settingsAccessor;

    public String getName() {
        return PUT_SEARCH_CONFIGURATION_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_search_relevance/search_configurations"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.settingsAccessor.isWorkbenchEnabled()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, "Search Relevance Workbench is disabled"));
        }
        XContentParser parser = request.contentParser();
        Map source = parser.map();
        String name = (String)source.get("name");
        TextValidationUtil.ValidationResult nameValidation = TextValidationUtil.validateName(name);
        if (!nameValidation.isValid()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "Invalid name: " + nameValidation.getErrorMessage()));
        }
        String index = (String)source.get("index");
        String queryBody = (String)source.get("query");
        String searchPipeline = source.getOrDefault("searchPipeline", "");
        PutSearchConfigurationRequest createRequest = new PutSearchConfigurationRequest(name, index, queryBody, searchPipeline);
        return channel -> client.execute((ActionType)PutSearchConfigurationAction.INSTANCE, (ActionRequest)createRequest, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse response) {
                try {
                    XContentBuilder builder = channel.newBuilder();
                    builder.startObject();
                    builder.field("search_configuration_id", response.getId());
                    builder.field("search_configuration_result", (Object)response.getResult());
                    builder.endObject();
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
                }
                catch (IOException e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Exception e) {
                try {
                    channel.sendResponse((RestResponse)new BytesRestResponse(channel, ExceptionsHelper.status((Throwable)e), e));
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to send error response", (Throwable)ex);
                }
            }
        });
    }

    @Generated
    public RestPutSearchConfigurationAction(SearchRelevanceSettingsAccessor settingsAccessor) {
        this.settingsAccessor = settingsAccessor;
    }
}

