/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.action;

import org.opensearch.OpenSearchException;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.performanceanalyzer.action.RequestType;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.PerformanceAnalyzerMetrics;

public class PerformanceAnalyzerActionListener<Response>
implements ActionListener<Response>,
MetricsProcessor {
    private RequestType type;
    private ActionListener<Response> original;
    private String id;
    private static final int KEYS_PATH_LENGTH = 3;

    void set(RequestType type, String id, ActionListener<Response> original) {
        this.type = type;
        this.id = id;
        this.original = original;
    }

    public void onResponse(Response response) {
        int responseStatus = -1;
        if (response instanceof BulkResponse) {
            BulkResponse bulk = (BulkResponse)response;
            responseStatus = bulk.status().getStatus();
        } else if (response instanceof SearchResponse) {
            SearchResponse search = (SearchResponse)response;
            responseStatus = search.status().getStatus();
        }
        if (responseStatus != -1) {
            long currTime = System.currentTimeMillis();
            this.saveMetricValues(PerformanceAnalyzerActionListener.generateFinishMetrics(currTime, responseStatus, ""), currTime, new String[]{this.type.toString(), this.id, "finish"});
        }
        this.original.onResponse(response);
    }

    public void onFailure(Exception exception) {
        long currTime = System.currentTimeMillis();
        if (exception instanceof OpenSearchException) {
            this.saveMetricValues(PerformanceAnalyzerActionListener.generateFinishMetrics(currTime, ((OpenSearchException)exception).status().getStatus(), exception.getClass().getName()), currTime, new String[]{this.type.toString(), this.id, "finish"});
        } else {
            this.saveMetricValues(PerformanceAnalyzerActionListener.generateFinishMetrics(currTime, -1, exception.getClass().getName()), currTime, new String[]{this.type.toString(), this.id, "finish"});
        }
        this.original.onFailure(exception);
    }

    static String generateStartMetrics(long startTime, String indices, int itemCount) {
        return PerformanceAnalyzerMetrics.getCurrentTimeMetric() + PerformanceAnalyzerMetrics.sMetricNewLineDelimitor + AllMetrics.HttpMetric.START_TIME.toString() + ":" + startTime + PerformanceAnalyzerMetrics.sMetricNewLineDelimitor + AllMetrics.HttpDimension.INDICES.toString() + ":" + indices + PerformanceAnalyzerMetrics.sMetricNewLineDelimitor + AllMetrics.HttpMetric.HTTP_REQUEST_DOCS.toString() + ":" + itemCount;
    }

    static String generateFinishMetrics(long finishTime, int status, String exception) {
        return PerformanceAnalyzerMetrics.getCurrentTimeMetric() + PerformanceAnalyzerMetrics.sMetricNewLineDelimitor + AllMetrics.HttpMetric.FINISH_TIME.toString() + ":" + finishTime + PerformanceAnalyzerMetrics.sMetricNewLineDelimitor + AllMetrics.HttpDimension.HTTP_RESP_CODE.toString() + ":" + status + PerformanceAnalyzerMetrics.sMetricNewLineDelimitor + AllMetrics.HttpDimension.EXCEPTION.toString() + ":" + exception;
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 3) {
            throw new RuntimeException("keys length should be 3");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"threads", "http", keysPath[0], keysPath[1], keysPath[2]});
    }
}

