/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.exception.WorkflowStepException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.ml.client.MachineLearningNodeClient;
import org.opensearch.ml.common.connector.ConnectorAction;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorInput;
import org.opensearch.ml.common.transport.connector.MLCreateConnectorResponse;

public class CreateConnectorStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(CreateConnectorStep.class);
    private MachineLearningNodeClient mlClient;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    public static final String NAME = "create_connector";

    public CreateConnectorStep(MachineLearningNodeClient mlClient, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler) {
        this.mlClient = mlClient;
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(final String currentNodeId, final WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs, Map<String, String> params, final String tenantId) {
        final PlainActionFuture createConnectorFuture = PlainActionFuture.newFuture();
        ActionListener<MLCreateConnectorResponse> actionListener = new ActionListener<MLCreateConnectorResponse>(this){
            final /* synthetic */ CreateConnectorStep this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(MLCreateConnectorResponse mlCreateConnectorResponse) {
                logger.info("Created connector successfully");
                this.this$0.flowFrameworkIndicesHandler.addResourceToStateIndex(currentNodeInputs, currentNodeId, this.this$0.getName(), mlCreateConnectorResponse.getConnectorId(), tenantId, (ActionListener<WorkflowData>)createConnectorFuture);
            }

            public void onFailure(Exception ex) {
                Exception e = WorkflowStepException.getSafeException(ex);
                String errorMessage = e == null ? "Failed to create connector" : ex.getMessage();
                logger.error(errorMessage, (Throwable)e);
                createConnectorFuture.onFailure((Exception)((Object)new WorkflowStepException(errorMessage, ExceptionsHelper.status((Throwable)e))));
            }
        };
        Set<String> requiredKeys = Set.of("name", "description", "version", "protocol", "parameters", "credential", "actions");
        Set<String> optionalKeys = Collections.emptySet();
        try {
            List<ConnectorAction> actions;
            Map<String, String> credentials;
            Map<String, String> parameters;
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(requiredKeys, optionalKeys, currentNodeInputs, outputs, previousNodeInputs, params);
            String name = (String)inputs.get("name");
            String description = (String)inputs.get("description");
            String version = (String)inputs.get("version");
            String protocol = (String)inputs.get("protocol");
            try {
                parameters = CreateConnectorStep.getParameterMap(inputs.get("parameters"));
                credentials = ParseUtils.getStringToStringMap(inputs.get("credential"), "credential");
                actions = CreateConnectorStep.getConnectorActionList(inputs.get("actions"));
            }
            catch (IllegalArgumentException iae) {
                logger.error("IllegalArgumentException in connector configuration", (Throwable)iae);
                throw new FlowFrameworkException("IllegalArgumentException in connector configuration", RestStatus.BAD_REQUEST);
            }
            catch (PrivilegedActionException pae) {
                logger.error("PrivilegedActionException in connector configuration", (Throwable)pae);
                throw new FlowFrameworkException("PrivilegedActionException in connector configuration", RestStatus.UNAUTHORIZED);
            }
            MLCreateConnectorInput mlInput = MLCreateConnectorInput.builder().name(name).description(description).version(version).protocol(protocol).parameters(parameters).credential(credentials).actions(actions).tenantId(tenantId).build();
            this.mlClient.createConnector(mlInput, (ActionListener)actionListener);
        }
        catch (FlowFrameworkException e) {
            createConnectorFuture.onFailure((Exception)((Object)e));
        }
        return createConnectorFuture;
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static Map<String, String> getParameterMap(Object parameterMap) throws PrivilegedActionException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : ParseUtils.getStringToStringMap(parameterMap, "parameters").entrySet()) {
            AccessController.doPrivileged(() -> {
                parameters.put((String)entry.getKey(), (String)entry.getValue());
                return null;
            });
        }
        return parameters;
    }

    private static List<ConnectorAction> getConnectorActionList(Object array) {
        if (!(array instanceof Map[])) {
            throw new IllegalArgumentException("[actions] must be an array of key-value maps.");
        }
        ArrayList<ConnectorAction> actions = new ArrayList<ConnectorAction>();
        for (Map map : (Map[])array) {
            String actionType = (String)map.get("action_type");
            if (actionType == null) {
                throw new IllegalArgumentException("[action_type] is missing.");
            }
            ConnectorAction action = ConnectorAction.builder().actionType(ConnectorAction.ActionType.valueOf((String)actionType.toUpperCase(Locale.ROOT))).method((String)map.get("method")).url((String)map.get("url")).headers((Map)map.get("headers")).requestBody((String)map.get("request_body")).preProcessFunction((String)map.get("pre_process_function")).postProcessFunction((String)map.get("post_process_function")).build();
            actions.add(action);
        }
        return actions;
    }
}

