/*
 * Decompiled with CFR 0.152.
 */
package ciir.umass.edu.metric;

import ciir.umass.edu.metric.APScorer;
import ciir.umass.edu.metric.BestAtKScorer;
import ciir.umass.edu.metric.DCGScorer;
import ciir.umass.edu.metric.ERRScorer;
import ciir.umass.edu.metric.METRIC;
import ciir.umass.edu.metric.MetricScorer;
import ciir.umass.edu.metric.NDCGScorer;
import ciir.umass.edu.metric.PrecisionScorer;
import ciir.umass.edu.metric.ReciprocalRankScorer;
import java.util.HashMap;

public class MetricScorerFactory {
    private static MetricScorer[] mFactory = new MetricScorer[]{new APScorer(), new NDCGScorer(), new DCGScorer(), new PrecisionScorer(), new ReciprocalRankScorer(), new BestAtKScorer(), new ERRScorer()};
    private static HashMap<String, MetricScorer> map = new HashMap();

    public MetricScorerFactory() {
        map.put("MAP", new APScorer());
        map.put("NDCG", new NDCGScorer());
        map.put("DCG", new DCGScorer());
        map.put("P", new PrecisionScorer());
        map.put("RR", new ReciprocalRankScorer());
        map.put("BEST", new BestAtKScorer());
        map.put("ERR", new ERRScorer());
    }

    public MetricScorer createScorer(METRIC metric) {
        return mFactory[metric.ordinal() - METRIC.MAP.ordinal()].copy();
    }

    public MetricScorer createScorer(METRIC metric, int k) {
        MetricScorer s = mFactory[metric.ordinal() - METRIC.MAP.ordinal()].copy();
        s.setK(k);
        return s;
    }

    public MetricScorer createScorer(String metric) {
        int k = -1;
        String m = "";
        MetricScorer s = null;
        if (metric.indexOf("@") != -1) {
            m = metric.substring(0, metric.indexOf("@"));
            k = Integer.parseInt(metric.substring(metric.indexOf("@") + 1));
            s = map.get(m.toUpperCase()).copy();
            s.setK(k);
        } else {
            s = map.get(metric.toUpperCase()).copy();
        }
        return s;
    }
}

