/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.Shape;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class NDUtils {
    private NDUtils() {
    }

    public static Shape getShapeFromEmptyNDArrayForReductionOp(Shape shape, int axis) {
        long[] shapeArr = shape.getShape();
        if (shapeArr[axis] == 0L) {
            throw new IllegalArgumentException("attempt to apply reduction of an empty NDArray");
        }
        long[] newShape = IntStream.range(0, shapeArr.length).filter(i -> i != axis).mapToLong(i -> shapeArr[i]).toArray();
        return new Shape(newShape);
    }

    public static void checkConcatInput(NDList list) {
        NDArray[] arrays = list.toArray(new NDArray[0]);
        if (Stream.of(arrays).allMatch(array -> array.getShape().dimension() == 0)) {
            throw new IllegalArgumentException("scalar(zero-dimensional) arrays cannot be concatenated");
        }
        int dimension = arrays[0].getShape().dimension();
        for (int i = 1; i < arrays.length; ++i) {
            if (arrays[i].getShape().dimension() == dimension) continue;
            throw new IllegalArgumentException("all the input arrays must have same number of dimensions, but the array at index 0 has " + dimension + " dimension(s) and the array at index " + i + " has " + arrays[i].getShape().dimension() + " dimension(s)");
        }
    }
}

