/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.format;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.sql.legacy.domain.IndexStatement;
import org.opensearch.sql.legacy.executor.format.DataRows;
import org.opensearch.sql.legacy.executor.format.ResultSet;
import org.opensearch.sql.legacy.executor.format.Schema;
import org.opensearch.transport.client.Client;

public class DescribeResultSet
extends ResultSet {
    private static final int DEFAULT_NUM_PREC_RADIX = 10;
    private static final String IS_AUTOINCREMENT = "NO";
    public static final String DEFAULT_OBJECT_DATATYPE = "object";
    private final IndexStatement statement;
    private final Object queryResult;

    public DescribeResultSet(Client client, IndexStatement statement, Object queryResult) {
        this.client = client;
        this.clusterName = this.getClusterName();
        this.statement = statement;
        this.queryResult = queryResult;
        this.schema = new Schema(statement, this.loadColumns());
        this.dataRows = new DataRows(this.loadRows());
    }

    private List<Schema.Column> loadColumns() {
        ArrayList<Schema.Column> columns = new ArrayList<Schema.Column>();
        columns.add(new Schema.Column("TABLE_CAT", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("TABLE_SCHEM", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("TABLE_NAME", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("COLUMN_NAME", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("DATA_TYPE", null, Schema.Type.INTEGER));
        columns.add(new Schema.Column("TYPE_NAME", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("COLUMN_SIZE", null, Schema.Type.INTEGER));
        columns.add(new Schema.Column("BUFFER_LENGTH", null, Schema.Type.INTEGER));
        columns.add(new Schema.Column("DECIMAL_DIGITS", null, Schema.Type.INTEGER));
        columns.add(new Schema.Column("NUM_PREC_RADIX", null, Schema.Type.INTEGER));
        columns.add(new Schema.Column("NULLABLE", null, Schema.Type.INTEGER));
        columns.add(new Schema.Column("REMARKS", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("COLUMN_DEF", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("SQL_DATA_TYPE", null, Schema.Type.INTEGER));
        columns.add(new Schema.Column("SQL_DATETIME_SUB", null, Schema.Type.INTEGER));
        columns.add(new Schema.Column("CHAR_OCTET_LENGTH", null, Schema.Type.INTEGER));
        columns.add(new Schema.Column("ORDINAL_POSITION", null, Schema.Type.INTEGER));
        columns.add(new Schema.Column("IS_NULLABLE", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("SCOPE_CATALOG", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("SCOPE_SCHEMA", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("SCOPE_TABLE", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("SOURCE_DATA_TYPE", null, Schema.Type.SHORT));
        columns.add(new Schema.Column("IS_AUTOINCREMENT", null, Schema.Type.KEYWORD));
        columns.add(new Schema.Column("IS_GENERATEDCOLUMN", null, Schema.Type.KEYWORD));
        return columns;
    }

    private List<DataRows.Row> loadRows() {
        ArrayList<DataRows.Row> rows = new ArrayList<DataRows.Row>();
        GetIndexResponse indexResponse = (GetIndexResponse)this.queryResult;
        Map indexMappings = indexResponse.getMappings();
        for (Map.Entry indexCursor : indexMappings.entrySet()) {
            String index = (String)indexCursor.getKey();
            if (!this.matchesPatternIfRegex(index, this.statement.getIndexPattern())) continue;
            rows.addAll(this.loadIndexData(index, ((MappingMetadata)indexCursor.getValue()).getSourceAsMap()));
        }
        return rows;
    }

    private List<DataRows.Row> loadIndexData(String index, Map<String, Object> mappingMetadata) {
        ArrayList<DataRows.Row> rows = new ArrayList<DataRows.Row>();
        Map<String, String> flattenedMetaData = this.flattenMappingMetaData(mappingMetadata, "", new HashMap<String, String>());
        int position = 1;
        for (Map.Entry<String, String> entry : flattenedMetaData.entrySet()) {
            String columnPattern = this.statement.getColumnPattern();
            if (columnPattern != null && !this.matchesPattern(entry.getKey(), columnPattern)) continue;
            rows.add(new DataRows.Row(this.loadRowData(index, entry.getKey(), entry.getValue(), position)));
            ++position;
        }
        return rows;
    }

    private Map<String, Object> loadRowData(String index, String column, String type, int position) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("TABLE_CAT", this.clusterName);
        data.put("TABLE_NAME", index);
        data.put("COLUMN_NAME", column);
        data.put("TYPE_NAME", type);
        data.put("NUM_PREC_RADIX", 10);
        data.put("NULLABLE", 2);
        data.put("ORDINAL_POSITION", position);
        data.put("IS_NULLABLE", "");
        data.put("IS_AUTOINCREMENT", IS_AUTOINCREMENT);
        data.put("IS_GENERATEDCOLUMN", "");
        return data;
    }

    private Map<String, String> flattenMappingMetaData(Map<String, Object> mappingMetaData, String currPath, Map<String, String> flattenedMapping) {
        Map properties = (Map)mappingMetaData.get("properties");
        for (Map.Entry entry : properties.entrySet()) {
            Map metaData = (Map)entry.getValue();
            String fullPath = this.addToPath(currPath, (String)entry.getKey());
            flattenedMapping.put(fullPath, metaData.getOrDefault("type", DEFAULT_OBJECT_DATATYPE));
            if (!metaData.containsKey("properties")) continue;
            flattenedMapping = this.flattenMappingMetaData(metaData, fullPath, flattenedMapping);
        }
        return flattenedMapping;
    }

    private String addToPath(String currPath, String field) {
        if (currPath.isEmpty()) {
            return field;
        }
        return currPath + "." + field;
    }
}

